/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.account.accesscontrol.Rights;
import com.zimbra.cs.account.ldap.Check;
import com.zimbra.cs.service.admin.AdminDocumentHandler;
import com.zimbra.cs.service.admin.AdminService;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckAuthConfig
extends AdminDocumentHandler {
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = CheckAuthConfig.getZimbraSoapContext(context);
        String name = request.getAttribute("name").toLowerCase();
        String password = request.getAttribute("password");
        Map<String, Object> attrs = AdminService.getAttrs(request, true);
        this.checkRight(zsc, context, null, Rights.Admin.R_checkExternalAuthConfig);
        Element response = zsc.createElement(AdminConstants.CHECK_AUTH_CONFIG_RESPONSE);
        Check.Result r = Check.checkAuthConfig(attrs, name, password);
        response.addElement("code").addText(r.getCode());
        String message = r.getMessage();
        if (message != null) {
            response.addElement("message").addText(message);
        }
        response.addElement("bindDn").addText(r.getComputedDn());
        return response;
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        relatedRights.add(Rights.Admin.R_checkExternalAuthConfig);
        notes.add(Rights.Admin.R_checkExternalAuthConfig.getName() + " is a domain right.  However CheckExchangeAuth does not take a " + "domain, thus the right has to be granted on the global grant " + "to be effective.");
    }
}

