/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AccountServiceException;
import com.zimbra.cs.account.Domain;
import com.zimbra.cs.account.GalContact;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.account.accesscontrol.Rights;
import com.zimbra.cs.service.admin.AdminDocumentHandler;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoCompleteGal
extends AdminDocumentHandler {
    public boolean domainAuthSufficient(Map context) {
        return true;
    }

    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        Provisioning.GAL_SEARCH_TYPE type;
        String n = request.getAttribute("name");
        ZimbraSoapContext zsc = AutoCompleteGal.getZimbraSoapContext(context);
        Account acct = AutoCompleteGal.getRequestedAccount(AutoCompleteGal.getZimbraSoapContext(context));
        while (n.endsWith("*")) {
            n = n.substring(0, n.length() - 1);
        }
        String domain = request.getAttribute("domain");
        String typeStr = request.getAttribute("type", "account");
        int max = (int)request.getAttributeLong("limit");
        if (typeStr.equals("all")) {
            type = Provisioning.GAL_SEARCH_TYPE.ALL;
        } else if (typeStr.equals("account")) {
            type = Provisioning.GAL_SEARCH_TYPE.USER_ACCOUNT;
        } else if (typeStr.equals("resource")) {
            type = Provisioning.GAL_SEARCH_TYPE.CALENDAR_RESOURCE;
        } else {
            throw ServiceException.INVALID_REQUEST("Invalid search type: " + typeStr, null);
        }
        Provisioning prov = Provisioning.getInstance();
        Domain d = prov.get(Provisioning.DomainBy.name, domain);
        if (d == null) {
            throw AccountServiceException.NO_SUCH_DOMAIN(domain);
        }
        this.checkDomainRight(zsc, d, (Object)Rights.Admin.R_accessGAL);
        Element response = zsc.createElement(AdminConstants.AUTO_COMPLETE_GAL_RESPONSE);
        Provisioning.SearchGalResult result = prov.autoCompleteGal(d, n, type, max);
        AutoCompleteGal.toXML(response, result);
        return response;
    }

    @Override
    public boolean needsAuth(Map<String, Object> context) {
        return true;
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        relatedRights.add(Rights.Admin.R_accessGAL);
    }

    public static void toXML(Element response, Provisioning.SearchGalResult result) throws ServiceException {
        response.addAttribute("more", result.getHadMore());
        response.addAttribute("tokenizeKey", result.getTokenizeKey());
        AutoCompleteGal.addContacts(response, result);
    }

    public static void addContacts(Element response, Provisioning.SearchGalResult result) throws ServiceException {
        ZimbraLog.gal.debug("GAL result total entries:" + result.getNumMatches());
        if (!(result instanceof Provisioning.VisitorSearchGalResult)) {
            for (GalContact contact : result.getMatches()) {
                AutoCompleteGal.addContact(response, contact);
            }
        }
    }

    public static void addContact(Element response, GalContact contact) {
        Element cn = response.addElement("cn");
        cn.addAttribute("id", contact.getId());
        Map<String, Object> attrs = contact.getAttrs();
        for (Map.Entry<String, Object> entry : attrs.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof String[]) {
                String[] sa = (String[])value;
                for (int i = 0; i < sa.length; ++i) {
                    cn.addKeyValuePair(entry.getKey(), sa[i], "a", "n");
                }
                continue;
            }
            cn.addKeyValuePair(entry.getKey(), (String)value, "a", "n");
        }
    }
}

