/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AccountServiceException;
import com.zimbra.cs.account.AuthToken;
import com.zimbra.cs.account.AuthTokenException;
import com.zimbra.cs.account.Domain;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.ZimbraAuthToken;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.account.auth.AuthContext;
import com.zimbra.cs.service.AuthProvider;
import com.zimbra.cs.service.admin.AdminDocumentHandler;
import com.zimbra.cs.session.Session;
import com.zimbra.cs.util.AccountUtil;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Auth
extends AdminDocumentHandler {
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        Provisioning.AccountBy by;
        String valuePassedIn;
        String virtualHost;
        ZimbraSoapContext zsc = Auth.getZimbraSoapContext(context);
        AuthToken at = null;
        Account acct = null;
        Provisioning prov = Provisioning.getInstance();
        Element authTokenEl = request.getOptionalElement("authToken");
        if (authTokenEl != null) {
            try {
                at = AuthProvider.getAuthToken(request, new HashMap());
                if (at == null) {
                    throw ServiceException.AUTH_EXPIRED();
                }
                com.zimbra.cs.service.account.Auth.addAccountToLogContextByAuthToken(prov, at);
                if (at.isExpired()) {
                    throw ServiceException.AUTH_EXPIRED();
                }
                acct = prov.get(Provisioning.AccountBy.id, at.getAccountId(), at);
                if (acct == null || !acct.getAccountStatus(prov).equals("active")) {
                    throw ServiceException.AUTH_EXPIRED();
                }
                this.checkAdmin(acct);
            }
            catch (AuthTokenException e) {
                throw ServiceException.AUTH_REQUIRED();
            }
        }
        String name = request.getAttribute("name", null);
        Element acctEl = request.getOptionalElement("account");
        if (name != null && acctEl != null) {
            throw ServiceException.INVALID_REQUEST("only one of <name> or <account> can be specified", null);
        }
        if (name == null && acctEl == null) {
            throw ServiceException.INVALID_REQUEST("missing <name> or <account>", null);
        }
        String password = request.getAttribute("password");
        Element virtualHostEl = request.getOptionalElement("virtualHost");
        String string = virtualHost = virtualHostEl == null ? null : virtualHostEl.getText().toLowerCase();
        if (name != null) {
            valuePassedIn = name;
            by = Provisioning.AccountBy.name;
        } else {
            valuePassedIn = acctEl.getText();
            String byStr = acctEl.getAttribute("by", Provisioning.AccountBy.name.name());
            by = Provisioning.AccountBy.fromString(byStr);
        }
        String value = valuePassedIn;
        try {
            Domain d;
            if (by == Provisioning.AccountBy.name && value.indexOf("@") == -1 && (acct = prov.get(Provisioning.AccountBy.adminName, value, zsc.getAuthToken())) == null && virtualHost != null && (d = prov.get(Provisioning.DomainBy.virtualHostname, virtualHost)) != null) {
                value = value + "@" + d.getName();
            }
            if (acct == null) {
                acct = prov.get(by, value);
            }
            if (acct == null) {
                throw AccountServiceException.AuthFailedServiceException.AUTH_FAILED(value, valuePassedIn, "account not found");
            }
            AccountUtil.addAccountToLogContext(prov, acct.getId(), "name", "id", null);
            ZimbraLog.security.info(ZimbraLog.encodeAttrs(new String[]{"cmd", "AdminAuth", "account", value}));
            HashMap<String, Object> authCtxt = new HashMap<String, Object>();
            authCtxt.put("ocip", context.get("orig.request.ip"));
            authCtxt.put("anp", valuePassedIn);
            authCtxt.put("ua", zsc.getUserAgent());
            prov.authAccount(acct, password, AuthContext.Protocol.soap, authCtxt);
            this.checkAdmin(acct);
            at = AuthProvider.getAuthToken(acct, true);
        }
        catch (ServiceException se) {
            ZimbraLog.security.warn(ZimbraLog.encodeAttrs(new String[]{"cmd", "AdminAuth", "account", value, "error", se.getMessage()}));
            throw se;
        }
        return this.doResponse(at, zsc, context, acct);
    }

    private AuthToken dummyYCCTokenTestNeverCallMe(Element authTokenEl) throws ServiceException, AuthTokenException {
        String atType = authTokenEl.getAttribute("type");
        if ("YAHOO_CALENDAR_AUTH_PROVIDER".equals(atType)) {
            for (Element a : authTokenEl.listElements("a")) {
                String name = a.getAttribute("n");
                String value = a.getText();
                if (!"ADMIN_AUTH_KEY".equals(name) || !"1210713456+dDedin1lO8d1_j8Kl.vl".equals(value)) continue;
                Account acct = Provisioning.getInstance().get(Provisioning.AccountBy.name, "admin@phoebe.mac");
                return new ZimbraAuthToken(acct, true);
            }
        }
        return null;
    }

    private void checkAdmin(Account acct) throws ServiceException {
        boolean ok;
        boolean isDomainAdmin = acct.getBooleanAttr("zimbraIsDomainAdminAccount", false);
        boolean isAdmin = acct.getBooleanAttr("zimbraIsAdminAccount", false);
        boolean isDelegatedAdmin = acct.getBooleanAttr("zimbraIsDelegatedAdminAccount", false);
        boolean bl = ok = isDomainAdmin || isAdmin || isDelegatedAdmin;
        if (!ok) {
            throw ServiceException.PERM_DENIED("not an admin account");
        }
    }

    private Element doResponse(AuthToken at, ZimbraSoapContext zsc, Map<String, Object> context, Account acct) throws ServiceException {
        Element response = zsc.createElement(AdminConstants.AUTH_RESPONSE);
        at.encodeAuthResp(response, true);
        response.addAttribute("lifetime", at.getExpires() - System.currentTimeMillis(), Element.Disposition.CONTENT);
        boolean isDomainAdmin = acct.getBooleanAttr("zimbraIsDomainAdminAccount", false);
        response.addElement("a").addAttribute("n", "zimbraIsDomainAdminAccount").setText(isDomainAdmin + "");
        Session session = this.updateAuthenticatedAccount(zsc, at, context, true);
        if (session != null) {
            ZimbraSoapContext.encodeSession(response, session.getSessionId(), session.getSessionType());
        }
        return response;
    }

    @Override
    public boolean needsAuth(Map<String, Object> context) {
        return false;
    }

    @Override
    public boolean needsAdminAuth(Map<String, Object> context) {
        return false;
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        notes.add("Do not need any right, all admins are allowed.");
    }
}

