/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.AuthToken;
import com.zimbra.cs.extension.ExtensionUtil;
import com.zimbra.cs.servlet.ZimbraServlet;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AdminFileDownload
extends ZimbraServlet {
    private static final String ACTION_GETBP = "getBP";
    private static final String ACTION_GETSR = "getSR";

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            AuthToken authToken = AdminFileDownload.getAdminAuthTokenFromCookie(req, resp);
            if (authToken == null) {
                return;
            }
            String action = req.getParameter("action");
            if (action == null || action.length() <= 0) {
                return;
            }
            ZimbraLog.webclient.debug("Receiving the file download request " + action);
            if (action.equalsIgnoreCase(ACTION_GETBP)) {
                String aid = req.getParameter("aid");
                String filename = "bp_result.csv";
                if (aid == null) {
                    ZimbraLog.webclient.error("Missing required parameter aid ");
                    return;
                }
                ZimbraLog.webclient.debug("Download the bulk provision status for uploaded file " + aid);
                resp.setHeader("Expires", "Tue, 24 Jan 2000 20:46:50 GMT");
                resp.setStatus(200);
                resp.setContentType("application/x-download");
                resp.setHeader("Content-Disposition", "attachment; filename=" + filename);
                AdminFileDownload.writeBulkProvisionResults((OutputStream)resp.getOutputStream(), aid);
                return;
            }
            if (action.equalsIgnoreCase(ACTION_GETSR)) {
                String filename = "search_result.csv";
                String query = req.getParameter("q");
                String domain = req.getParameter("domain");
                String types = req.getParameter("types");
                resp.setHeader("Expires", "Tue, 24 Jan 2000 20:46:50 GMT");
                resp.setStatus(200);
                resp.setContentType("application/x-download");
                resp.setHeader("Content-Disposition", "attachment; filename=" + filename);
                AdminFileDownload.writeSearchResults((OutputStream)resp.getOutputStream(), query, domain, types, authToken);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void writeBulkProvisionResults(OutputStream out, String aid) throws IOException {
        InputStream in = null;
        StringBuffer sb = new StringBuffer();
        try {
            try {
                Class<?> c = ExtensionUtil.findClass("com.zimbra.bp.BulkProvisionStatus");
                Class[] params = new Class[]{Class.forName("java.io.OutputStream"), Class.forName("java.lang.String")};
                Method m = c.getMethod("writeBpStatusOutputStream", params);
                Object[] paramValue = new Object[]{out, aid};
                m.invoke(c, paramValue);
            }
            catch (Exception e) {
                ZimbraLog.webclient.error(e);
                Object var9_10 = null;
                if (in == null) return;
                in.close();
                return;
            }
            Object var9_9 = null;
            if (in == null) return;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            if (in == null) throw throwable;
            in.close();
            throw throwable;
        }
        in.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void writeSearchResults(OutputStream out, String query, String domain, String types, AuthToken authToken) throws IOException {
        InputStream in = null;
        StringBuffer sb = new StringBuffer();
        try {
            try {
                Class<?> c = ExtensionUtil.findClass("com.zimbra.bp.SearchResults");
                Class[] params = new Class[]{Class.forName("java.io.OutputStream"), Class.forName("java.lang.String"), Class.forName("java.lang.String"), Class.forName("java.lang.String"), Class.forName("com.zimbra.cs.account.AuthToken")};
                Method m = c.getMethod("writeSearchResultOutputStream", params);
                Object[] paramValue = new Object[]{out, query, domain, types, authToken};
                m.invoke(c, paramValue);
            }
            catch (Exception e) {
                ZimbraLog.webclient.error(e);
                Object var12_13 = null;
                if (in == null) return;
                in.close();
                return;
            }
            Object var12_12 = null;
            if (in == null) return;
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            if (in == null) throw throwable;
            in.close();
            throw throwable;
        }
        in.close();
    }
}

