/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.account.AccessManager;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AttributeClass;
import com.zimbra.cs.account.AttributeManager;
import com.zimbra.cs.account.AuthToken;
import com.zimbra.cs.account.CalendarResource;
import com.zimbra.cs.account.Cos;
import com.zimbra.cs.account.DistributionList;
import com.zimbra.cs.account.Domain;
import com.zimbra.cs.account.Entry;
import com.zimbra.cs.account.NamedEntry;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Server;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.account.accesscontrol.TargetType;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.operation.BlockingOperation;
import com.zimbra.cs.operation.Requester;
import com.zimbra.cs.operation.Scheduler;
import com.zimbra.cs.service.admin.AdminAccessControl;
import com.zimbra.cs.service.admin.AdminRightCheckPoint;
import com.zimbra.cs.session.Session;
import com.zimbra.soap.DocumentHandler;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AdminDocumentHandler
extends DocumentHandler
implements AdminRightCheckPoint {
    @Override
    public Object preHandle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = AdminDocumentHandler.getZimbraSoapContext(context);
        Session session = this.getSession(zsc);
        OperationContext octxt = null;
        Mailbox mbox = null;
        if (zsc.getAuthToken() != null) {
            octxt = AdminDocumentHandler.getOperationContext(zsc, context);
        }
        return BlockingOperation.schedule(request.getName(), session, octxt, mbox, Requester.ADMIN, this.getSchedulerPriority(), 1);
    }

    @Override
    public void postHandle(Object userObj) {
        ((BlockingOperation)userObj).finish();
    }

    protected Scheduler.Priority getSchedulerPriority() {
        return Scheduler.Priority.INTERACTIVE_HIGH;
    }

    @Override
    public boolean needsAuth(Map<String, Object> context) {
        return true;
    }

    @Override
    public boolean needsAdminAuth(Map<String, Object> context) {
        return true;
    }

    @Override
    public boolean isAdminCommand() {
        return true;
    }

    protected String[] getProxiedAccountPath() {
        return null;
    }

    protected String[] getProxiedAccountElementPath() {
        return null;
    }

    protected String[] getProxiedResourcePath() {
        return null;
    }

    protected String[] getProxiedResourceElementPath() {
        return null;
    }

    protected String[] getProxiedServerPath() {
        return null;
    }

    protected Account getAccount(Provisioning prov, Provisioning.AccountBy accountBy, String value, AuthToken authToken) throws ServiceException {
        Account acct = null;
        try {
            acct = prov.get(accountBy, value, true, authToken);
        }
        catch (ServiceException e) {
            acct = prov.get(accountBy, value, false, authToken);
        }
        return acct;
    }

    private CalendarResource getCalendarResource(Provisioning prov, Provisioning.CalendarResourceBy crBy, String value, AuthToken authToken) throws ServiceException {
        CalendarResource cr = null;
        try {
            cr = prov.get(crBy, value, true);
        }
        catch (ServiceException e) {
            cr = prov.get(crBy, value, false);
        }
        return cr;
    }

    @Override
    protected Element proxyIfNecessary(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = AdminDocumentHandler.getZimbraSoapContext(context);
        if (zsc.getProxyTarget() != null) {
            return null;
        }
        try {
            String serverId;
            Server server;
            CalendarResource rsrc;
            Element resourceElt;
            Server server2;
            CalendarResource rsrc2;
            String rsrcId;
            Account acct;
            Element acctElt;
            Account acct2;
            String acctId;
            Provisioning prov = Provisioning.getInstance();
            String[] xpath = this.getProxiedAccountPath();
            String string = acctId = xpath != null ? AdminDocumentHandler.getXPath(request, xpath) : null;
            if (acctId != null && (acct2 = this.getAccount(prov, Provisioning.AccountBy.id, acctId, zsc.getAuthToken())) != null && !Provisioning.onLocalServer(acct2)) {
                return this.proxyRequest(request, context, acctId);
            }
            xpath = this.getProxiedAccountElementPath();
            Element element = acctElt = xpath != null ? AdminDocumentHandler.getXPathElement(request, xpath) : null;
            if (acctElt != null && (acct = this.getAccount(prov, Provisioning.AccountBy.fromString(acctElt.getAttribute("by")), acctElt.getText(), zsc.getAuthToken())) != null && !Provisioning.onLocalServer(acct)) {
                return this.proxyRequest(request, context, acct.getId());
            }
            xpath = this.getProxiedResourcePath();
            String string2 = rsrcId = xpath != null ? AdminDocumentHandler.getXPath(request, xpath) : null;
            if (rsrcId != null && (rsrc2 = this.getCalendarResource(prov, Provisioning.CalendarResourceBy.id, rsrcId, zsc.getAuthToken())) != null && (server2 = prov.get(Provisioning.ServerBy.name, rsrc2.getAttr("zimbraMailHost"))) != null && !AdminDocumentHandler.getLocalHostId().equalsIgnoreCase(server2.getId())) {
                return this.proxyRequest(request, context, server2);
            }
            xpath = this.getProxiedResourceElementPath();
            Element element2 = resourceElt = xpath != null ? AdminDocumentHandler.getXPathElement(request, xpath) : null;
            if (resourceElt != null && (rsrc = this.getCalendarResource(prov, Provisioning.CalendarResourceBy.fromString(resourceElt.getAttribute("by")), resourceElt.getText(), zsc.getAuthToken())) != null && (server = prov.get(Provisioning.ServerBy.name, rsrc.getAttr("zimbraMailHost"))) != null && !AdminDocumentHandler.getLocalHostId().equalsIgnoreCase(server.getId())) {
                return this.proxyRequest(request, context, server);
            }
            xpath = this.getProxiedServerPath();
            String string3 = serverId = xpath != null ? AdminDocumentHandler.getXPath(request, xpath) : null;
            if (serverId != null && (server = prov.get(Provisioning.ServerBy.id, serverId)) != null && !AdminDocumentHandler.getLocalHostId().equalsIgnoreCase(server.getId())) {
                return this.proxyRequest(request, context, server);
            }
            return null;
        }
        catch (ServiceException e) {
            if ("service.PROXY_ERROR".equals(e.getCode())) {
                return null;
            }
            throw e;
        }
    }

    @Override
    public Session.Type getDefaultSessionType() {
        return Session.Type.ADMIN;
    }

    protected Set<String> getReqAttrs(Element request, AttributeClass klass) throws ServiceException {
        String attrsStr = request.getAttribute("attrs", null);
        if (attrsStr == null) {
            return null;
        }
        String[] attrs = attrsStr.split(",");
        Set<String> attrsOnEntry = AttributeManager.getInstance().getAllAttrsInClass(klass);
        HashSet<String> validAttrs = new HashSet<String>();
        for (String attr : attrs) {
            if (!attrsOnEntry.contains(attr)) {
                throw ServiceException.INVALID_REQUEST("requested attribute " + attr + " is not on " + klass.name(), null);
            }
            validAttrs.add(attr);
        }
        return validAttrs;
    }

    public boolean isDomainAdminOnly(ZimbraSoapContext zsc) {
        return AccessManager.getInstance().isDomainAdminOnly(zsc.getAuthToken());
    }

    public Domain getAuthTokenAccountDomain(ZimbraSoapContext zsc) throws ServiceException {
        return AccessManager.getInstance().getDomain(zsc.getAuthToken());
    }

    protected boolean canAccessDomain(ZimbraSoapContext zsc, String domainName) throws ServiceException {
        return AccessManager.getInstance().canAccessDomain(zsc.getAuthToken(), domainName);
    }

    protected boolean canAccessDomain(ZimbraSoapContext zsc, Domain domain) throws ServiceException {
        return this.canAccessDomain(zsc, domain.getName());
    }

    protected boolean canModifyMailQuota(ZimbraSoapContext zsc, Account target, long mailQuota) throws ServiceException {
        return AccessManager.getInstance().canModifyMailQuota(zsc.getAuthToken(), target, mailQuota);
    }

    public boolean canAccessEmail(ZimbraSoapContext zsc, String email) throws ServiceException {
        return this.canAccessDomain(zsc, AdminAccessControl.getDomainFromEmail(email));
    }

    public void checkModifyAttrs(ZimbraSoapContext zsc, AttributeClass attrClass, Map<String, Object> attrs) throws ServiceException {
        AdminAccessControl.getAdminAccessControl(zsc).checkModifyAttrs(attrClass, attrs);
    }

    protected void checkSetAttrsOnCreate(ZimbraSoapContext zsc, TargetType targetType, String entryName, Map<String, Object> attrs) throws ServiceException {
        AdminAccessControl.getAdminAccessControl(zsc).checkSetAttrsOnCreate(targetType, entryName, attrs);
    }

    protected boolean hasRightsToList(ZimbraSoapContext zsc, NamedEntry target, AdminRight listRight, Object getAttrRight) throws ServiceException {
        return AdminAccessControl.getAdminAccessControl(zsc).hasRightsToList(target, listRight, getAttrRight);
    }

    protected boolean hasRightsToListCos(ZimbraSoapContext zsc, Cos target, AdminRight listRight, Object getAttrRight) throws ServiceException {
        return AdminAccessControl.getAdminAccessControl(zsc).hasRightsToListCos(target, listRight, getAttrRight);
    }

    protected AdminAccessControl checkRight(ZimbraSoapContext zsc, Map<String, Object> context, Entry target, Object needed) throws ServiceException {
        AccessManager am = AccessManager.getInstance();
        if (AdminAccessControl.isDomainBasedAccessManager(am)) {
            if (this.isDomainAdminOnly(zsc) && !this.domainAuthSufficient(context)) {
                throw ServiceException.PERM_DENIED("cannot access entry");
            }
            return AdminAccessControl.getAdminAccessControl(zsc);
        }
        return AdminDocumentHandler.checkRight(zsc, target, needed);
    }

    public static AdminAccessControl checkRight(ZimbraSoapContext zsc, Entry target, Object needed) throws ServiceException {
        AdminAccessControl aac = AdminAccessControl.getAdminAccessControl(zsc);
        aac.checkRight(target, needed);
        return aac;
    }

    protected AdminAccessControl checkCosRight(ZimbraSoapContext zsc, Cos cos, Object needed) throws ServiceException {
        AdminAccessControl aac = AdminAccessControl.getAdminAccessControl(zsc);
        aac.checkCosRight(cos, needed);
        return aac;
    }

    protected AdminAccessControl checkAccountRight(ZimbraSoapContext zsc, Account account, Object needed) throws ServiceException {
        AdminAccessControl aac = AdminAccessControl.getAdminAccessControl(zsc);
        aac.checkAccountRight(this, account, needed);
        return aac;
    }

    protected AdminAccessControl checkCalendarResourceRight(ZimbraSoapContext zsc, CalendarResource cr, Object needed) throws ServiceException {
        AdminAccessControl aac = AdminAccessControl.getAdminAccessControl(zsc);
        aac.checkCalendarResourceRight(this, cr, needed);
        return aac;
    }

    protected AdminAccessControl checkDistributionListRight(ZimbraSoapContext zsc, DistributionList dl, Object needed) throws ServiceException {
        AdminAccessControl aac = AdminAccessControl.getAdminAccessControl(zsc);
        aac.checkDistributionListRight(this, dl, needed);
        return aac;
    }

    protected AdminAccessControl checkDomainRightByEmail(ZimbraSoapContext zsc, String email, AdminRight needed) throws ServiceException {
        AdminAccessControl aac = AdminAccessControl.getAdminAccessControl(zsc);
        aac.checkDomainRightByEmail(this, email, needed);
        return aac;
    }

    protected AdminAccessControl checkDomainRight(ZimbraSoapContext zsc, String domainName, Object needed) throws ServiceException {
        AdminAccessControl aac = AdminAccessControl.getAdminAccessControl(zsc);
        aac.checkDomainRight(this, domainName, needed);
        return aac;
    }

    protected AdminAccessControl checkDomainRight(ZimbraSoapContext zsc, Domain domain, Object needed) throws ServiceException {
        AdminAccessControl aac = AdminAccessControl.getAdminAccessControl(zsc);
        aac.checkDomainRight(this, domain, needed);
        return aac;
    }

    protected void checkRightTODO() {
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        notes.add("TDB");
    }
}

