/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.EmailUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.AccessManager;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.Alias;
import com.zimbra.cs.account.AttributeClass;
import com.zimbra.cs.account.AttributeManager;
import com.zimbra.cs.account.AuthToken;
import com.zimbra.cs.account.CalendarResource;
import com.zimbra.cs.account.Cos;
import com.zimbra.cs.account.DistributionList;
import com.zimbra.cs.account.Domain;
import com.zimbra.cs.account.Entry;
import com.zimbra.cs.account.NamedEntry;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.accesscontrol.ACLAccessManager;
import com.zimbra.cs.account.accesscontrol.AccessControlUtil;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.account.accesscontrol.AttrRight;
import com.zimbra.cs.account.accesscontrol.GranteeType;
import com.zimbra.cs.account.accesscontrol.Right;
import com.zimbra.cs.account.accesscontrol.RightCommand;
import com.zimbra.cs.account.accesscontrol.Rights;
import com.zimbra.cs.account.accesscontrol.TargetType;
import com.zimbra.cs.service.admin.AdminDocumentHandler;
import com.zimbra.soap.DocumentHandler;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AdminAccessControl {
    protected AccessManager mAccessMgr;
    protected ZimbraSoapContext mZsc;
    protected Account mAuthedAcct;
    protected AuthToken mAuthToken;

    public static AdminAccessControl getAdminAccessControl(ZimbraSoapContext zsc) throws ServiceException {
        Account authedAcct = DocumentHandler.getAuthenticatedAccount(zsc);
        AuthToken authToken = zsc.getAuthToken();
        return AdminAccessControl.newAdminAccessControl(zsc, authToken, authedAcct);
    }

    public static AdminAccessControl getAdminAccessControl(AuthToken authToken) throws ServiceException {
        String acctId = authToken.getAccountId();
        Account authedAcct = Provisioning.getInstance().get(Provisioning.AccountBy.id, acctId);
        if (authedAcct == null) {
            throw ServiceException.AUTH_REQUIRED();
        }
        return AdminAccessControl.newAdminAccessControl(null, authToken, authedAcct);
    }

    public abstract boolean isSufficientAdminForSoap(Map<String, Object> var1, DocumentHandler var2);

    public abstract boolean isSufficientAdminForZimletFilterServlet();

    public static boolean isSufficientAdminForSoapDelegatedAuth(Account acct) {
        AccessManager accessMgr = AccessManager.getInstance();
        boolean isAdmin = AdminAccessControl.isDomainBasedAccessManager(accessMgr) ? acct.getBooleanAttr("zimbraIsDomainAdminAccount", false) || acct.getBooleanAttr("zimbraIsAdminAccount", false) : acct.getBooleanAttr("zimbraIsDelegatedAdminAccount", false) || acct.getBooleanAttr("zimbraIsAdminAccount", false);
        return isAdmin;
    }

    public abstract void checkModifyAttrs(AttributeClass var1, Map<String, Object> var2) throws ServiceException;

    public abstract void checkSetAttrsOnCreate(TargetType var1, String var2, Map<String, Object> var3) throws ServiceException;

    public abstract boolean hasRightsToList(NamedEntry var1, AdminRight var2, Object var3) throws ServiceException;

    public abstract boolean hasRightsToListCos(Cos var1, AdminRight var2, Object var3) throws ServiceException;

    public abstract void checkRight(Entry var1, Object var2) throws ServiceException;

    public abstract void checkCosRight(Cos var1, Object var2) throws ServiceException;

    public abstract void checkAccountRight(AdminDocumentHandler var1, Account var2, Object var3) throws ServiceException;

    public abstract void checkCalendarResourceRight(AdminDocumentHandler var1, CalendarResource var2, Object var3) throws ServiceException;

    public abstract void checkDistributionListRight(AdminDocumentHandler var1, DistributionList var2, Object var3) throws ServiceException;

    public abstract void checkDomainRightByEmail(AdminDocumentHandler var1, String var2, AdminRight var3) throws ServiceException;

    public abstract void checkDomainRight(AdminDocumentHandler var1, String var2, Object var3) throws ServiceException;

    public abstract void checkDomainRight(AdminDocumentHandler var1, Domain var2, Object var3) throws ServiceException;

    public abstract AccessManager.AttrRightChecker getAttrRightChecker(Entry var1) throws ServiceException;

    private AdminAccessControl(AccessManager accessMgr, ZimbraSoapContext zsc, AuthToken authToken, Account authedAcct) {
        this.mAccessMgr = accessMgr;
        this.mZsc = zsc;
        this.mAuthToken = authToken;
        this.mAuthedAcct = authedAcct;
    }

    private static AdminAccessControl newAdminAccessControl(ZimbraSoapContext zsc, AuthToken authToken, Account authedAcct) {
        AccessManager accessMgr = AccessManager.getInstance();
        if (AdminAccessControl.isDomainBasedAccessManager(accessMgr)) {
            return new DomainAccessControl(accessMgr, zsc, authToken, authedAcct);
        }
        return new ACLAccessControl(accessMgr, zsc, authToken, authedAcct);
    }

    public boolean isDomainAdminOnly() {
        return this.mAccessMgr.isDomainAdminOnly(this.mAuthToken);
    }

    static boolean isDomainBasedAccessManager(AccessManager am) {
        return !(am instanceof ACLAccessManager);
    }

    protected void checkDomainStatus(Entry target) throws ServiceException {
        Domain domain = target instanceof Domain ? (Domain)target : TargetType.getTargetDomain(Provisioning.getInstance(), target);
        this.mAccessMgr.checkDomainStatus(domain);
    }

    static String getDomainFromEmail(String email) throws ServiceException {
        String[] parts = EmailUtil.getLocalPartAndDomain(email);
        if (parts == null) {
            throw ServiceException.INVALID_REQUEST("must be valid email address: " + email, null);
        }
        return parts[1];
    }

    protected void soapOnly() throws ServiceException {
        if (this.mZsc == null) {
            throw ServiceException.FAILURE("internal error, called from non-SOAP servlet", null);
        }
    }

    public static class SetAttrsRightWithConstraintChecking
    extends DynamicAttrsRight {
        private Map<String, Object> mAttrs = new HashMap<String, Object>();

        public void addAttr(String attrName, Object attrValue) {
            this.mAttrs.put(attrName, attrValue);
        }

        boolean checkRight(AccessManager am, Account authedAcct, Entry target) throws ServiceException {
            return am.canSetAttrs(authedAcct, target, this.mAttrs, true);
        }
    }

    public static class SetAttrsRight
    extends DynamicAttrsRight {
        private Set<String> mAttrs = new HashSet<String>();

        public void addAttr(String attrName) {
            this.mAttrs.add(attrName);
        }

        boolean checkRight(AccessManager am, Account authedAcct, Entry target) throws ServiceException {
            return am.canSetAttrs(authedAcct, target, this.mAttrs, true);
        }
    }

    public static class GetAttrsRight
    extends DynamicAttrsRight {
        private Set<String> mAttrs = new HashSet<String>();

        public void addAttr(String attrName) {
            this.mAttrs.add(attrName);
        }

        boolean checkRight(AccessManager am, Account authedAcct, Entry target) throws ServiceException {
            return am.canGetAttrs(authedAcct, target, this.mAttrs, true);
        }
    }

    public static abstract class DynamicAttrsRight {
        abstract boolean checkRight(AccessManager var1, Account var2, Entry var3) throws ServiceException;
    }

    static class AttributeRightChecker
    implements AccessManager.AttrRightChecker {
        private AccessManager.AttrRightChecker mRightChecker;

        private AttributeRightChecker(AdminAccessControl accessControl, Entry target) throws ServiceException {
            this.mRightChecker = accessControl.mAccessMgr.canGetAttrs(accessControl.mAuthedAcct, target, true);
        }

        public boolean allowAttr(String attrName) {
            return this.mRightChecker.allowAttr(attrName);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SearchDirectoryRightChecker
    implements NamedEntry.CheckRight {
        private AdminAccessControl mAC;
        private Provisioning mProv;
        private Set<String> mReqAttrs;
        RightCommand.AllEffectiveRights mAllEffRights;

        public SearchDirectoryRightChecker(AdminAccessControl accessControl, Provisioning prov, Set<String> reqAttrs) throws ServiceException {
            this.mAC = accessControl;
            this.mProv = prov == null ? Provisioning.getInstance() : prov;
            this.mReqAttrs = reqAttrs;
        }

        private boolean hasRightsToList(NamedEntry target, AdminRight listRight) throws ServiceException {
            RightCommand.EffectiveRights er;
            try {
                Boolean hardRulesResult = AccessControlUtil.checkHardRules(this.mAC.mAuthedAcct, true, target, listRight);
                if (hardRulesResult != null) {
                    return hardRulesResult;
                }
            }
            catch (ServiceException e) {
                if ("service.PERM_DENIED".equals(e.getCode())) {
                    ZimbraLog.acl.warn(this.getClass().getName() + ": skipping entry " + target.getName() + ": " + e.getMessage());
                    return false;
                }
                throw e;
            }
            if (this.mAllEffRights == null) {
                this.mAllEffRights = this.mProv.getAllEffectiveRights(GranteeType.GT_USER.getCode(), Provisioning.GranteeBy.id, this.mAC.mAuthedAcct.getId(), false, false);
            }
            TargetType targetType = listRight.getTargetType();
            RightCommand.RightsByTargetType rbtt = this.mAllEffRights.rightsByTargetType().get((Object)targetType);
            if (rbtt == null || rbtt.hasNoRight()) {
                return false;
            }
            String targetName = target.getName();
            for (RightCommand.RightAggregation rightsByEntries : rbtt.entries()) {
                if (!rightsByEntries.entries().contains(targetName)) continue;
                RightCommand.EffectiveRights effRights = rightsByEntries.effectiveRights();
                return this.hasRight(effRights, target, listRight);
            }
            Domain targetDomain = TargetType.getTargetDomain(this.mProv, target);
            if (targetDomain != null && rbtt instanceof RightCommand.DomainedRightsByTargetType) {
                String domainName = targetDomain.getName();
                RightCommand.DomainedRightsByTargetType domainedRights = (RightCommand.DomainedRightsByTargetType)rbtt;
                for (RightCommand.RightAggregation rightsByDomains : domainedRights.domains()) {
                    if (!rightsByDomains.entries().contains(domainName)) continue;
                    RightCommand.EffectiveRights effRights = rightsByDomains.effectiveRights();
                    return this.hasRight(effRights, target, listRight);
                }
            }
            return this.hasRight(er = rbtt.all(), target, listRight);
        }

        private boolean hasRight(RightCommand.EffectiveRights effRights, NamedEntry target, AdminRight listRight) {
            if (effRights == null) {
                return false;
            }
            List<String> presetRights = effRights.presetRights();
            return presetRights != null && presetRights.contains(listRight.getName());
        }

        private boolean hasRightsToListDanglingAlias(Alias alias) throws ServiceException {
            return this.mAC.hasRightsToList(alias, AdminRight.PR_SYSTEM_ADMIN_ONLY, null);
        }

        private boolean hasRightsToListAlias(Alias alias) throws ServiceException {
            TargetType tt = alias.getTargetType(this.mProv);
            boolean hasRight = tt == null ? this.hasRightsToListDanglingAlias(alias) : this.allow(alias.getTarget(this.mProv));
            return hasRight;
        }

        private AdminRight needRight(NamedEntry entry) throws ServiceException {
            if (entry instanceof CalendarResource) {
                return Rights.Admin.R_listCalendarResource;
            }
            if (entry instanceof Account) {
                return Rights.Admin.R_listAccount;
            }
            if (entry instanceof DistributionList) {
                return Rights.Admin.R_listDistributionList;
            }
            if (entry instanceof Domain) {
                return Rights.Admin.R_listDomain;
            }
            if (entry instanceof Cos) {
                return Rights.Admin.R_listCos;
            }
            return null;
        }

        @Override
        public boolean allow(NamedEntry entry) throws ServiceException {
            if (entry instanceof Alias) {
                return this.hasRightsToListAlias((Alias)entry);
            }
            AdminRight listRightNeeded = this.needRight(entry);
            if (listRightNeeded != null) {
                return this.hasRightsToList(entry, listRightNeeded);
            }
            return false;
        }

        public List getAllowed(List entries) throws ServiceException {
            ArrayList<NamedEntry> allowedEntries = new ArrayList<NamedEntry>();
            for (int i = 0; i < entries.size(); ++i) {
                NamedEntry entry = (NamedEntry)entries.get(i);
                if (!this.allow(entry)) continue;
                allowedEntries.add(entry);
            }
            return allowedEntries;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ACLAccessControl
    extends AdminAccessControl {
        private ACLAccessControl(AccessManager accessMgr, ZimbraSoapContext zsc, AuthToken authToken, Account authedAcct) {
            super(accessMgr, zsc, authToken, authedAcct);
        }

        @Override
        public boolean isSufficientAdminForSoap(Map<String, Object> soapCtxt, DocumentHandler handler) {
            return this.mAuthToken.isAdmin() || this.mAuthToken.isDelegatedAdmin();
        }

        @Override
        public boolean isSufficientAdminForZimletFilterServlet() {
            return this.mAuthToken.isAdmin() || this.mAuthToken.isDelegatedAdmin();
        }

        @Override
        public void checkModifyAttrs(AttributeClass attrClass, Map<String, Object> attrs) throws ServiceException {
            throw ServiceException.FAILURE("internal error", null);
        }

        @Override
        public void checkSetAttrsOnCreate(TargetType targetType, String entryName, Map<String, Object> attrs) throws ServiceException {
            boolean hasRight = this.mAccessMgr.canSetAttrsOnCreate(this.mAuthedAcct, targetType, entryName, attrs, true);
            if (!hasRight) {
                throw ServiceException.PERM_DENIED("cannot set attrs");
            }
        }

        @Override
        public boolean hasRightsToList(NamedEntry target, AdminRight listRight, Object getAttrRight) throws ServiceException {
            try {
                this.checkRight(target, listRight);
            }
            catch (ServiceException e) {
                if ("service.PERM_DENIED".equals(e.getCode())) {
                    ZimbraLog.acl.warn(this.getClass().getName() + ": skipping entry " + target.getName() + ": " + e.getMessage());
                    return false;
                }
                throw e;
            }
            if (getAttrRight == null) {
                return true;
            }
            if (getAttrRight instanceof Set && ((Set)getAttrRight).isEmpty()) {
                ZimbraLog.acl.warn(this.getClass().getName() + ": skipping entry " + target.getName() + ": " + "non of the requested attrs is valid on the entry");
                return false;
            }
            try {
                this.checkRight(target, getAttrRight);
            }
            catch (ServiceException e) {
                if ("service.PERM_DENIED".equals(e.getCode())) {
                    ZimbraLog.acl.warn(this.getClass().getName() + ": skipping entry " + target.getName() + ": " + e.getMessage());
                    return false;
                }
                throw e;
            }
            return true;
        }

        @Override
        public boolean hasRightsToListCos(Cos target, AdminRight listRight, Object getAttrRight) throws ServiceException {
            return this.hasRightsToList(target, listRight, getAttrRight);
        }

        @Override
        public void checkRight(Entry target, Object needed) throws ServiceException {
            if (target == null) {
                target = Provisioning.getInstance().getGlobalGrant();
            }
            if (!this.doCheckRight(target, needed)) {
                throw ServiceException.PERM_DENIED(this.printNeededRight(target, needed));
            }
        }

        @Override
        public void checkCosRight(Cos cos, Object needed) throws ServiceException {
            if (!this.doCheckRight(cos, needed)) {
                throw ServiceException.PERM_DENIED(this.printNeededRight(cos, needed));
            }
        }

        @Override
        public void checkAccountRight(AdminDocumentHandler handler, Account account, Object needed) throws ServiceException {
            this.soapOnly();
            this.checkDomainStatus(account);
            Boolean canAccess = handler.canAccessAccountCommon(this.mZsc, account, false);
            boolean hasRight = canAccess == null ? this.doCheckRight(account, needed) : canAccess.booleanValue();
            if (!hasRight) {
                throw ServiceException.PERM_DENIED(this.printNeededRight(account, needed));
            }
        }

        @Override
        public void checkCalendarResourceRight(AdminDocumentHandler handler, CalendarResource cr, Object needed) throws ServiceException {
            this.soapOnly();
            this.checkDomainStatus(cr);
            Boolean canAccess = handler.canAccessAccountCommon(this.mZsc, cr, false);
            boolean hasRight = canAccess == null ? this.doCheckRight(cr, needed) : canAccess.booleanValue();
            if (!hasRight) {
                throw ServiceException.PERM_DENIED(this.printNeededRight(cr, needed));
            }
        }

        @Override
        public void checkDistributionListRight(AdminDocumentHandler handler, DistributionList dl, Object needed) throws ServiceException {
            this.soapOnly();
            this.checkDomainStatus(dl);
            if (!this.doCheckRight(dl, needed)) {
                throw ServiceException.PERM_DENIED(this.printNeededRight(dl, needed));
            }
        }

        @Override
        public void checkDomainRightByEmail(AdminDocumentHandler handler, String email, AdminRight needed) throws ServiceException {
            this.soapOnly();
            String domainName = ACLAccessControl.getDomainFromEmail(email);
            Domain domain = Provisioning.getInstance().get(Provisioning.DomainBy.name, domainName);
            if (domain == null) {
                throw ServiceException.PERM_DENIED("no such domain: " + domainName);
            }
            this.checkDomainStatus(domain);
            if (!this.doCheckRight(domain, needed)) {
                throw ServiceException.PERM_DENIED(this.printNeededRight(domain, needed));
            }
        }

        @Override
        public void checkDomainRight(AdminDocumentHandler handler, String domainName, Object needed) throws ServiceException {
            this.soapOnly();
            Domain domain = Provisioning.getInstance().get(Provisioning.DomainBy.name, domainName);
            if (domain == null) {
                throw ServiceException.PERM_DENIED("no such domain: " + domainName);
            }
            if (!this.doCheckRight(domain, needed)) {
                throw ServiceException.PERM_DENIED(this.printNeededRight(domain, needed));
            }
        }

        @Override
        public void checkDomainRight(AdminDocumentHandler handler, Domain domain, Object needed) throws ServiceException {
            this.soapOnly();
            if (!this.doCheckRight(domain, needed)) {
                throw ServiceException.PERM_DENIED(this.printNeededRight(domain, needed));
            }
        }

        @Override
        public AccessManager.AttrRightChecker getAttrRightChecker(Entry target) throws ServiceException {
            return new AttributeRightChecker(this, target);
        }

        private boolean doCheckRight(Entry target, Object needed) throws ServiceException {
            if (needed instanceof AdminRight) {
                AdminRight adminRight = (AdminRight)needed;
                if (adminRight.isPresetRight()) {
                    return this.mAccessMgr.canDo(this.mAuthedAcct, target, (Right)((AdminRight)needed), true, null);
                }
                if (adminRight.isAttrRight()) {
                    if (adminRight.getRightType() == Right.RightType.getAttrs) {
                        return this.mAccessMgr.canGetAttrs(this.mAuthedAcct, target, ((AttrRight)needed).getAttrs(), true);
                    }
                    if (adminRight.getRightType() == Right.RightType.setAttrs) {
                        return this.mAccessMgr.canSetAttrs(this.mAuthedAcct, target, ((AttrRight)needed).getAttrs(), true);
                    }
                }
                throw ServiceException.FAILURE("internal error", null);
            }
            if (needed instanceof Set) {
                return this.mAccessMgr.canGetAttrs(this.mAuthedAcct, target, (Set<String>)((Set)needed), true);
            }
            if (needed instanceof Map) {
                return this.mAccessMgr.canSetAttrs(this.mAuthedAcct, target, (Map<String, Object>)((Map)needed), true);
            }
            if (needed instanceof DynamicAttrsRight) {
                DynamicAttrsRight dar = (DynamicAttrsRight)needed;
                return dar.checkRight(this.mAccessMgr, this.mAuthedAcct, target);
            }
            throw ServiceException.FAILURE("internal error", null);
        }

        private String printNeededRight(Entry target, Object needed) throws ServiceException {
            String targetInfo = target instanceof Alias ? "alias " + target.getLabel() : TargetType.getTargetType(target).name() + " " + target.getLabel();
            if (needed instanceof AdminRight) {
                return "need right: " + ((AdminRight)needed).getName() + " for " + targetInfo;
            }
            if (needed instanceof Set) {
                return "cannot get attrs on " + targetInfo;
            }
            if (needed instanceof Map) {
                return "cannot set attrs on " + targetInfo;
            }
            throw ServiceException.FAILURE("internal error", null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DomainAccessControl
    extends AdminAccessControl {
        private DomainAccessControl(AccessManager accessMgr, ZimbraSoapContext zsc, AuthToken authToken, Account authedAcct) {
            super(accessMgr, zsc, authToken, authedAcct);
        }

        @Override
        public boolean isSufficientAdminForSoap(Map<String, Object> soapCtxt, DocumentHandler handler) {
            if (this.mAuthToken.isAdmin()) {
                return true;
            }
            boolean ok = handler.domainAuthSufficient(soapCtxt) && this.mAuthToken.isDomainAdmin();
            return ok;
        }

        @Override
        public boolean isSufficientAdminForZimletFilterServlet() {
            return this.mAuthToken.isAdmin() || this.mAuthToken.isDomainAdmin();
        }

        @Override
        public void checkModifyAttrs(AttributeClass attrClass, Map<String, Object> attrs) throws ServiceException {
            for (String attrName : attrs.keySet()) {
                if (attrName.charAt(0) == '+' || attrName.charAt(0) == '-') {
                    attrName = attrName.substring(1);
                }
                if (AttributeManager.getInstance().isDomainAdminModifiable(attrName, attrClass)) continue;
                throw ServiceException.PERM_DENIED("can not modify attr: " + attrName);
            }
        }

        @Override
        public void checkSetAttrsOnCreate(TargetType targetType, String entryName, Map<String, Object> attrs) throws ServiceException {
        }

        @Override
        public boolean hasRightsToList(NamedEntry target, AdminRight listRight, Object getAttrRight) throws ServiceException {
            return true;
        }

        @Override
        public boolean hasRightsToListCos(Cos target, AdminRight listRight, Object getAttrRight) throws ServiceException {
            boolean hasRight = this.isDomainAdminOnly() ? this.mAccessMgr.canAccessCos(this.mAuthToken, target) : true;
            return hasRight;
        }

        @Override
        public void checkRight(Entry target, Object needed) throws ServiceException {
        }

        @Override
        public void checkCosRight(Cos cos, Object needed) throws ServiceException {
            if (this.isDomainAdminOnly() && !this.mAccessMgr.canAccessCos(this.mAuthToken, cos)) {
                throw ServiceException.PERM_DENIED("can not access cos");
            }
        }

        @Override
        public void checkAccountRight(AdminDocumentHandler handler, Account account, Object needed) throws ServiceException {
            this.soapOnly();
            if (!handler.canAccessAccount(this.mZsc, account)) {
                throw ServiceException.PERM_DENIED("can not access account");
            }
            if (this.isDomainAdminOnly() && needed instanceof Map) {
                this.checkModifyAttrs(AttributeClass.account, (Map)needed);
            }
        }

        @Override
        public void checkCalendarResourceRight(AdminDocumentHandler handler, CalendarResource cr, Object needed) throws ServiceException {
            this.soapOnly();
            if (!handler.canAccessAccount(this.mZsc, cr)) {
                throw ServiceException.PERM_DENIED("can not access calendar resource");
            }
            if (this.isDomainAdminOnly() && needed instanceof Map) {
                this.checkModifyAttrs(AttributeClass.calendarResource, (Map)needed);
            }
        }

        @Override
        public void checkDistributionListRight(AdminDocumentHandler handler, DistributionList dl, Object needed) throws ServiceException {
            this.soapOnly();
            if (!handler.canAccessEmail(this.mZsc, dl.getName())) {
                throw ServiceException.PERM_DENIED("can not access dl");
            }
        }

        @Override
        public void checkDomainRightByEmail(AdminDocumentHandler handler, String email, AdminRight needed) throws ServiceException {
            this.soapOnly();
            if (!handler.canAccessEmail(this.mZsc, email)) {
                throw ServiceException.PERM_DENIED("can not access email:" + email);
            }
        }

        @Override
        public void checkDomainRight(AdminDocumentHandler handler, String domainName, Object needed) throws ServiceException {
            this.soapOnly();
            if (this.isDomainAdminOnly()) {
                if (!handler.canAccessDomain(this.mZsc, domainName)) {
                    throw ServiceException.PERM_DENIED("can not access domain");
                }
                if (needed instanceof Map) {
                    this.checkModifyAttrs(AttributeClass.domain, (Map)needed);
                }
            }
        }

        @Override
        public void checkDomainRight(AdminDocumentHandler handler, Domain domain, Object needed) throws ServiceException {
            this.soapOnly();
            this.checkDomainRight(handler, domain.getName(), needed);
        }

        @Override
        public AccessManager.AttrRightChecker getAttrRightChecker(Entry target) throws ServiceException {
            return null;
        }
    }
}

