/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.common.util.Log;
import com.zimbra.common.util.LogFactory;
import com.zimbra.common.util.StringUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AccountServiceException;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Server;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.account.accesscontrol.Rights;
import com.zimbra.cs.service.admin.AdminDocumentHandler;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddAccountLogger
extends AdminDocumentHandler {
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = AddAccountLogger.getZimbraSoapContext(context);
        Server localServer = Provisioning.getInstance().getLocalServer();
        this.checkRight(zsc, context, localServer, Rights.Admin.R_manageAccountLogger);
        Account account = AddAccountLogger.getAccountFromLoggerRequest(request);
        Element eLogger = request.getElement("logger");
        String category = eLogger.getAttribute("category");
        String sLevel = eLogger.getAttribute("level");
        Log.Level level = null;
        try {
            level = Log.Level.valueOf(sLevel.toLowerCase());
        }
        catch (IllegalArgumentException e) {
            String error = String.format("Invalid level: %s.  Valid values are %s.", sLevel, StringUtil.join(",", (Object[])Log.Level.values()));
            throw ServiceException.INVALID_REQUEST(error, null);
        }
        if (!LogFactory.logExists(category)) {
            throw ServiceException.INVALID_REQUEST("Log category " + category + " does not exist.", null);
        }
        ZimbraLog.misc.info("Adding custom logger: account=%s, category=%s, level=%s", new Object[]{account.getName(), category, level});
        Log log = LogFactory.getLog(category);
        log.addAccountLogger(account.getName(), level);
        Element response = zsc.createElement(AdminConstants.ADD_ACCOUNT_LOGGER_RESPONSE);
        return response;
    }

    static Account getAccountFromLoggerRequest(Element request) throws ServiceException {
        Account account = null;
        Provisioning prov = Provisioning.getInstance();
        Element idElement = request.getOptionalElement("id");
        if (idElement != null) {
            ZimbraLog.soap.info("The <%s> element is deprecated for <%s>.  Use <%s> instead.", "id", request.getName(), "account");
            String id = idElement.getText();
            account = prov.get(Provisioning.AccountBy.id, id);
            if (account == null) {
                throw AccountServiceException.NO_SUCH_ACCOUNT(idElement.getText());
            }
        } else {
            Element accountElement = request.getElement("account");
            Provisioning.AccountBy by = Provisioning.AccountBy.fromString(accountElement.getAttribute("by"));
            account = prov.get(by, accountElement.getText());
            if (account == null) {
                throw AccountServiceException.NO_SUCH_ACCOUNT(accountElement.getText());
            }
        }
        return account;
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        relatedRights.add(Rights.Admin.R_manageAccountLogger);
    }
}

