/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AccountServiceException;
import com.zimbra.cs.account.CalendarResource;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.account.accesscontrol.Rights;
import com.zimbra.cs.service.admin.AdminDocumentHandler;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddAccountAlias
extends AdminDocumentHandler {
    private static final String[] TARGET_ACCOUNT_PATH = new String[]{"id"};

    @Override
    protected String[] getProxiedAccountPath() {
        return TARGET_ACCOUNT_PATH;
    }

    public boolean domainAuthSufficient(Map context) {
        return true;
    }

    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = AddAccountAlias.getZimbraSoapContext(context);
        Provisioning prov = Provisioning.getInstance();
        String id = request.getAttribute("id");
        String alias = request.getAttribute("alias");
        Account account = prov.get(Provisioning.AccountBy.id, id, zsc.getAuthToken());
        if (account == null) {
            throw AccountServiceException.NO_SUCH_ACCOUNT(id);
        }
        if (account.isCalendarResource()) {
            CalendarResource resource = prov.get(Provisioning.CalendarResourceBy.id, id);
            this.checkCalendarResourceRight(zsc, resource, Rights.Admin.R_addCalendarResourceAlias);
        } else {
            this.checkAccountRight(zsc, account, Rights.Admin.R_addAccountAlias);
        }
        this.checkDomainRightByEmail(zsc, alias, Rights.Admin.R_createAlias);
        prov.addAlias(account, alias);
        ZimbraLog.security.info(ZimbraLog.encodeAttrs(new String[]{"cmd", "AddAccountAlias", "name", account.getName(), "alias", alias}));
        Element response = zsc.createElement(AdminConstants.ADD_ACCOUNT_ALIAS_RESPONSE);
        return response;
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        relatedRights.add(Rights.Admin.R_addCalendarResourceAlias);
        relatedRights.add(Rights.Admin.R_addAccountAlias);
        relatedRights.add(Rights.Admin.R_createAlias);
        notes.add("Need " + Rights.Admin.R_createAlias.getName() + " right on the domain in which the alias is to be created.");
        notes.add("Need " + Rights.Admin.R_addAccountAlias.getName() + " right if adding alias for an account.");
        notes.add("Need " + Rights.Admin.R_addCalendarResourceAlias.getName() + " right if adding alias for a calendar resource.");
    }
}

