/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.account;

import com.zimbra.common.calendar.TZIDMapper;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.util.L10nUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.AccessManager;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AttributeManager;
import com.zimbra.cs.account.CalendarResource;
import com.zimbra.cs.account.DataSource;
import com.zimbra.cs.account.EntrySearchFilter;
import com.zimbra.cs.account.IDNUtil;
import com.zimbra.cs.account.Identity;
import com.zimbra.cs.account.Signature;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToXML {
    static Element encodeAccount(Element parent, Account account) {
        return ToXML.encodeAccount(parent, account, true, null, null);
    }

    static Element encodeAccount(Element parent, Account account, boolean applyCos, Set<String> reqAttrs, AccessManager.AttrRightChecker attrRightChecker) {
        Element acctElem = parent.addElement("account");
        acctElem.addAttribute("name", account.getUnicodeName());
        acctElem.addAttribute("id", account.getId());
        Map<String, Object> attrs = account.getUnicodeAttrs(applyCos);
        ToXML.encodeAttrs(acctElem, attrs, "n", reqAttrs, attrRightChecker);
        return acctElem;
    }

    static Element encodeCalendarResource(Element parent, CalendarResource resource) {
        return ToXML.encodeCalendarResource(parent, resource, false, null, null);
    }

    static Element encodeCalendarResource(Element parent, CalendarResource resource, boolean applyCos) {
        return ToXML.encodeCalendarResource(parent, resource, applyCos, null, null);
    }

    static Element encodeCalendarResource(Element parent, CalendarResource resource, boolean applyCos, Set<String> reqAttrs, AccessManager.AttrRightChecker attrRightChecker) {
        Element resElem = parent.addElement("calresource");
        resElem.addAttribute("name", resource.getUnicodeName());
        resElem.addAttribute("id", resource.getId());
        Map<String, Object> attrs = resource.getUnicodeAttrs(applyCos);
        ToXML.encodeAttrs(resElem, attrs, "n", reqAttrs, attrRightChecker);
        return resElem;
    }

    static void encodeAttrs(Element e, Map attrs, Set<String> reqAttrs, AccessManager.AttrRightChecker attrRightChecker) {
        ToXML.encodeAttrs(e, attrs, "n", reqAttrs, attrRightChecker);
    }

    private static void encodeAttrs(Element e, Map attrs, String key, Set<String> reqAttrs, AccessManager.AttrRightChecker attrRightChecker) {
        AttributeManager attrMgr = null;
        try {
            attrMgr = AttributeManager.getInstance();
        }
        catch (ServiceException se) {
            ZimbraLog.account.warn((Object)"failed to get AttributeManager instance", se);
        }
        for (Map.Entry entry : attrs.entrySet()) {
            String name = (String)entry.getKey();
            Object value = entry.getValue();
            if (name.equalsIgnoreCase("zimbraDataSourcePassword")) continue;
            if (name.equalsIgnoreCase("userPassword")) {
                value = "VALUE-BLOCKED";
            }
            if (reqAttrs != null && !reqAttrs.contains(name)) continue;
            boolean allowed = attrRightChecker == null ? true : attrRightChecker.allowAttr(name);
            AttributeManager.IDNType idnType = AttributeManager.idnType(attrMgr, name);
            if (value instanceof String[]) {
                String[] sv = (String[])value;
                for (int i = 0; i < sv.length; ++i) {
                    ToXML.encodeAttr(e, name, sv[i], "a", key, idnType, allowed);
                }
                continue;
            }
            if (!(value instanceof String)) continue;
            value = ToXML.fixupZimbraPrefTimeZoneId(name, (String)value);
            ToXML.encodeAttr(e, name, (String)value, "a", key, idnType, allowed);
        }
    }

    public static Element encodeEntrySearchFilter(Element parent, EntrySearchFilter filter) {
        EntrySearchFilterXmlVisitor visitor = new EntrySearchFilterXmlVisitor(parent);
        filter.traverse(visitor);
        return visitor.getRootElement();
    }

    public static Element encodeLocale(Element parent, Locale locale, Locale inLocale) {
        Element e = parent.addElement("locale");
        String id = locale.toString();
        String name = L10nUtil.getMessage("L10nMsg", id, Locale.getDefault(), new Object[0]);
        if (name == null) {
            name = locale.getDisplayName(inLocale);
        }
        e.addAttribute("id", id);
        e.addAttribute("name", name != null ? name : id);
        return e;
    }

    public static Element encodeIdentity(Element parent, Identity identity) {
        Element e = parent.addElement("identity");
        e.addAttribute("name", identity.getName());
        e.addAttribute("id", identity.getId());
        ToXML.encodeAttrs(e, identity.getUnicodeAttrs(), "name", null, null);
        return e;
    }

    public static Element encodeSignature(Element parent, Signature signature) {
        Element e = parent.addElement("signature");
        e.addAttribute("name", signature.getName());
        e.addAttribute("id", signature.getId());
        Set<Signature.SignatureContent> contents = signature.getContents();
        for (Signature.SignatureContent c : contents) {
            e.addElement("content").addAttribute("type", c.getMimeType()).addText(c.getContent());
        }
        return e;
    }

    public static Element encodeDataSource(Element parent, DataSource ds) {
        Element e = parent.addElement("dataSource");
        e.addAttribute("name", ds.getName());
        e.addAttribute("id", ds.getId());
        e.addAttribute("type", ds.getType().name());
        ToXML.encodeAttrs(e, ds.getUnicodeAttrs(), "n", null, null);
        return e;
    }

    public static void encodeAttr(Element parent, String key, String value, String eltname, String attrname, AttributeManager.IDNType idnType, boolean allowed) {
        if (allowed) {
            Element.KeyValuePair kvPair = parent.addKeyValuePair(key, IDNUtil.toUnicode(value, idnType), eltname, attrname);
        } else {
            Element.KeyValuePair kvPair = parent.addKeyValuePair(key, "", eltname, attrname);
            kvPair.addAttribute("pd", true);
        }
    }

    public static String fixupZimbraPrefTimeZoneId(String attrName, String attrValue) {
        if ("zimbraPrefTimeZoneId".equals(attrName)) {
            return TZIDMapper.canonicalize(attrValue);
        }
        return attrValue;
    }

    private static class EntrySearchFilterXmlVisitor
    implements EntrySearchFilter.Visitor {
        Stack<Element> mParentStack = new Stack();
        Element mRootElement;

        public EntrySearchFilterXmlVisitor(Element parent) {
            this.mParentStack.push(parent);
        }

        public Element getRootElement() {
            return this.mRootElement;
        }

        public void visitSingle(EntrySearchFilter.Single term) {
            Element parent = this.mParentStack.peek();
            Element elem = parent.addElement("cond");
            if (this.mRootElement == null) {
                this.mRootElement = elem;
            }
            if (term.isNegation()) {
                elem.addAttribute("not", true);
            }
            elem.addAttribute("attr", term.getLhs());
            elem.addAttribute("op", term.getOperator().toString());
            elem.addAttribute("value", term.getRhs());
        }

        public void enterMulti(EntrySearchFilter.Multi term) {
            Element parent = this.mParentStack.peek();
            Element elem = parent.addElement("conds");
            if (this.mRootElement == null) {
                this.mRootElement = elem;
            }
            if (term.isNegation()) {
                elem.addAttribute("not", true);
            }
            if (!term.isAnd()) {
                elem.addAttribute("or", true);
            }
            this.mParentStack.push(elem);
        }

        public void leaveMulti(EntrySearchFilter.Multi term) {
            this.mParentStack.pop();
        }
    }
}

