/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.account;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AccountConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AuthToken;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.gal.GalSearchControl;
import com.zimbra.cs.gal.GalSearchParams;
import com.zimbra.cs.service.account.AccountDocumentHandler;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyncGal
extends AccountDocumentHandler {
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        Account account;
        ZimbraSoapContext zsc = SyncGal.getZimbraSoapContext(context);
        if (!this.canAccessAccount(zsc, account = SyncGal.getRequestedAccount(SyncGal.getZimbraSoapContext(context)))) {
            throw ServiceException.PERM_DENIED("can not access account");
        }
        if (!(AuthToken.isAnyAdmin(zsc.getAuthToken()) || account.getBooleanAttr("zimbraFeatureGalSyncEnabled", false) && account.getBooleanAttr("zimbraFeatureGalEnabled", false))) {
            throw ServiceException.PERM_DENIED("cannot sync GAL");
        }
        String tokenAttr = request.getAttribute("token", "");
        String galAcctId = request.getAttribute("id", null);
        boolean idOnly = request.getAttributeBool("idOnly", false);
        GalSearchParams params = new GalSearchParams(account, zsc);
        params.setType(Provisioning.GAL_SEARCH_TYPE.ALL);
        params.setToken(tokenAttr);
        params.setRequest(request);
        params.setResponseName(AccountConstants.SYNC_GAL_RESPONSE);
        params.setIdOnly(idOnly);
        if (galAcctId != null) {
            params.setGalSyncAccount(Provisioning.getInstance().getAccountById(galAcctId));
        }
        GalSearchControl gal = new GalSearchControl(params);
        gal.sync();
        return params.getResultCallback().getResponse();
    }

    @Override
    public boolean needsAuth(Map<String, Object> context) {
        return true;
    }
}

