/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.account;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AccountConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AuthToken;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.gal.GalSearchControl;
import com.zimbra.cs.gal.GalSearchParams;
import com.zimbra.cs.service.account.AccountDocumentHandler;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchGal
extends AccountDocumentHandler {
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        Provisioning.GAL_SEARCH_TYPE type;
        Account account;
        ZimbraSoapContext zsc = SearchGal.getZimbraSoapContext(context);
        if (!this.canAccessAccount(zsc, account = SearchGal.getRequestedAccount(SearchGal.getZimbraSoapContext(context)))) {
            throw ServiceException.PERM_DENIED("can not access account");
        }
        if (!AuthToken.isAnyAdmin(zsc.getAuthToken()) && !account.getBooleanAttr("zimbraFeatureGalEnabled", false)) {
            throw ServiceException.PERM_DENIED("cannot search GAL");
        }
        String n = request.getAttribute("name");
        while (n.endsWith("*")) {
            n = n.substring(0, n.length() - 1);
        }
        String typeStr = request.getAttribute("type", "all");
        if (typeStr.equals("all")) {
            type = Provisioning.GAL_SEARCH_TYPE.ALL;
        } else if (typeStr.equals("account")) {
            type = Provisioning.GAL_SEARCH_TYPE.USER_ACCOUNT;
        } else if (typeStr.equals("resource")) {
            type = Provisioning.GAL_SEARCH_TYPE.CALENDAR_RESOURCE;
        } else {
            throw ServiceException.INVALID_REQUEST("Invalid search type: " + typeStr, null);
        }
        String galAcctId = request.getAttribute("id", null);
        String query = null;
        if (n.compareTo(".") != 0) {
            query = n + "*";
        }
        GalSearchParams params = new GalSearchParams(account, zsc);
        params.setType(type);
        params.setRequest(request);
        params.setQuery(query);
        params.setResponseName(AccountConstants.SEARCH_GAL_RESPONSE);
        if (galAcctId != null) {
            params.setGalSyncAccount(Provisioning.getInstance().getAccountById(galAcctId));
        }
        GalSearchControl gal = new GalSearchControl(params);
        gal.search();
        return params.getResultCallback().getResponse();
    }

    @Override
    public boolean needsAuth(Map<String, Object> context) {
        return true;
    }
}

