/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.account;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AccountConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.CalendarResource;
import com.zimbra.cs.account.EntrySearchFilter;
import com.zimbra.cs.account.NamedEntry;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.service.account.AccountDocumentHandler;
import com.zimbra.cs.service.account.ToXML;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchCalendarResources
extends AccountDocumentHandler {
    private static EntrySearchFilter sFilterActiveResourcesOnly;

    @Override
    public boolean needsAuth(Map<String, Object> context) {
        return true;
    }

    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = SearchCalendarResources.getZimbraSoapContext(context);
        Element response = zsc.createElement(AccountConstants.SEARCH_CALENDAR_RESOURCES_RESPONSE);
        Account account = SearchCalendarResources.getRequestedAccount(SearchCalendarResources.getZimbraSoapContext(context));
        if (!this.canAccessAccount(zsc, account)) {
            throw ServiceException.PERM_DENIED("can not access account");
        }
        String sortBy = request.getAttribute("sortBy", null);
        boolean sortAscending = request.getAttributeBool("sortAscending", true);
        String attrsStr = request.getAttribute("attrs", null);
        String[] attrs = attrsStr == null ? null : attrsStr.split(",");
        EntrySearchFilter filter = SearchCalendarResources.parseSearchFilter(request);
        filter.andWith(sFilterActiveResourcesOnly);
        Provisioning prov = Provisioning.getInstance();
        List<NamedEntry> resources = prov.searchCalendarResources(prov.getDomain(account), filter, attrs, sortBy, sortAscending);
        for (CalendarResource calendarResource : resources) {
            ToXML.encodeCalendarResource(response, calendarResource);
        }
        return response;
    }

    public static EntrySearchFilter parseSearchFilter(Element request) throws ServiceException {
        Element filterElem = request.getElement("searchFilter");
        Element termElem = filterElem.getOptionalElement("conds");
        if (termElem == null) {
            termElem = filterElem.getElement("cond");
        }
        EntrySearchFilter.Term term = SearchCalendarResources.parseFilterTermElem(termElem);
        EntrySearchFilter filter = new EntrySearchFilter(term);
        return filter;
    }

    private static EntrySearchFilter.Term parseFilterTermElem(Element termElem) throws ServiceException {
        EntrySearchFilter.Term term;
        String elemName = termElem.getName();
        boolean negation = termElem.getAttributeBool("not", false);
        if (elemName.equals("conds")) {
            boolean or = termElem.getAttributeBool("or", false);
            EntrySearchFilter.Multi multiTerm = new EntrySearchFilter.Multi(negation, or ? EntrySearchFilter.AndOr.or : EntrySearchFilter.AndOr.and);
            Iterator<Element> iter = termElem.elementIterator();
            while (iter.hasNext()) {
                EntrySearchFilter.Term child = SearchCalendarResources.parseFilterTermElem(iter.next());
                multiTerm.add(child);
            }
            term = multiTerm;
        } else if (elemName.equals("cond")) {
            String attr = termElem.getAttribute("attr");
            if (attr == null) {
                throw ServiceException.INVALID_REQUEST("Missing search term attr", null);
            }
            String op = termElem.getAttribute("op");
            if (op == null) {
                throw ServiceException.INVALID_REQUEST("Missing search term op", null);
            }
            String value = termElem.getAttribute("value");
            if (value == null) {
                throw ServiceException.INVALID_REQUEST("Missing search term value", null);
            }
            term = new EntrySearchFilter.Single(negation, attr, op, value);
        } else {
            throw ServiceException.INVALID_REQUEST("Unknown element <" + elemName + "> in search filter", null);
        }
        return term;
    }

    static {
        EntrySearchFilter.Single active = new EntrySearchFilter.Single(false, "zimbraAccountStatus", EntrySearchFilter.Operator.eq, "active");
        EntrySearchFilter.Single maint = new EntrySearchFilter.Single(false, "zimbraAccountStatus", EntrySearchFilter.Operator.eq, "maintenance");
        EntrySearchFilter.Multi activeOrMaint = new EntrySearchFilter.Multi(false, EntrySearchFilter.AndOr.or, active, maint);
        sFilterActiveResourcesOnly = new EntrySearchFilter(activeOrMaint);
    }
}

