/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.account;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AccountConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.common.util.StringUtil;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.Entry;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.service.account.AccountDocumentHandler;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifyWhiteBlackList
extends AccountDocumentHandler {
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        Account account;
        ZimbraSoapContext zsc = ModifyWhiteBlackList.getZimbraSoapContext(context);
        if (!this.canModifyOptions(zsc, account = ModifyWhiteBlackList.getRequestedAccount(zsc))) {
            throw ServiceException.PERM_DENIED("can not modify options");
        }
        HashMap<String, Object> addrs = new HashMap<String, Object>();
        this.doList(request.getOptionalElement("whiteList"), "amavisWhitelistSender", addrs);
        this.doList(request.getOptionalElement("blackList"), "amavisBlacklistSender", addrs);
        Provisioning.getInstance().modifyAttrs((Entry)account, addrs, true, zsc.getAuthToken());
        Element response = zsc.createElement(AccountConstants.MODIFY_WHITE_BLACK_LIST_RESPONSE);
        return response;
    }

    private void doList(Element eList, String attrName, HashMap<String, Object> addrs) {
        if (eList == null) {
            return;
        }
        if (eList.getOptionalElement("addr") == null) {
            StringUtil.addToMultiMap(addrs, attrName, "");
            return;
        }
        for (Element eAddr : eList.listElements("addr")) {
            String attr = eAddr.getAttribute("op", "") + attrName;
            String value = eAddr.getText();
            StringUtil.addToMultiMap(addrs, attr, value);
        }
    }
}

