/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.account;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AccountConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AccountServiceException;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Signature;
import com.zimbra.soap.DocumentHandler;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifySignature
extends DocumentHandler {
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        Account account;
        ZimbraSoapContext zsc = ModifySignature.getZimbraSoapContext(context);
        if (!this.canModifyOptions(zsc, account = ModifySignature.getRequestedAccount(zsc))) {
            throw ServiceException.PERM_DENIED("can not modify options");
        }
        Provisioning prov = Provisioning.getInstance();
        Element eSignature = request.getElement("signature");
        Signature signature = null;
        String id = eSignature.getAttribute("id");
        signature = prov.get(account, Provisioning.SignatureBy.id, id);
        if (signature == null) {
            throw AccountServiceException.NO_SUCH_SIGNATURE(id);
        }
        List<Element> contents = eSignature.listElements("content");
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        for (Element eContent : contents) {
            String type = eContent.getAttribute("type");
            String attr = Signature.mimeTypeToAttrName(type);
            if (attr == null) {
                throw ServiceException.INVALID_REQUEST("invalid type " + type, null);
            }
            if (attrs.get(attr) != null) {
                throw ServiceException.INVALID_REQUEST("only one " + type + " content is allowed", null);
            }
            String content = eContent.getText();
            if (content == null) continue;
            attrs.put(attr, content);
        }
        String name = eSignature.getAttribute("name", null);
        if (name != null) {
            attrs.put("zimbraSignatureName", name);
        }
        prov.modifySignature(account, signature.getId(), attrs);
        Element response = zsc.createElement(AccountConstants.MODIFY_SIGNATURE_RESPONSE);
        return response;
    }
}

