/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.account;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AccountConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.common.util.StringUtil;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.Entry;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.service.account.AccountDocumentHandler;
import com.zimbra.cs.service.formatter.WikiFormatter;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifyPrefs
extends AccountDocumentHandler {
    public static final String PREF_PREFIX = "zimbraPref";

    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        Account account;
        ZimbraSoapContext zsc = ModifyPrefs.getZimbraSoapContext(context);
        if (!this.canModifyOptions(zsc, account = ModifyPrefs.getRequestedAccount(zsc))) {
            throw ServiceException.PERM_DENIED("can not modify options");
        }
        HashMap<String, Object> prefs = new HashMap<String, Object>();
        for (Element.KeyValuePair kvp : request.listKeyValuePairs("pref", "name")) {
            String name = kvp.getKey();
            String value = kvp.getValue();
            if (!name.startsWith(PREF_PREFIX)) {
                throw ServiceException.INVALID_REQUEST("pref name must start with zimbraPref", null);
            }
            StringUtil.addToMultiMap(prefs, name, value);
        }
        if (prefs.containsKey("zimbraPrefMailForwardingAddress") && !account.getBooleanAttr("zimbraFeatureMailForwardingEnabled", false)) {
            throw ServiceException.PERM_DENIED("forwarding not enabled");
        }
        if (prefs.containsKey("zimbraPrefLocale")) {
            WikiFormatter.expireCache();
        }
        Provisioning.getInstance().modifyAttrs((Entry)account, prefs, true, zsc.getAuthToken());
        Element response = zsc.createElement(AccountConstants.MODIFY_PREFS_RESPONSE);
        return response;
    }
}

