/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.account;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AccountConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AccountServiceException;
import com.zimbra.cs.account.Identity;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.service.account.AccountService;
import com.zimbra.soap.DocumentHandler;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifyIdentity
extends DocumentHandler {
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        String key;
        Account account;
        ZimbraSoapContext zsc = ModifyIdentity.getZimbraSoapContext(context);
        if (!this.canModifyOptions(zsc, account = ModifyIdentity.getRequestedAccount(zsc))) {
            throw ServiceException.PERM_DENIED("can not modify options");
        }
        Provisioning prov = Provisioning.getInstance();
        Element eIdentity = request.getElement("identity");
        Map<String, Object> attrs = AccountService.getAttrs(eIdentity, "name");
        Iterator<String> it = attrs.keySet().iterator();
        while (it.hasNext()) {
            if (it.next().toLowerCase().startsWith("zimbrapref")) continue;
            it.remove();
        }
        Identity ident = null;
        String id = eIdentity.getAttribute("id", null);
        if (id != null) {
            key = id;
            ident = prov.get(account, Provisioning.IdentityBy.id, key);
        } else {
            key = eIdentity.getAttribute("name");
            ident = prov.get(account, Provisioning.IdentityBy.name, key);
        }
        if (ident == null) {
            throw AccountServiceException.NO_SUCH_IDENTITY(key);
        }
        prov.modifyIdentity(account, ident.getName(), attrs);
        Element response = zsc.createElement(AccountConstants.MODIFY_IDENTITY_RESPONSE);
        return response;
    }
}

