/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.account;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AccountConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.service.account.AccountDocumentHandler;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetWhiteBlackList
extends AccountDocumentHandler {
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        Account account;
        ZimbraSoapContext zsc = GetWhiteBlackList.getZimbraSoapContext(context);
        if (!this.canAccessAccount(zsc, account = GetWhiteBlackList.getRequestedAccount(zsc))) {
            throw ServiceException.PERM_DENIED("can not access account");
        }
        String[] senders = account.getMultiAttr("amavisWhitelistSender");
        Element response = zsc.createElement(AccountConstants.GET_WHITE_BLACK_LIST_RESPONSE);
        senders = account.getMultiAttr("amavisWhitelistSender");
        this.doList(response, "whiteList", senders);
        senders = account.getMultiAttr("amavisBlacklistSender");
        this.doList(response, "blackList", senders);
        return response;
    }

    private void doList(Element response, String list, String[] senders) {
        Element eList = response.addElement(list);
        for (String sender : senders) {
            eList.addElement("addr").setText(sender);
        }
    }
}

