/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.account;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AccountConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.common.util.StringUtil;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.service.account.AccountDocumentHandler;
import com.zimbra.cs.util.BuildInfo;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetVersionInfo
extends AccountDocumentHandler {
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        if (!Provisioning.getInstance().getLocalServer().getBooleanAttr("zimbraSoapExposeVersion", false)) {
            throw ServiceException.PERM_DENIED("Version info is not available.");
        }
        ZimbraSoapContext lc = GetVersionInfo.getZimbraSoapContext(context);
        Element response = lc.createElement(AccountConstants.GET_VERSION_INFO_RESPONSE);
        Element infoEl = response.addElement("info");
        String fullVersionInfo = BuildInfo.VERSION;
        if (!StringUtil.isNullOrEmpty(BuildInfo.TYPE)) {
            fullVersionInfo = fullVersionInfo + "." + BuildInfo.TYPE;
        }
        infoEl.addAttribute("version", fullVersionInfo);
        infoEl.addAttribute("release", BuildInfo.RELEASE);
        infoEl.addAttribute("buildDate", BuildInfo.DATE);
        infoEl.addAttribute("host", BuildInfo.HOST);
        return response;
    }

    @Override
    public boolean needsAdminAuth(Map<String, Object> context) {
        return false;
    }

    @Override
    public boolean needsAuth(Map<String, Object> context) {
        return false;
    }
}

