/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.account;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AccountConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.ShareInfo;
import com.zimbra.cs.account.ShareInfoData;
import com.zimbra.cs.mailbox.ACL;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.service.account.AccountDocumentHandler;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.Comparator;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetShareInfo
extends AccountDocumentHandler {
    @Override
    protected Element proxyIfNecessary(Element request, Map<String, Object> context) throws ServiceException {
        if (this.isInternal(request)) {
            return null;
        }
        return super.proxyIfNecessary(request, context);
    }

    private boolean isInternal(Element request) throws ServiceException {
        return request.getAttributeBool("internal", false);
    }

    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        Account account;
        ZimbraSoapContext zsc = GetShareInfo.getZimbraSoapContext(context);
        if (!this.canAccessAccount(zsc, account = GetShareInfo.getRequestedAccount(zsc))) {
            throw ServiceException.PERM_DENIED("can not access account");
        }
        Element response = zsc.createElement(AccountConstants.GET_SHARE_INFO_RESPONSE);
        this.doGetShareInfo(zsc, context, account, request, response);
        return response;
    }

    private void doGetShareInfo(ZimbraSoapContext zsc, Map<String, Object> context, Account targetAcct, Element request, Element response) throws ServiceException {
        String key;
        Provisioning.AccountBy acctBy;
        Provisioning prov = Provisioning.getInstance();
        Element eGrantee = request.getOptionalElement("grantee");
        byte granteeType = GetShareInfo.getGranteeType(eGrantee);
        String granteeId = eGrantee == null ? null : eGrantee.getAttribute("id", null);
        String granteeName = eGrantee == null ? null : eGrantee.getAttribute("name", null);
        Account owner = null;
        Element eOwner = request.getOptionalElement("owner");
        if (eOwner != null && (owner = prov.get(acctBy = Provisioning.AccountBy.fromString(eOwner.getAttribute("by")), key = eOwner.getText())) == null) {
            return;
        }
        OperationContext octxt = GetShareInfo.getOperationContext(zsc, context);
        ShareInfo.MountedFolders mountedFolders = null;
        if (!this.isInternal(request)) {
            mountedFolders = new ShareInfo.MountedFolders(octxt, targetAcct);
        }
        ResultFilterByTarget resultFilter = new ResultFilterByTarget(granteeId, granteeName);
        ShareInfoVisitor visitor = new ShareInfoVisitor(prov, response, mountedFolders, resultFilter);
        if (owner == null) {
            if (granteeType != 0 && granteeType != 2) {
                throw ServiceException.INVALID_REQUEST("invalid grantee type for retrieving published share info", null);
            }
            ShareInfo.Published.get(prov, targetAcct, granteeType, owner, visitor);
        } else {
            if (targetAcct.getId().equals(owner.getId())) {
                throw ServiceException.INVALID_REQUEST("cannot discover shares on self", null);
            }
            if (Provisioning.onLocalServer(owner)) {
                ShareInfo.Discover.discover(octxt, prov, targetAcct, granteeType, owner, visitor);
            } else {
                this.fetchRemoteShareInfo(context, request, owner.getId(), visitor);
            }
        }
        visitor.finish();
    }

    private void fetchRemoteShareInfo(Map<String, Object> context, Element request, String ownerId, ShareInfoVisitor visitor) throws ServiceException {
        request.addAttribute("internal", true);
        Element response = this.proxyRequest(request, context, GetShareInfo.getServer(ownerId));
        for (Element eShare : response.listElements("share")) {
            ShareInfoData sid = ShareInfoData.fromXML(eShare);
            visitor.visit(sid);
        }
    }

    public static byte getGranteeType(Element eGrantee) throws ServiceException {
        String granteeType = null;
        if (eGrantee != null) {
            granteeType = eGrantee.getAttribute("type", null);
        }
        byte gt = granteeType == null ? (byte)0 : ACL.stringToType(granteeType);
        return gt;
    }

    public static class ShareInfoVisitor
    implements Provisioning.PublishedShareInfoVisitor {
        Provisioning mProv;
        Element mResp;
        ShareInfo.MountedFolders mMountedFolders;
        ResultFilter mResultFilter;
        SortedSet<ShareInfoData> mSortedShareInfo = new TreeSet<ShareInfoData>(new ShareInfoComparator());

        public ShareInfoVisitor(Provisioning prov, Element resp, ShareInfo.MountedFolders mountedFolders, ResultFilter resultFilter) {
            this.mProv = prov;
            this.mResp = resp;
            this.mMountedFolders = mountedFolders;
            this.mResultFilter = resultFilter;
        }

        public void visit(ShareInfoData sid) throws ServiceException {
            if (this.mResultFilter == null || this.mResultFilter.check(sid)) {
                this.mSortedShareInfo.add(sid);
            }
        }

        public void finish() throws ServiceException {
            for (ShareInfoData sid : this.mSortedShareInfo) {
                this.doVisit(sid);
            }
        }

        private void doVisit(ShareInfoData sid) throws ServiceException {
            Element eShare = this.mResp.addElement("share");
            Integer mptId = null;
            if (this.mMountedFolders != null) {
                mptId = this.mMountedFolders.getLocalFolderId(sid.getOwnerAcctId(), sid.getFolderId());
            }
            sid.toXML(eShare, mptId);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class ShareInfoComparator
        implements Comparator<ShareInfoData> {
            private ShareInfoComparator() {
            }

            @Override
            public int compare(ShareInfoData a, ShareInfoData b) {
                int r = a.getFolderPath().compareToIgnoreCase(b.getFolderPath());
                if (r == 0) {
                    r = a.getOwnerAcctEmail().compareToIgnoreCase(b.getOwnerAcctEmail());
                }
                if (r == 0) {
                    r = a.getGranteeName().compareToIgnoreCase(b.getGranteeName());
                }
                return r;
            }
        }
    }

    public static class ResultFilterByTarget
    implements ResultFilter {
        String mGranteeId;
        String mGranteeName;

        public ResultFilterByTarget(String granteeId, String granteeName) {
            this.mGranteeId = granteeId;
            this.mGranteeName = granteeName;
        }

        public boolean check(ShareInfoData sid) {
            if (this.mGranteeId != null && !this.mGranteeId.equals(sid.getGranteeId())) {
                return false;
            }
            return this.mGranteeName == null || this.mGranteeName.equals(sid.getGranteeName());
        }
    }

    public static interface ResultFilter {
        public boolean check(ShareInfoData var1);
    }
}

