/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.account;

import com.zimbra.common.calendar.TZIDMapper;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AccountConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.service.account.AccountDocumentHandler;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.HashSet;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetPrefs
extends AccountDocumentHandler {
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        Account account;
        ZimbraSoapContext zsc = GetPrefs.getZimbraSoapContext(context);
        if (!this.canAccessAccount(zsc, account = GetPrefs.getRequestedAccount(zsc))) {
            throw ServiceException.PERM_DENIED("can not access account");
        }
        Element response = zsc.createElement(AccountConstants.GET_PREFS_RESPONSE);
        GetPrefs.handle(request, response, account);
        return response;
    }

    public static void handle(Element request, Element response, Account acct) throws ServiceException {
        HashSet<String> specificPrefs = null;
        for (Element epref : request.listElements("pref")) {
            if (specificPrefs == null) {
                specificPrefs = new HashSet<String>();
            }
            specificPrefs.add(epref.getAttribute("name"));
        }
        Map<String, Object> map = acct.getUnicodeAttrs();
        if (map != null) {
            GetPrefs.doPrefs(acct, response, map, specificPrefs);
        }
    }

    public static void doPrefs(Account acct, Element prefs, Map<String, Object> attrsMap, HashSet<String> specificPrefs) {
        for (Map.Entry<String, Object> entry : attrsMap.entrySet()) {
            String key = entry.getKey();
            if (specificPrefs != null && !specificPrefs.contains(key) || !key.startsWith("zimbraPref")) continue;
            Object value = entry.getValue();
            if (value instanceof String[]) {
                String[] sa = (String[])value;
                for (int i = 0; i < sa.length; ++i) {
                    prefs.addKeyValuePair(key, sa[i], "pref", "name");
                }
                continue;
            }
            if (key.equals("zimbraPrefTimeZoneId")) {
                value = TZIDMapper.canonicalize((String)value);
            }
            prefs.addKeyValuePair(key, (String)value, "pref", "name");
        }
    }
}

