/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.account;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AccountConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AttributeFlag;
import com.zimbra.cs.account.AttributeManager;
import com.zimbra.cs.account.AuthToken;
import com.zimbra.cs.account.AuthTokenException;
import com.zimbra.cs.account.Cos;
import com.zimbra.cs.account.DataSource;
import com.zimbra.cs.account.Identity;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Signature;
import com.zimbra.cs.account.Zimlet;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.service.UserServlet;
import com.zimbra.cs.service.account.AccountDocumentHandler;
import com.zimbra.cs.service.account.GetAccountInfo;
import com.zimbra.cs.service.account.GetPrefs;
import com.zimbra.cs.service.account.ToXML;
import com.zimbra.cs.session.Session;
import com.zimbra.cs.session.SoapSession;
import com.zimbra.cs.util.BuildInfo;
import com.zimbra.cs.zimlet.ZimletProperty;
import com.zimbra.cs.zimlet.ZimletUserProperties;
import com.zimbra.cs.zimlet.ZimletUtil;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetInfo
extends AccountDocumentHandler {
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        Set<Section> sections;
        Account account;
        ZimbraSoapContext zsc = GetInfo.getZimbraSoapContext(context);
        if (!this.canAccessAccount(zsc, account = GetInfo.getRequestedAccount(zsc))) {
            throw ServiceException.PERM_DENIED("can not access account");
        }
        String secstr = request.getAttribute("sections", null);
        if (secstr != null) {
            sections = new HashSet<Section>();
            for (String sec : secstr.split(",")) {
                sections.add(Section.lookup(sec));
            }
        } else {
            sections = Section.all;
        }
        Element response = zsc.createElement(AccountConstants.GET_INFO_RESPONSE);
        response.addAttribute("version", BuildInfo.FULL_VERSION, Element.Disposition.CONTENT);
        response.addAttribute("id", account.getId(), Element.Disposition.CONTENT);
        response.addAttribute("name", account.getUnicodeName(), Element.Disposition.CONTENT);
        try {
            response.addAttribute("crumb", zsc.getAuthToken().getCrumb(), Element.Disposition.CONTENT);
        }
        catch (AuthTokenException e) {
            ZimbraLog.account.warn((Object)"can't generate crumb", e);
        }
        long lifetime = zsc.getAuthToken().getExpires() - System.currentTimeMillis();
        response.addAttribute("lifetime", lifetime, Element.Disposition.CONTENT);
        if (sections.contains((Object)Section.MBOX) && Provisioning.onLocalServer(account)) {
            response.addAttribute("rest", UserServlet.getRestUrl(account), Element.Disposition.CONTENT);
            try {
                Mailbox mbox = GetInfo.getRequestedMailbox(zsc);
                response.addAttribute("used", mbox.getSize(), Element.Disposition.CONTENT);
                Session s = (Session)context.get("zimbra.session");
                if (s instanceof SoapSession) {
                    response.addAttribute("prevSession", ((SoapSession)s).getPreviousSessionTime(), Element.Disposition.CONTENT);
                    response.addAttribute("accessed", ((SoapSession)s).getLastWriteAccessTime(), Element.Disposition.CONTENT);
                    response.addAttribute("recent", ((SoapSession)s).getRecentMessageCount(), Element.Disposition.CONTENT);
                } else {
                    long lastAccess = mbox.getLastSoapAccessTime();
                    response.addAttribute("prevSession", lastAccess, Element.Disposition.CONTENT);
                    response.addAttribute("accessed", lastAccess, Element.Disposition.CONTENT);
                    response.addAttribute("recent", mbox.getRecentMessageCount(), Element.Disposition.CONTENT);
                }
            }
            catch (ServiceException e) {
                // empty catch block
            }
        }
        GetInfo.doCos(account, response);
        Map<String, Object> attrMap = account.getUnicodeAttrs();
        Locale locale = Provisioning.getInstance().getLocale(account);
        if (sections.contains((Object)Section.PREFS)) {
            Element prefs = response.addUniqueElement("prefs");
            GetPrefs.doPrefs(account, prefs, attrMap, null);
        }
        if (sections.contains((Object)Section.ATTRS)) {
            Element attrs = response.addUniqueElement("attrs");
            GetInfo.doAttrs(account, locale.toString(), attrs, attrMap);
        }
        if (sections.contains((Object)Section.ZIMLETS)) {
            Element zimlets = response.addUniqueElement("zimlets");
            GetInfo.doZimlets(zimlets, account);
        }
        if (sections.contains((Object)Section.PROPS)) {
            Element props = response.addUniqueElement("props");
            GetInfo.doProperties(props, account);
        }
        if (sections.contains((Object)Section.IDENTS)) {
            Element ids = response.addUniqueElement("identities");
            GetInfo.doIdentities(ids, account);
        }
        if (sections.contains((Object)Section.SIGS)) {
            Element sigs = response.addUniqueElement("signatures");
            GetInfo.doSignatures(sigs, account);
        }
        if (sections.contains((Object)Section.DSRCS)) {
            Element ds = response.addUniqueElement("dataSources");
            GetInfo.doDataSources(ds, account, zsc);
        }
        if (sections.contains((Object)Section.CHILDREN)) {
            Element ca = response.addUniqueElement("childAccounts");
            this.doChildAccounts(ca, account, zsc.getAuthToken());
        }
        GetAccountInfo.addUrls(response, account);
        return response;
    }

    static void doCos(Account acct, Element response) throws ServiceException {
        Cos cos = Provisioning.getInstance().getCOS(acct);
        if (cos != null) {
            Element eCos = response.addUniqueElement("cos");
            eCos.addAttribute("id", cos.getId());
            eCos.addAttribute("name", cos.getName());
        }
    }

    static void doAttrs(Account acct, String locale, Element response, Map attrsMap) throws ServiceException {
        Set<String> attrList = AttributeManager.getInstance().getAttrsWithFlag(AttributeFlag.accountInfo);
        for (String key : attrList) {
            GetInfo.doAttr(response, key, key.equals("zimbraLocale") ? locale : attrsMap.get(key));
        }
    }

    static void doAttr(Element response, String key, Object value) {
        if (value instanceof String[]) {
            String[] sa = (String[])value;
            for (int i = 0; i < sa.length; ++i) {
                if (sa[i] == null || sa[i].equals("")) continue;
                response.addKeyValuePair(key, sa[i], "attr", "name");
            }
        } else if (value != null && !value.equals("")) {
            response.addKeyValuePair(key, (String)value, "attr", "name");
        }
    }

    private static void doZimlets(Element response, Account acct) {
        try {
            String[] attrList = ZimletUtil.getZimlets(acct);
            List<Zimlet> zimletList = ZimletUtil.orderZimletsByPriority(attrList);
            int priority = 0;
            for (Zimlet z : zimletList) {
                if (z.isEnabled() && !z.isExtension()) {
                    ZimletUtil.listZimlet(response, z, priority);
                }
                ++priority;
            }
            ZimletUtil.listDevZimlets(response);
        }
        catch (ServiceException se) {
            ZimbraLog.account.error((Object)"can't get zimlets", se);
        }
    }

    private static void doProperties(Element response, Account acct) {
        ZimletUserProperties zp = ZimletUserProperties.getProperties(acct);
        Set<ZimletUserProperties.ZimletProp> props = zp.getAllProperties();
        for (ZimletProperty zimletProperty : props) {
            Element elem = response.addElement("prop");
            elem.addAttribute("zimlet", zimletProperty.getZimletName());
            elem.addAttribute("name", zimletProperty.getKey());
            elem.setText(zimletProperty.getValue());
        }
    }

    private static void doIdentities(Element response, Account acct) {
        try {
            List<Identity> identities = Provisioning.getInstance().getAllIdentities(acct);
            for (Identity i : identities) {
                ToXML.encodeIdentity(response, i);
            }
        }
        catch (ServiceException se) {
            ZimbraLog.account.error((Object)"can't get identities", se);
        }
    }

    private static void doSignatures(Element response, Account acct) {
        try {
            List<Signature> signatures = Provisioning.getInstance().getAllSignatures(acct);
            for (Signature s : signatures) {
                ToXML.encodeSignature(response, s);
            }
        }
        catch (ServiceException se) {
            ZimbraLog.account.error((Object)"can't get signatures", se);
        }
    }

    private static void doDataSources(Element response, Account acct, ZimbraSoapContext zsc) {
        try {
            List<DataSource> dataSources = Provisioning.getInstance().getAllDataSources(acct);
            for (DataSource ds : dataSources) {
                com.zimbra.cs.service.mail.ToXML.encodeDataSource(response, ds);
            }
        }
        catch (ServiceException se) {
            ZimbraLog.mailbox.error((Object)"Unable to get data sources", se);
        }
    }

    protected void doChildAccounts(Element response, Account acct, AuthToken authToken) throws ServiceException {
        Account child;
        String[] childAccounts = acct.getMultiAttr("zimbraChildAccount");
        String[] visibleChildAccounts = acct.getMultiAttr("zimbraPrefChildVisibleAccount");
        if (childAccounts.length == 0 && visibleChildAccounts.length == 0) {
            return;
        }
        Provisioning prov = Provisioning.getInstance();
        HashSet<String> children = new HashSet<String>(childAccounts.length);
        for (String childId : visibleChildAccounts) {
            if (children.contains(childId)) continue;
            child = prov.get(Provisioning.AccountBy.id, childId, authToken);
            if (child != null) {
                this.encodeChildAccount(response, child, true);
            }
            children.add(childId);
        }
        for (String childId : childAccounts) {
            if (children.contains(childId)) continue;
            child = prov.get(Provisioning.AccountBy.id, childId, authToken);
            if (child != null) {
                this.encodeChildAccount(response, child, false);
            }
            children.add(childId);
        }
    }

    protected Element encodeChildAccount(Element parent, Account child, boolean isVisible) {
        Element elem = parent.addElement("childAccount");
        elem.addAttribute("id", child.getId());
        elem.addAttribute("name", child.getUnicodeName());
        elem.addAttribute("visible", isVisible);
        String displayName = child.getAttr("displayName");
        if (displayName != null) {
            Element attrsElem = elem.addUniqueElement("attrs");
            attrsElem.addKeyValuePair("displayName", displayName, "attr", "name");
        }
        return elem;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Section {
        MBOX,
        PREFS,
        ATTRS,
        ZIMLETS,
        PROPS,
        IDENTS,
        SIGS,
        DSRCS,
        CHILDREN;

        static final Set<Section> all;

        static Section lookup(String value) throws ServiceException {
            try {
                return Section.valueOf(value.toUpperCase().trim());
            }
            catch (IllegalArgumentException iae) {
                throw ServiceException.INVALID_REQUEST("unknown GetInfo section: " + value.trim(), null);
            }
        }

        static {
            all = new HashSet<Section>(Arrays.asList(Section.values()));
        }
    }
}

