/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.account;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AccountConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.common.util.L10nUtil;
import com.zimbra.common.util.StringUtil;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.service.account.AccountDocumentHandler;
import com.zimbra.cs.service.account.ToXML;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetAvailableLocales
extends AccountDocumentHandler {
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        Account account;
        ZimbraSoapContext zsc = GetAvailableLocales.getZimbraSoapContext(context);
        if (!this.canAccessAccount(zsc, account = GetAvailableLocales.getRequestedAccount(zsc))) {
            throw ServiceException.PERM_DENIED("can not access account");
        }
        Locale displayLocale = this.getDisplayLocale(account, context);
        Locale[] installedLocales = L10nUtil.getLocalesSorted(displayLocale);
        Set<String> allowedLocales = account.getMultiAttrSet("zimbraAvailableLocale");
        Locale[] availLocales = null;
        availLocales = allowedLocales.size() > 0 ? this.computeAvailLocales(installedLocales, allowedLocales) : installedLocales;
        Element response = zsc.createElement(AccountConstants.GET_AVAILABLE_LOCALES_RESPONSE);
        for (Locale locale : availLocales) {
            if (locale == null) break;
            ToXML.encodeLocale(response, locale, displayLocale);
        }
        return response;
    }

    private Locale getDisplayLocale(Account acct, Map<String, Object> context) throws ServiceException {
        HttpServletRequest req;
        String locale = acct.getAttr("zimbraPrefLocale", false);
        if (StringUtil.isNullOrEmpty(locale) && (req = (HttpServletRequest)context.get("servlet.request")) != null) {
            locale = req.getHeader("Accept-Language");
        }
        if (StringUtil.isNullOrEmpty(locale)) {
            return Provisioning.getInstance().getLocale(acct);
        }
        return L10nUtil.lookupLocale(locale);
    }

    private Locale[] computeAvailLocales(Locale[] installedLocales, Set<String> allowedLocales) {
        Locale[] availLocales = new Locale[installedLocales.length];
        int i = 0;
        for (Locale locale : installedLocales) {
            String localeId = locale.toString();
            String language = locale.getLanguage();
            String country = locale.getCountry();
            String variant = locale.getVariant();
            if (!StringUtil.isNullOrEmpty(variant)) {
                if (!allowedLocales.contains(language) && !allowedLocales.contains(language + "_" + country) && !allowedLocales.contains(localeId)) continue;
                availLocales[i++] = locale;
                continue;
            }
            if (!StringUtil.isNullOrEmpty(country)) {
                if (!allowedLocales.contains(language) && !allowedLocales.contains(localeId)) continue;
                availLocales[i++] = locale;
                continue;
            }
            if (!allowedLocales.contains(localeId)) continue;
            availLocales[i++] = locale;
        }
        return availLocales;
    }
}

