/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.account;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AccountConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.Domain;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Server;
import com.zimbra.cs.httpclient.URLUtil;
import com.zimbra.cs.service.account.AccountDocumentHandler;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetAccountInfo
extends AccountDocumentHandler {
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = GetAccountInfo.getZimbraSoapContext(context);
        Element a = request.getElement("account");
        String key = a.getAttribute("by");
        String value = a.getText();
        Provisioning prov = Provisioning.getInstance();
        Account account = prov.get(Provisioning.AccountBy.fromString(key), value, zsc.getAuthToken());
        if (account == null) {
            throw ServiceException.PERM_DENIED("can not access account");
        }
        Element response = zsc.createElement(AccountConstants.GET_ACCOUNT_INFO_RESPONSE);
        response.addAttribute("name", account.getName(), Element.Disposition.CONTENT);
        response.addKeyValuePair("zimbraId", account.getId(), "attr", "name");
        response.addKeyValuePair("zimbraMailHost", account.getAttr("zimbraMailHost"), "attr", "name");
        GetAccountInfo.addUrls(response, account);
        return response;
    }

    static void addUrls(Element response, Account account) throws ServiceException {
        String pubUrl;
        Provisioning prov = Provisioning.getInstance();
        Server server = prov.getServer(account);
        if (server == null) {
            return;
        }
        String hostname = server.getAttr("zimbraServiceHostname");
        if (hostname == null) {
            return;
        }
        Domain domain = prov.getDomain(account);
        String httpSoap = URLUtil.getSoapPublicURL(server, domain, false);
        String httpsSoap = URLUtil.getSoapPublicURL(server, domain, true);
        if (httpSoap != null) {
            response.addAttribute("soapURL", httpSoap, Element.Disposition.CONTENT);
        }
        if (httpsSoap != null && !httpsSoap.equalsIgnoreCase(httpSoap)) {
            response.addAttribute("soapURL", httpsSoap, Element.Disposition.CONTENT);
        }
        if ((pubUrl = URLUtil.getPublicURLForDomain(server, domain, "", true)) != null) {
            response.addAttribute("publicURL", pubUrl, Element.Disposition.CONTENT);
        }
        String changePasswordUrl = null;
        if (domain != null) {
            changePasswordUrl = domain.getAttr("zimbraChangePasswordURL");
        }
        if (changePasswordUrl != null) {
            response.addAttribute("changePasswordURL", changePasswordUrl, Element.Disposition.CONTENT);
        }
    }
}

