/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.account;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AccountConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.SoapFaultException;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Signature;
import com.zimbra.soap.DocumentHandler;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteSignature
extends DocumentHandler {
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException, SoapFaultException {
        Account account;
        ZimbraSoapContext zsc = DeleteSignature.getZimbraSoapContext(context);
        if (!this.canModifyOptions(zsc, account = DeleteSignature.getRequestedAccount(zsc))) {
            throw ServiceException.PERM_DENIED("can not modify options");
        }
        Provisioning prov = Provisioning.getInstance();
        Element eSignature = request.getElement("signature");
        Signature signature = null;
        String id = eSignature.getAttribute("id", null);
        signature = id != null ? prov.get(account, Provisioning.SignatureBy.id, id) : prov.get(account, Provisioning.SignatureBy.name, eSignature.getAttribute("name"));
        if (signature != null) {
            Provisioning.getInstance().deleteSignature(account, signature.getId());
        }
        Element response = zsc.createElement(AccountConstants.DELETE_SIGNATURE_RESPONSE);
        return response;
    }
}

