/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.account;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AccountConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.SoapFaultException;
import com.zimbra.common.util.StringUtil;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Signature;
import com.zimbra.soap.DocumentHandler;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateSignature
extends DocumentHandler {
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException, SoapFaultException {
        Account account;
        ZimbraSoapContext zsc = CreateSignature.getZimbraSoapContext(context);
        if (!this.canModifyOptions(zsc, account = CreateSignature.getRequestedAccount(zsc))) {
            throw ServiceException.PERM_DENIED("can not modify options");
        }
        Element eReqSignature = request.getElement("signature");
        String name = eReqSignature.getAttribute("name");
        String id = eReqSignature.getAttribute("id", null);
        List<Element> contents = eReqSignature.listElements("content");
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        for (Element eContent : contents) {
            String type = eContent.getAttribute("type");
            String attr = Signature.mimeTypeToAttrName(type);
            if (attr == null) {
                throw ServiceException.INVALID_REQUEST("invalid type " + type, null);
            }
            if (attrs.get(attr) != null) {
                throw ServiceException.INVALID_REQUEST("only one " + type + " content is allowed", null);
            }
            String content = eContent.getText();
            if (StringUtil.isNullOrEmpty(content)) continue;
            attrs.put(attr, content);
        }
        if (id != null) {
            attrs.put("zimbraSignatureId", id);
        }
        Signature signature = Provisioning.getInstance().createSignature(account, name, attrs);
        Element response = zsc.createElement(AccountConstants.CREATE_SIGNATURE_RESPONSE);
        Element eRespSignature = response.addElement("signature");
        eRespSignature.addAttribute("id", signature.getId());
        eRespSignature.addAttribute("name", signature.getName());
        return response;
    }
}

