/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.account;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AccountConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.Identity;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.service.account.AccountService;
import com.zimbra.cs.service.account.ToXML;
import com.zimbra.soap.DocumentHandler;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateIdentity
extends DocumentHandler {
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        Account account;
        ZimbraSoapContext zsc = CreateIdentity.getZimbraSoapContext(context);
        if (!this.canModifyOptions(zsc, account = CreateIdentity.getRequestedAccount(zsc))) {
            throw ServiceException.PERM_DENIED("can not modify options");
        }
        Element identityEl = request.getElement("identity");
        String name = identityEl.getAttribute("name");
        Map<String, Object> attrs = AccountService.getAttrs(identityEl, "name");
        Identity identity = Provisioning.getInstance().createIdentity(account, name, attrs);
        Element response = zsc.createElement(AccountConstants.CREATE_IDENTITY_RESPONSE);
        ToXML.encodeIdentity(response, identity);
        return response;
    }
}

