/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.account;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AccountConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AccountServiceException;
import com.zimbra.cs.account.AuthToken;
import com.zimbra.cs.account.Domain;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.service.AuthProvider;
import com.zimbra.cs.service.account.AccountDocumentHandler;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangePassword
extends AccountDocumentHandler {
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        Account acct;
        Domain d;
        String virtualHost;
        String namePassedIn;
        if (!this.checkPasswordSecurity(context)) {
            throw ServiceException.INVALID_REQUEST("clear text password is not allowed", null);
        }
        ZimbraSoapContext zsc = ChangePassword.getZimbraSoapContext(context);
        Provisioning prov = Provisioning.getInstance();
        String name = namePassedIn = request.getAttribute("account");
        Element virtualHostEl = request.getOptionalElement("virtualHost");
        String string = virtualHost = virtualHostEl == null ? null : virtualHostEl.getText().toLowerCase();
        if (virtualHost != null && name.indexOf(64) == -1 && (d = prov.get(Provisioning.DomainBy.virtualHostname, virtualHost)) != null) {
            name = name + "@" + d.getName();
        }
        if ((acct = prov.get(Provisioning.AccountBy.name, name, zsc.getAuthToken())) == null) {
            throw AccountServiceException.AuthFailedServiceException.AUTH_FAILED(name, namePassedIn, "account not found");
        }
        String oldPassword = request.getAttribute("oldPassword");
        String newPassword = request.getAttribute("password");
        prov.changePassword(acct, oldPassword, newPassword);
        AuthToken at = AuthProvider.getAuthToken(acct);
        Element response = zsc.createElement(AccountConstants.CHANGE_PASSWORD_RESPONSE);
        at.encodeAuthResp(response, false);
        response.addAttribute("lifetime", at.getExpires() - System.currentTimeMillis(), Element.Disposition.CONTENT);
        return response;
    }

    @Override
    public boolean needsAuth(Map<String, Object> context) {
        return false;
    }
}

