/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.account;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AccountConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AuthToken;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.gal.GalSearchControl;
import com.zimbra.cs.gal.GalSearchParams;
import com.zimbra.cs.service.account.AccountDocumentHandler;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoCompleteGal
extends AccountDocumentHandler {
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        Provisioning.GAL_SEARCH_TYPE type;
        Account account;
        ZimbraSoapContext zsc = AutoCompleteGal.getZimbraSoapContext(context);
        if (!this.canAccessAccount(zsc, account = AutoCompleteGal.getRequestedAccount(AutoCompleteGal.getZimbraSoapContext(context)))) {
            throw ServiceException.PERM_DENIED("can not access account");
        }
        if (!(AuthToken.isAnyAdmin(zsc.getAuthToken()) || account.getBooleanAttr("zimbraFeatureGalAutoCompleteEnabled", false) && account.getBooleanAttr("zimbraFeatureGalEnabled", false))) {
            throw ServiceException.PERM_DENIED("cannot auto complete GAL");
        }
        String n = request.getAttribute("name");
        while (n.endsWith("*")) {
            n = n.substring(0, n.length() - 1);
        }
        String typeStr = request.getAttribute("type", "account");
        if (typeStr.equals("all")) {
            type = Provisioning.GAL_SEARCH_TYPE.ALL;
        } else if (typeStr.equals("account")) {
            type = Provisioning.GAL_SEARCH_TYPE.USER_ACCOUNT;
        } else if (typeStr.equals("resource")) {
            type = Provisioning.GAL_SEARCH_TYPE.CALENDAR_RESOURCE;
        } else {
            throw ServiceException.INVALID_REQUEST("Invalid search type: " + typeStr, null);
        }
        GalSearchParams params = new GalSearchParams(account, zsc);
        params.setType(type);
        params.setRequest(request);
        params.setQuery(n);
        params.setLimit(account.getContactAutoCompleteMaxResults());
        params.setResponseName(AccountConstants.AUTO_COMPLETE_GAL_RESPONSE);
        GalSearchControl gal = new GalSearchControl(params);
        gal.autocomplete();
        return params.getResultCallback().getResponse();
    }

    @Override
    public boolean needsAuth(Map<String, Object> context) {
        return true;
    }
}

