/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.account;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AccountConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AccountServiceException;
import com.zimbra.cs.account.AttributeFlag;
import com.zimbra.cs.account.AttributeManager;
import com.zimbra.cs.account.AuthToken;
import com.zimbra.cs.account.AuthTokenException;
import com.zimbra.cs.account.Domain;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Server;
import com.zimbra.cs.account.auth.AuthContext;
import com.zimbra.cs.service.AuthProvider;
import com.zimbra.cs.service.account.AccountDocumentHandler;
import com.zimbra.cs.service.account.GetInfo;
import com.zimbra.cs.service.account.GetPrefs;
import com.zimbra.cs.session.Session;
import com.zimbra.cs.util.AccountUtil;
import com.zimbra.cs.util.SkinUtil;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Auth
extends AccountDocumentHandler {
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        Account acct;
        Domain d;
        String valuePassedIn;
        ZimbraSoapContext zsc = Auth.getZimbraSoapContext(context);
        Provisioning prov = Provisioning.getInstance();
        Element authTokenEl = request.getOptionalElement("authToken");
        if (authTokenEl != null) {
            try {
                String token = authTokenEl.getText();
                AuthToken at = AuthToken.getAuthToken(token);
                Auth.addAccountToLogContextByAuthToken(prov, at);
                if (!this.checkPasswordSecurity(context)) {
                    throw ServiceException.INVALID_REQUEST("clear text password is not allowed", null);
                }
                Account acct2 = AuthProvider.validateAuthToken(prov, at, false);
                return this.doResponse(request, at, zsc, context, acct2);
            }
            catch (AuthTokenException e) {
                throw ServiceException.AUTH_REQUIRED();
            }
        }
        Element acctEl = request.getElement("account");
        String value = valuePassedIn = acctEl.getText();
        String byStr = acctEl.getAttribute("by", Provisioning.AccountBy.name.name());
        Element preAuthEl = request.getOptionalElement("preauth");
        String password = request.getAttribute("password", null);
        Element virtualHostEl = request.getOptionalElement("virtualHost");
        String virtualHost = virtualHostEl == null ? null : virtualHostEl.getText().toLowerCase();
        Provisioning.AccountBy by = Provisioning.AccountBy.fromString(byStr);
        if (by == Provisioning.AccountBy.name && virtualHost != null && value.indexOf(64) == -1 && (d = prov.get(Provisioning.DomainBy.virtualHostname, virtualHost)) != null) {
            value = value + "@" + d.getName();
        }
        if ((acct = prov.get(by, value)) == null) {
            throw AccountServiceException.AuthFailedServiceException.AUTH_FAILED(value, valuePassedIn, "account not found");
        }
        AccountUtil.addAccountToLogContext(prov, acct.getId(), "name", "id", null);
        if (!this.checkPasswordSecurity(context)) {
            throw ServiceException.INVALID_REQUEST("clear text password is not allowed", null);
        }
        long expires = 0L;
        HashMap<String, Object> authCtxt = new HashMap<String, Object>();
        authCtxt.put("ocip", context.get("orig.request.ip"));
        authCtxt.put("anp", valuePassedIn);
        authCtxt.put("ua", zsc.getUserAgent());
        if (password != null) {
            prov.authAccount(acct, password, AuthContext.Protocol.soap, authCtxt);
        } else if (preAuthEl != null) {
            long timestamp = preAuthEl.getAttributeLong("timestamp");
            expires = preAuthEl.getAttributeLong("expires", 0L);
            String preAuth = preAuthEl.getTextTrim();
            prov.preAuthAccount(acct, value, byStr, timestamp, expires, preAuth, authCtxt);
        } else {
            throw ServiceException.INVALID_REQUEST("must specify password", null);
        }
        AuthToken at = expires == 0L ? AuthProvider.getAuthToken(acct) : AuthProvider.getAuthToken(acct, expires);
        return this.doResponse(request, at, zsc, context, acct);
    }

    private Element doResponse(Element request, AuthToken at, ZimbraSoapContext zsc, Map<String, Object> context, Account acct) throws ServiceException {
        Element requestedSkinEl;
        Element attrsRequest;
        Element prefsRequest;
        Server localhost;
        String referMode;
        Session session;
        Element response = zsc.createElement(AccountConstants.AUTH_RESPONSE);
        at.encodeAuthResp(response, false);
        response.addAttribute("lifetime", at.getExpires() - System.currentTimeMillis(), Element.Disposition.CONTENT);
        boolean isCorrectHost = Provisioning.onLocalServer(acct);
        if (isCorrectHost && (session = this.updateAuthenticatedAccount(zsc, at, context, true)) != null) {
            ZimbraSoapContext.encodeSession(response, session.getSessionId(), session.getSessionType());
        }
        if ("always".equals(referMode = (localhost = Provisioning.getInstance().getLocalServer()).getAttr("zimbraMailReferMode", "wronghost")) || "wronghost".equals(referMode) && !isCorrectHost) {
            response.addAttribute("refer", acct.getAttr("zimbraMailHost"), Element.Disposition.CONTENT);
        }
        if ((prefsRequest = request.getOptionalElement("prefs")) != null) {
            Element prefsResponse = response.addUniqueElement("prefs");
            GetPrefs.handle(prefsRequest, prefsResponse, acct);
        }
        if ((attrsRequest = request.getOptionalElement("attrs")) != null) {
            Element attrsResponse = response.addUniqueElement("attrs");
            Set<String> attrList = AttributeManager.getInstance().getAttrsWithFlag(AttributeFlag.accountInfo);
            Iterator<Element> it = attrsRequest.elementIterator("attr");
            while (it.hasNext()) {
                String[] v;
                Element e = it.next();
                String name = e.getAttribute("name");
                if (name == null || !attrList.contains(name) || (v = acct.getUnicodeMultiAttr(name)) == null) continue;
                GetInfo.doAttr(attrsResponse, name, v);
            }
        }
        String requestedSkin = (requestedSkinEl = request.getOptionalElement("requestedSkin")) != null ? requestedSkinEl.getText() : null;
        String skin = SkinUtil.chooseSkin(acct, requestedSkin);
        ZimbraLog.webclient.debug("chooseSkin() returned " + skin);
        if (skin != null) {
            response.addElement("skin").setText(skin);
        }
        return response;
    }

    @Override
    public boolean needsAuth(Map<String, Object> context) {
        return false;
    }

    public static void addAccountToLogContextByAuthToken(Provisioning prov, AuthToken at) {
        String aid;
        String id = at.getAccountId();
        if (id != null) {
            AccountUtil.addAccountToLogContext(prov, id, "name", "id", null);
        }
        if ((aid = at.getAdminAccountId()) != null && !aid.equals(id)) {
            AccountUtil.addAccountToLogContext(prov, aid, "aname", "aid", null);
        }
    }
}

