/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.account;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AccountConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.common.util.StringUtil;
import com.zimbra.cs.service.account.Auth;
import com.zimbra.cs.service.account.AutoCompleteGal;
import com.zimbra.cs.service.account.ChangePassword;
import com.zimbra.cs.service.account.CreateIdentity;
import com.zimbra.cs.service.account.CreateSignature;
import com.zimbra.cs.service.account.DeleteIdentity;
import com.zimbra.cs.service.account.DeleteSignature;
import com.zimbra.cs.service.account.EndSession;
import com.zimbra.cs.service.account.GetAccountInfo;
import com.zimbra.cs.service.account.GetAllLocales;
import com.zimbra.cs.service.account.GetAvailableCsvFormats;
import com.zimbra.cs.service.account.GetAvailableLocales;
import com.zimbra.cs.service.account.GetAvailableSkins;
import com.zimbra.cs.service.account.GetIdentities;
import com.zimbra.cs.service.account.GetInfo;
import com.zimbra.cs.service.account.GetPrefs;
import com.zimbra.cs.service.account.GetShareInfo;
import com.zimbra.cs.service.account.GetSignatures;
import com.zimbra.cs.service.account.GetVersionInfo;
import com.zimbra.cs.service.account.GetWhiteBlackList;
import com.zimbra.cs.service.account.ModifyIdentity;
import com.zimbra.cs.service.account.ModifyPrefs;
import com.zimbra.cs.service.account.ModifyProperties;
import com.zimbra.cs.service.account.ModifySignature;
import com.zimbra.cs.service.account.ModifyWhiteBlackList;
import com.zimbra.cs.service.account.SearchCalendarResources;
import com.zimbra.cs.service.account.SearchGal;
import com.zimbra.cs.service.account.SyncGal;
import com.zimbra.soap.DocumentDispatcher;
import com.zimbra.soap.DocumentService;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccountService
implements DocumentService {
    @Override
    public void registerHandlers(DocumentDispatcher dispatcher) {
        dispatcher.registerHandler(AccountConstants.AUTH_REQUEST, new Auth());
        dispatcher.registerHandler(AccountConstants.CHANGE_PASSWORD_REQUEST, new ChangePassword());
        dispatcher.registerHandler(AccountConstants.END_SESSION_REQUEST, new EndSession());
        dispatcher.registerHandler(AccountConstants.GET_PREFS_REQUEST, new GetPrefs());
        dispatcher.registerHandler(AccountConstants.MODIFY_PREFS_REQUEST, new ModifyPrefs());
        dispatcher.registerHandler(AccountConstants.GET_INFO_REQUEST, new GetInfo());
        dispatcher.registerHandler(AccountConstants.GET_ACCOUNT_INFO_REQUEST, new GetAccountInfo());
        dispatcher.registerHandler(AccountConstants.SEARCH_GAL_REQUEST, new SearchGal());
        dispatcher.registerHandler(AccountConstants.AUTO_COMPLETE_GAL_REQUEST, new AutoCompleteGal());
        dispatcher.registerHandler(AccountConstants.SYNC_GAL_REQUEST, new SyncGal());
        dispatcher.registerHandler(AccountConstants.SEARCH_CALENDAR_RESOURCES_REQUEST, new SearchCalendarResources());
        dispatcher.registerHandler(AccountConstants.MODIFY_PROPERTIES_REQUEST, new ModifyProperties());
        dispatcher.registerHandler(AccountConstants.GET_ALL_LOCALES_REQUEST, new GetAllLocales());
        dispatcher.registerHandler(AccountConstants.GET_AVAILABLE_LOCALES_REQUEST, new GetAvailableLocales());
        dispatcher.registerHandler(AccountConstants.GET_AVAILABLE_SKINS_REQUEST, new GetAvailableSkins());
        dispatcher.registerHandler(AccountConstants.GET_AVAILABLE_CSV_FORMATS_REQUEST, new GetAvailableCsvFormats());
        dispatcher.registerHandler(AccountConstants.CREATE_IDENTITY_REQUEST, new CreateIdentity());
        dispatcher.registerHandler(AccountConstants.MODIFY_IDENTITY_REQUEST, new ModifyIdentity());
        dispatcher.registerHandler(AccountConstants.DELETE_IDENTITY_REQUEST, new DeleteIdentity());
        dispatcher.registerHandler(AccountConstants.GET_IDENTITIES_REQUEST, new GetIdentities());
        dispatcher.registerHandler(AccountConstants.CREATE_SIGNATURE_REQUEST, new CreateSignature());
        dispatcher.registerHandler(AccountConstants.MODIFY_SIGNATURE_REQUEST, new ModifySignature());
        dispatcher.registerHandler(AccountConstants.DELETE_SIGNATURE_REQUEST, new DeleteSignature());
        dispatcher.registerHandler(AccountConstants.GET_SIGNATURES_REQUEST, new GetSignatures());
        dispatcher.registerHandler(AccountConstants.GET_SHARE_INFO_REQUEST, new GetShareInfo());
        dispatcher.registerHandler(AccountConstants.GET_WHITE_BLACK_LIST_REQUEST, new GetWhiteBlackList());
        dispatcher.registerHandler(AccountConstants.MODIFY_WHITE_BLACK_LIST_REQUEST, new ModifyWhiteBlackList());
        dispatcher.registerHandler(AccountConstants.GET_VERSION_INFO_REQUEST, new GetVersionInfo());
    }

    public static Map<String, Object> getAttrs(Element request, String nameAttr) throws ServiceException {
        return AccountService.getAttrs(request, false, nameAttr);
    }

    public static Map<String, Object> getAttrs(Element request, boolean ignoreEmptyValues, String nameAttr) throws ServiceException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Element.KeyValuePair pair : request.listKeyValuePairs("a", nameAttr)) {
            String name = pair.getKey();
            String value = pair.getValue();
            if (ignoreEmptyValues && (value == null || value.length() <= 0)) continue;
            StringUtil.addToMultiMap(result, name, value);
        }
        return result;
    }
}

