/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.account;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Server;
import com.zimbra.soap.DocumentHandler;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AccountDocumentHandler
extends DocumentHandler {
    @Override
    protected Element proxyIfNecessary(Element request, Map<String, Object> context) throws ServiceException {
        try {
            return super.proxyIfNecessary(request, context);
        }
        catch (ServiceException e) {
            if ("service.PROXY_ERROR".equals(e.getCode())) {
                return null;
            }
            throw e;
        }
    }

    protected boolean checkPasswordSecurity(Map<String, Object> context) throws ServiceException {
        HttpServletRequest req = (HttpServletRequest)context.get("servlet.request");
        boolean isHttps = req.getScheme().equals("https");
        if (isHttps) {
            return true;
        }
        Server server = Provisioning.getInstance().getLocalServer();
        String modeString = server.getAttr("zimbraMailMode", null);
        if (modeString == null) {
            ZimbraLog.soap.warn("missing zimbraMailMode for checking password security, allowing the request");
            return true;
        }
        Provisioning.MailMode mailMode = Provisioning.MailMode.fromString(modeString);
        return mailMode != Provisioning.MailMode.mixed || server.getBooleanAttr("zimbraMailClearTextPasswordEnabled", true);
    }
}

