/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service;

import com.zimbra.common.soap.Element;
import com.zimbra.common.util.StringUtil;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AuthToken;
import com.zimbra.cs.account.AuthTokenException;
import com.zimbra.cs.account.ZimbraAuthToken;
import com.zimbra.cs.service.AuthProvider;
import com.zimbra.cs.service.AuthProviderException;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

public class ZimbraAuthProvider
extends AuthProvider {
    ZimbraAuthProvider() {
        super("zimbra");
    }

    public static String cookieName(boolean isAdminReq) {
        return isAdminReq ? "ZM_ADMIN_AUTH_TOKEN" : "ZM_AUTH_TOKEN";
    }

    protected AuthToken authToken(HttpServletRequest req, boolean isAdminReq) throws AuthProviderException, AuthTokenException {
        String cookieName = ZimbraAuthProvider.cookieName(isAdminReq);
        String encodedAuthToken = null;
        Cookie[] cookies = req.getCookies();
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                if (!cookies[i].getName().equals(cookieName)) continue;
                encodedAuthToken = cookies[i].getValue();
                break;
            }
        }
        return this.genAuthToken(encodedAuthToken);
    }

    protected AuthToken authToken(Element soapCtxt, Map engineCtxt) throws AuthProviderException, AuthTokenException {
        String encodedAuthToken;
        String string = encodedAuthToken = soapCtxt == null ? null : soapCtxt.getAttribute("authToken", null);
        if (encodedAuthToken == null) {
            encodedAuthToken = (String)engineCtxt.get("zimbra.authToken");
        }
        return this.genAuthToken(encodedAuthToken);
    }

    protected AuthToken authToken(String encoded) throws AuthProviderException, AuthTokenException {
        return this.genAuthToken(encoded);
    }

    private AuthToken genAuthToken(String encodedAuthToken) throws AuthProviderException, AuthTokenException {
        if (StringUtil.isNullOrEmpty(encodedAuthToken)) {
            throw AuthProviderException.NO_AUTH_DATA();
        }
        return ZimbraAuthToken.getAuthToken(encodedAuthToken);
    }

    protected AuthToken authToken(Account acct) {
        return new ZimbraAuthToken(acct);
    }

    protected AuthToken authToken(Account acct, boolean isAdmin) {
        return new ZimbraAuthToken(acct, isAdmin);
    }

    protected AuthToken authToken(Account acct, long expires) {
        return new ZimbraAuthToken(acct, expires);
    }

    protected AuthToken authToken(Account acct, long expires, boolean isAdmin, Account adminAcct) {
        return new ZimbraAuthToken(acct, expires, isAdmin, adminAcct);
    }
}

