/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service;

import com.zimbra.common.auth.ZAuthToken;
import com.zimbra.common.mime.ContentDisposition;
import com.zimbra.common.mime.ContentType;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ByteUtil;
import com.zimbra.common.util.DateUtil;
import com.zimbra.common.util.HttpUtil;
import com.zimbra.common.util.L10nUtil;
import com.zimbra.common.util.Pair;
import com.zimbra.common.util.ZimbraHttpConnectionManager;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AuthToken;
import com.zimbra.cs.account.AuthTokenException;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Server;
import com.zimbra.cs.account.ZimbraAuthTokenEncoded;
import com.zimbra.cs.httpclient.HttpProxyUtil;
import com.zimbra.cs.httpclient.URLUtil;
import com.zimbra.cs.mailbox.ACL;
import com.zimbra.cs.mailbox.Document;
import com.zimbra.cs.mailbox.Folder;
import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.mailbox.Mountpoint;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.service.AuthProvider;
import com.zimbra.cs.service.FileUploadServlet;
import com.zimbra.cs.service.UserServletException;
import com.zimbra.cs.service.formatter.AtomFormatter;
import com.zimbra.cs.service.formatter.ContactFolderFormatter;
import com.zimbra.cs.service.formatter.CsvFormatter;
import com.zimbra.cs.service.formatter.Formatter;
import com.zimbra.cs.service.formatter.FreeBusyFormatter;
import com.zimbra.cs.service.formatter.HtmlFormatter;
import com.zimbra.cs.service.formatter.IcsFormatter;
import com.zimbra.cs.service.formatter.IfbFormatter;
import com.zimbra.cs.service.formatter.JsonFormatter;
import com.zimbra.cs.service.formatter.NativeFormatter;
import com.zimbra.cs.service.formatter.RssFormatter;
import com.zimbra.cs.service.formatter.SyncFormatter;
import com.zimbra.cs.service.formatter.TarFormatter;
import com.zimbra.cs.service.formatter.TgzFormatter;
import com.zimbra.cs.service.formatter.VcfFormatter;
import com.zimbra.cs.service.formatter.WikiFormatter;
import com.zimbra.cs.service.formatter.XmlFormatter;
import com.zimbra.cs.service.formatter.ZipFormatter;
import com.zimbra.cs.service.util.ItemId;
import com.zimbra.cs.servlet.ZimbraServlet;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PutMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserServlet
extends ZimbraServlet {
    private static final long serialVersionUID = -5313094316561384586L;
    public static final String SERVLET_PATH = "/home";
    public static final String QP_ZAUTHTOKEN = "zauthtoken";
    public static final String QP_AUTHTOKEN = "authToken";
    public static final String QP_FMT = "fmt";
    public static final String QP_ZLV = "zlv";
    public static final String QP_ID = "id";
    public static final String QP_LIST = "list";
    public static final String QP_IMAP_ID = "imap_id";
    public static final String QP_PART = "part";
    public static final String QP_BODY = "body";
    public static final String BODY_TEXT = "text";
    public static final String BODY_HTML = "html";
    public static final String QP_QUERY = "query";
    public static final String QP_VIEW = "view";
    public static final String QP_TYPES = "types";
    public static final String QP_START = "start";
    public static final String QP_END = "end";
    public static final String QP_FREEBUSY_CALENDAR = "fbcal";
    public static final String QP_IGNORE_ERROR = "ignore";
    public static final String QP_PRESERVE_ALARMS = "preserveAlarms";
    public static final String QP_OFFSET = "offset";
    public static final String QP_LIMIT = "limit";
    public static final String QP_AUTH = "auth";
    public static final String QP_DISP = "disp";
    public static final String QP_NAME = "name";
    public static final String QP_CSVFORMAT = "csvfmt";
    public static final String QP_VERSION = "ver";
    public static final String QP_HISTORY = "history";
    public static final String QP_LANGUAGE = "language";
    public static final String QP_COUNTRY = "country";
    public static final String QP_VARIANT = "variant";
    public static final String UPLOAD_NAME = "uploadName";
    public static final String UPLOAD_TYPE = "uploadType";
    public static final String QP_META = "meta";
    public static final String QP_EXUID = "exuid";
    public static final String AUTH_COOKIE = "co";
    public static final String AUTH_BASIC = "ba";
    public static final String AUTH_QUERYPARAM = "qp";
    public static final String AUTH_NO_SET_COOKIE = "nsc";
    public static final String AUTH_SET_COOKIE = "sc";
    public static final String AUTH_DEFAULT = "co,nsc,qp";
    public static final String HTTP_URL = "http_url";
    public static final String HTTP_STATUS_CODE = "http_code";
    private static HashMap<String, Formatter> mFormatters = new HashMap();
    private static HashMap<String, Formatter> mDefaultFormatters = new HashMap();
    protected static final String MSGPAGE_BLOCK = "errorpage.attachment.blocked";
    private String mBlockPage = null;

    public static String getRestUrl(Account acct) throws ServiceException {
        return UserServlet.getServiceUrl(acct, SERVLET_PATH);
    }

    public static String getRestUrl(MailItem item) throws ServiceException {
        Account acct = item.getMailbox().getAccount();
        return UserServlet.getRestUrl(acct) + URLUtil.urlEscape(item.getPath());
    }

    public static synchronized void addFormatter(Formatter f) {
        mFormatters.put(f.getType(), f);
        for (String mimeType : f.getDefaultMimeTypes()) {
            mDefaultFormatters.put(mimeType, f);
        }
    }

    public Formatter getFormatter(String type) {
        return mFormatters.get(type);
    }

    private Mailbox getTargetMailbox(Context context) {
        Mailbox mbox = null;
        try {
            mbox = context.targetMailbox = MailboxManager.getInstance().getMailboxByAccount(context.targetAccount);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return mbox;
    }

    private void getAccount(Context context) throws IOException, ServletException, UserServletException {
        try {
            boolean isAdminRequest;
            block19: {
                isAdminRequest = this.isAdminRequest(context.req);
                if (context.cookieAuthAllowed() || AuthProvider.allowAccessKeyAuth(context.req, this)) {
                    try {
                        AuthToken at = AuthProvider.getAuthToken(context.req, isAdminRequest);
                        if (at == null) break block19;
                        if (at.isZimbraUser()) {
                            try {
                                context.authAccount = AuthProvider.validateAuthToken(Provisioning.getInstance(), at, false);
                            }
                            catch (ServiceException e) {
                                throw new UserServletException(401, L10nUtil.getMessage(L10nUtil.MsgKey.errMustAuthenticate, context.req, new Object[0]));
                            }
                            context.cookieAuthHappened = true;
                            context.authToken = at;
                            return;
                        }
                        if (at.isExpired()) {
                            throw new UserServletException(401, L10nUtil.getMessage(L10nUtil.MsgKey.errMustAuthenticate, context.req, new Object[0]));
                        }
                        context.authAccount = new ACL.GuestAccount(at);
                        context.basicAuthHappened = true;
                        context.authToken = at;
                        return;
                    }
                    catch (AuthTokenException e) {
                        throw new UserServletException(401, L10nUtil.getMessage(L10nUtil.MsgKey.errMustAuthenticate, context.req, new Object[0]));
                    }
                }
            }
            if (context.queryParamAuthAllowed()) {
                String auth = context.params.get(QP_ZAUTHTOKEN);
                if (auth == null) {
                    auth = context.params.get(QP_AUTHTOKEN);
                }
                if (auth != null) {
                    try {
                        AuthToken at = AuthProvider.getAuthToken(auth);
                        try {
                            context.authAccount = AuthProvider.validateAuthToken(Provisioning.getInstance(), at, false);
                            context.qpAuthHappened = true;
                            context.authToken = at;
                            return;
                        }
                        catch (ServiceException e) {
                            throw new UserServletException(401, L10nUtil.getMessage(L10nUtil.MsgKey.errMustAuthenticate, context.req, new Object[0]));
                        }
                    }
                    catch (AuthTokenException e) {
                        throw new UserServletException(401, L10nUtil.getMessage(L10nUtil.MsgKey.errMustAuthenticate, context.req, new Object[0]));
                    }
                }
            }
            if (context.basicAuthAllowed()) {
                context.authAccount = this.basicAuthRequest(context.req, context.resp, false);
                if (context.authAccount != null) {
                    context.basicAuthHappened = true;
                    context.authToken = AuthProvider.getAuthToken(context.authAccount, isAdminRequest);
                    if (context.setCookie()) {
                        boolean secureCookie = context.req.getScheme().equals("https");
                        context.authToken.encode(context.resp, isAdminRequest, secureCookie);
                    }
                }
                return;
            }
        }
        catch (ServiceException e) {
            throw new ServletException((Throwable)e);
        }
    }

    private void sendError(Context ctxt, HttpServletRequest req, HttpServletResponse resp, String message) throws IOException {
        if (ctxt == null) {
            resp.sendError(403, message);
        } else if (!ctxt.cookieAuthHappened && ctxt.basicAuthAllowed() && !ctxt.basicAuthHappened) {
            resp.addHeader("WWW-Authenticate", this.getRealmHeader());
            resp.sendError(401, message);
        } else {
            resp.sendError(403, message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        block13: {
            block12: {
                block11: {
                    Context context = null;
                    ZimbraLog.clearContext();
                    this.addRemoteIpToLoggingContext(req);
                    try {
                        try {
                            context = new Context(req, resp, this);
                            if (!this.checkAuthentication(req, resp, context)) {
                                this.sendError(context, req, resp, L10nUtil.getMessage(L10nUtil.MsgKey.errMustAuthenticate, req, new Object[0]));
                                Object var6_4 = null;
                                break block11;
                            }
                            if (this.proxyIfNecessary(req, resp, context)) {
                                break block12;
                            }
                            if (context.authAccount != null) {
                                ZimbraLog.addAccountNameToContext(context.authAccount.getName());
                                if (context.authAccount.getLocale() != null && context.locale == null) {
                                    context.locale = context.authAccount.getLocale();
                                }
                            }
                            this.doAuthGet(req, resp, context);
                            break block13;
                        }
                        catch (MailServiceException.NoSuchItemException e) {
                            resp.sendError(404, L10nUtil.getMessage(L10nUtil.MsgKey.errNoSuchItem, req, new Object[0]));
                            Object var6_7 = null;
                            ZimbraLog.clearContext();
                            return;
                        }
                        catch (ServiceException se) {
                            if (se.getCode() != "service.PERM_DENIED") throw new ServletException((Throwable)se);
                            this.sendError(context, req, resp, se.getMessage());
                            Object var6_8 = null;
                            ZimbraLog.clearContext();
                            return;
                        }
                        catch (UserServletException e) {
                            resp.sendError(e.getHttpStatusCode(), e.getMessage());
                            Object var6_9 = null;
                            ZimbraLog.clearContext();
                            return;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var6_10 = null;
                        ZimbraLog.clearContext();
                        throw throwable;
                    }
                }
                ZimbraLog.clearContext();
                return;
            }
            Object var6_5 = null;
            ZimbraLog.clearContext();
            return;
        }
        Object var6_6 = null;
        ZimbraLog.clearContext();
    }

    private boolean checkAuthentication(HttpServletRequest req, HttpServletResponse resp, Context context) throws IOException, ServletException, UserServletException {
        if (context.targetAccount == null && context.accountPath.equals("~")) {
            this.getAccount(context);
            if (context.authAccount == null) {
                return false;
            }
            context.targetAccount = context.authAccount;
        }
        this.getAccount(context);
        if (context.authAccount == null) {
            context.setAnonymousRequest();
        }
        return true;
    }

    private AuthToken getProxyAuthToken(Context context) throws ServiceException {
        String encoded = Provisioning.getInstance().getProxyAuthToken(context.targetAccount.getId());
        if (encoded != null) {
            return new ZimbraAuthTokenEncoded(encoded);
        }
        if (context.basicAuthHappened) {
            return context.authToken;
        }
        return null;
    }

    private boolean proxyIfNecessary(HttpServletRequest req, HttpServletResponse resp, Context context) throws IOException, ServiceException {
        if (context.targetAccount != null && !Provisioning.onLocalServer(context.targetAccount)) {
            this.proxyServletRequest(req, resp, Provisioning.getInstance().getServer(context.targetAccount), this.getProxyAuthToken(context));
            return true;
        }
        return false;
    }

    private void doAuthGet(HttpServletRequest req, HttpServletResponse resp, Context context) throws ServletException, IOException, ServiceException, UserServletException {
        if (ZimbraLog.mailbox.isDebugEnabled()) {
            StringBuffer reqURL = context.req.getRequestURL();
            String queryParam = context.req.getQueryString();
            if (queryParam != null) {
                reqURL.append('?').append(queryParam);
            }
            ZimbraLog.mailbox.debug("UserServlet: " + reqURL.toString());
        }
        context.opContext = new OperationContext(context.authAccount, this.isAdminRequest(req));
        Mailbox mbox = this.getTargetMailbox(context);
        if (mbox != null) {
            ZimbraLog.addMboxToContext(mbox.getId());
            if (context.reqListIds != null) {
                this.resolveItems(context);
            } else {
                MailItem item = this.resolveItem(context, true);
                if (this.isProxyRequest(req, resp, context, item)) {
                    return;
                }
            }
        }
        this.resolveFormatter(context);
        if (mbox == null && context.formatter.requiresAuth()) {
            throw ServiceException.PERM_DENIED(L10nUtil.getMessage(L10nUtil.MsgKey.errPermissionDenied, req, new Object[0]));
        }
        if (context.formatter.canBeBlocked() && Formatter.checkGlobalOverride("zimbraAttachmentsBlocked", context.authAccount)) {
            this.sendbackBlockMessage(context.req, context.resp);
            return;
        }
        context.formatter.format(context);
    }

    public void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doPost(req, resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        block24: {
            block23: {
                block22: {
                    block21: {
                        Context context = null;
                        ZimbraLog.clearContext();
                        this.addRemoteIpToLoggingContext(req);
                        try {
                            try {
                                String normalizedType;
                                Formatter fmt;
                                context = new Context(req, resp, this);
                                if (!this.checkAuthentication(req, resp, context)) {
                                    this.sendError(context, req, resp, L10nUtil.getMessage(L10nUtil.MsgKey.errMustAuthenticate, req, new Object[0]));
                                    Object var11_4 = null;
                                    break block21;
                                }
                                if (this.proxyIfNecessary(req, resp, context)) {
                                    break block22;
                                }
                                if (context.authAccount != null) {
                                    ZimbraLog.addAccountNameToContext(context.authAccount.getName());
                                }
                                Folder folder = null;
                                String filename = null;
                                Mailbox mbox = this.getTargetMailbox(context);
                                if (mbox != null) {
                                    ZimbraLog.addMboxToContext(mbox.getId());
                                    ZimbraLog.mailbox.info("UserServlet (POST): " + context.req.getRequestURL().toString());
                                    context.opContext = new OperationContext(context.authAccount, this.isAdminRequest(req));
                                    try {
                                        context.target = this.resolveItem(context, false);
                                    }
                                    catch (MailServiceException.NoSuchItemException nsie) {
                                        if (context.itemPath == null) {
                                            throw nsie;
                                        }
                                        int separator = context.itemPath.lastIndexOf(47);
                                        if (separator <= 0) {
                                            throw nsie;
                                        }
                                        filename = context.itemPath.substring(separator + 1);
                                        context.itemPath = context.itemPath.substring(0, separator);
                                        context.target = this.resolveItem(context, false);
                                        context.extraPath = filename;
                                    }
                                    Folder folder2 = folder = context.target instanceof Folder ? (Folder)context.target : mbox.getFolderById(context.opContext, context.target.getFolderId());
                                    if (context.target != folder) {
                                        if (filename != null) throw MailServiceException.NO_SUCH_FOLDER(context.itemPath);
                                        filename = context.target.getName();
                                    }
                                    if (this.isProxyRequest(req, resp, context, folder)) {
                                        break block23;
                                    }
                                }
                                if (context.format == null && filename != null) {
                                    context.format = "native";
                                }
                                String ctype = context.req.getContentType();
                                if (context.format == null && ctype != null && (fmt = mDefaultFormatters.get(normalizedType = new ContentType(ctype).getValue())) != null) {
                                    context.format = fmt.getType();
                                }
                                context.target = folder;
                                this.resolveFormatter(context);
                                if (!context.formatter.supportsSave()) {
                                    this.sendError(context, req, resp, L10nUtil.getMessage(L10nUtil.MsgKey.errUnsupportedFormat, req, new Object[0]));
                                }
                                if (mbox == null && context.formatter.requiresAuth()) {
                                    throw ServiceException.PERM_DENIED(L10nUtil.getMessage(L10nUtil.MsgKey.errPermissionDenied, req, new Object[0]));
                                }
                                context.formatter.save(context, ctype, folder, filename);
                                break block24;
                            }
                            catch (MailServiceException.NoSuchItemException e) {
                                resp.sendError(404, "no such item");
                                Object var11_8 = null;
                                ZimbraLog.clearContext();
                                return;
                            }
                            catch (ServiceException se) {
                                if (se.getCode() != "service.PERM_DENIED") throw new ServletException((Throwable)se);
                                this.sendError(context, req, resp, se.getMessage());
                                Object var11_9 = null;
                                ZimbraLog.clearContext();
                                return;
                            }
                            catch (UserServletException e) {
                                resp.sendError(e.getHttpStatusCode(), e.getMessage());
                                Object var11_10 = null;
                                ZimbraLog.clearContext();
                                return;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var11_11 = null;
                            ZimbraLog.clearContext();
                            throw throwable;
                        }
                    }
                    ZimbraLog.clearContext();
                    return;
                }
                Object var11_5 = null;
                ZimbraLog.clearContext();
                return;
            }
            Object var11_6 = null;
            ZimbraLog.clearContext();
            return;
        }
        Object var11_7 = null;
        ZimbraLog.clearContext();
    }

    private void resolveFormatter(Context context) throws UserServletException {
        if (context.format == null) {
            context.format = this.defaultFormat(context);
            if (context.format == null) {
                throw new UserServletException(400, L10nUtil.getMessage(L10nUtil.MsgKey.errUnsupportedFormat, context.req, new Object[0]));
            }
        }
        if (context.formatter == null) {
            context.formatter = mFormatters.get(context.format);
        }
        if (context.formatter == null) {
            throw new UserServletException(400, L10nUtil.getMessage(L10nUtil.MsgKey.errUnsupportedFormat, context.req, new Object[0]));
        }
    }

    private void resolveItems(Context context) throws ServiceException {
        context.respListItems = new ArrayList<MailItem>();
        for (int id : context.reqListIds) {
            try {
                context.respListItems.add(context.targetMailbox.getItemById(context.opContext, id, (byte)-1));
            }
            catch (MailServiceException.NoSuchItemException x) {
                ZimbraLog.misc.info(x.getMessage());
            }
            catch (ServiceException x) {
                if (x.getCode().equals("service.PERM_DENIED")) {
                    ZimbraLog.misc.info(x.getMessage());
                    continue;
                }
                throw x;
            }
        }
        if (context.respListItems.isEmpty()) {
            throw MailServiceException.NO_SUCH_ITEM(context.reqListIds.toString());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private MailItem resolveItem(Context context, boolean checkExtension) throws ServiceException {
        if (context.formatter != null && !context.formatter.requiresAuth()) {
            return null;
        }
        Mailbox mbox = context.targetMailbox;
        if (context.imapId > 0) {
            Folder folder = mbox.getFolderByPath(context.opContext, context.itemPath);
            return mbox.getItemByImapId(context.opContext, context.imapId, folder.getId());
        }
        if (context.itemId != null) {
            context.target = mbox.getItemById(context.opContext, context.itemId.getId(), (byte)-1);
            context.itemPath = context.target.getPath();
            if (context.target instanceof Mountpoint || context.extraPath == null || context.extraPath.equals("")) {
                return context.target;
            }
            if (context.itemPath == null) {
                throw MailServiceException.NO_SUCH_ITEM("?id=" + context.itemId + "&name=" + context.extraPath);
            }
            context.target = null;
            context.itemId = null;
        }
        if (context.extraPath != null && !context.extraPath.equals("")) {
            context.itemPath = (context.itemPath + '/' + context.extraPath).replaceAll("//+", "/");
            context.extraPath = null;
        }
        if (context.format != null && (context.format.equalsIgnoreCase("freebusy") || context.format.equalsIgnoreCase("ifb"))) {
            try {
                context.target = mbox.getItemByPath(null, context.itemPath);
                return context.target;
            }
            catch (ServiceException e) {
                if (e instanceof MailServiceException.NoSuchItemException) return context.target;
                throw e;
            }
        }
        ServiceException failure = null;
        try {
            context.target = mbox.getItemByPath(context.opContext, context.itemPath);
        }
        catch (ServiceException e) {
            if (!(e instanceof MailServiceException.NoSuchItemException) && !e.getCode().equals("service.PERM_DENIED")) {
                throw e;
            }
            failure = e;
        }
        if (context.target == null) {
            int dot = context.itemPath.lastIndexOf(46);
            int slash = context.itemPath.lastIndexOf(47);
            if (checkExtension && context.format == null && dot != -1 && dot > slash) {
                String unsuffixedPath = context.itemPath.substring(0, dot);
                try {
                    context.target = mbox.getItemByPath(context.opContext, unsuffixedPath);
                    context.format = context.itemPath.substring(dot + 1);
                    context.itemPath = unsuffixedPath;
                }
                catch (ServiceException e) {
                    // empty catch block
                }
            }
        }
        if (context.target == null) {
            try {
                Pair<Folder, String> match = mbox.getFolderByPathLongestMatch(context.opContext, 1, context.itemPath);
                Folder reachable = match.getFirst();
                if (reachable instanceof Mountpoint) {
                    context.target = reachable;
                    context.itemPath = reachable.getPath();
                    context.extraPath = match.getSecond();
                }
            }
            catch (ServiceException e) {
                // empty catch block
            }
        }
        if (context.target != null || context.getQueryString() != null) return context.target;
        throw failure;
    }

    private boolean isProxyRequest(HttpServletRequest req, HttpServletResponse resp, Context context, MailItem item) throws IOException, ServiceException, UserServletException {
        if (!(item instanceof Mountpoint)) {
            return false;
        }
        if (context.format != null && context.format.equals(BODY_HTML)) {
            return false;
        }
        Mountpoint mpt = (Mountpoint)item;
        String uri = "/home/~/?id=" + URLUtil.urlEscape(mpt.getOwnerId()) + "%3A" + mpt.getRemoteId();
        if (context.format != null) {
            uri = uri + "&fmt=" + URLUtil.urlEscape(context.format);
        }
        if (context.extraPath != null) {
            uri = uri + "&name=" + URLUtil.urlEscape(context.extraPath);
        }
        for (Map.Entry<String, String> entry : HttpUtil.getURIParams(req).entrySet()) {
            String qp = entry.getKey();
            if (qp.equals(QP_ID) || qp.equals(QP_FMT)) continue;
            uri = uri + '&' + URLUtil.urlEscape(qp) + '=' + URLUtil.urlEscape(entry.getValue());
        }
        Provisioning prov = Provisioning.getInstance();
        Account targetAccount = prov.get(Provisioning.AccountBy.id, mpt.getOwnerId());
        if (targetAccount == null) {
            throw new UserServletException(400, L10nUtil.getMessage(L10nUtil.MsgKey.errNoSuchAccount, req, new Object[0]));
        }
        this.proxyServletRequest(req, resp, prov.getServer(targetAccount), uri, this.getProxyAuthToken(context));
        return true;
    }

    @Override
    protected String getRealmHeader() {
        return "BASIC realm=\"Zimbra\"";
    }

    private String defaultFormat(Context context) {
        if (context.hasPart()) {
            return "native";
        }
        int type = -1;
        if (context.target instanceof Folder) {
            type = ((Folder)context.target).getDefaultView();
        } else if (context.target != null) {
            type = context.target.getType();
        }
        switch (type) {
            case 11: 
            case 15: {
                return "ics";
            }
            case 6: {
                return context.target instanceof Folder ? "csv" : "vcf";
            }
            case 14: {
                return "wiki";
            }
            case 8: {
                return context.target instanceof Folder ? "wiki" : "native";
            }
        }
        return "native";
    }

    private void sendbackBlockMessage(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        RequestDispatcher dispatcher = this.getServletContext().getRequestDispatcher(this.mBlockPage);
        if (dispatcher != null) {
            dispatcher.forward((ServletRequest)req, (ServletResponse)resp);
            return;
        }
        resp.sendError(403, L10nUtil.getMessage(L10nUtil.MsgKey.errAttachmentDownloadDisabled, req, new Object[0]));
    }

    @Override
    public void init() throws ServletException {
        String name = this.getServletName();
        ZimbraLog.mailbox.info("Servlet " + name + " starting up");
        super.init();
        this.mBlockPage = this.getInitParameter(MSGPAGE_BLOCK);
    }

    public void destroy() {
        String name = this.getServletName();
        ZimbraLog.mailbox.info("Servlet " + name + " shutting down");
        super.destroy();
    }

    public static byte[] getRemoteContent(AuthToken authToken, ItemId iid, Map<String, String> params) throws ServiceException {
        Account target = Provisioning.getInstance().get(Provisioning.AccountBy.id, iid.getAccountId(), authToken);
        HashMap<String, String> pcopy = new HashMap<String, String>(params);
        pcopy.put(QP_ID, iid.toString());
        return UserServlet.getRemoteContent(authToken, target, null, pcopy);
    }

    public static byte[] getRemoteContent(AuthToken authToken, Account target, String folder, Map<String, String> params) throws ServiceException {
        return UserServlet.getRemoteContent(authToken.toZAuthToken(), UserServlet.getRemoteUrl(target, folder, params));
    }

    public static byte[] getRemoteContent(ZAuthToken authToken, String url) throws ServiceException {
        return UserServlet.getRemoteResource(authToken, url).getSecond();
    }

    public static HttpInputStream getRemoteContentAsStream(AuthToken authToken, Account target, String folder, Map<String, String> params) throws ServiceException, IOException {
        String url = UserServlet.getRemoteUrl(target, folder, params);
        return UserServlet.getRemoteResourceAsStream(authToken.toZAuthToken(), url, null, 0, null, null).getSecond();
    }

    private static String getRemoteUrl(Account target, String folder, Map<String, String> params) throws ServiceException {
        if (folder == null) {
            folder = "";
        } else {
            if (folder.endsWith("/")) {
                folder = folder.substring(0, folder.length() - 1);
            }
            if (folder.startsWith("/")) {
                folder = folder.substring(1);
            }
        }
        Server server = Provisioning.getInstance().getServer(target);
        StringBuffer url = new StringBuffer(UserServlet.getProxyUrl(null, server, SERVLET_PATH + UserServlet.getAccountPath(target)));
        if (folder.length() > 0) {
            url.append("/").append(folder);
        }
        url.append("/?").append(QP_AUTH).append('=').append(AUTH_COOKIE);
        if (params != null) {
            for (Map.Entry<String, String> param : params.entrySet()) {
                url.append('&').append(URLUtil.urlEscape(param.getKey())).append('=').append(URLUtil.urlEscape(param.getValue()));
            }
        }
        return url.toString();
    }

    public static Pair<Header[], byte[]> getRemoteResource(ZAuthToken authToken, String url) throws ServiceException {
        return UserServlet.getRemoteResource(authToken, url, null, 0, null, null);
    }

    public static Pair<Header[], byte[]> getRemoteResource(ZAuthToken authToken, String url, String proxyHost, int proxyPort, String proxyUser, String proxyPass) throws ServiceException {
        HttpMethod get = null;
        try {
            Pair<Header[], HttpMethod> pair = UserServlet.doHttpOp(authToken, proxyHost, proxyPort, proxyUser, proxyPass, new GetMethod(url));
            get = pair.getSecond();
            Pair<Header[], byte[]> pair2 = new Pair<Header[], byte[]>(pair.getFirst(), get.getResponseBody());
            Object var10_10 = null;
            if (get != null) {
                get.releaseConnection();
            }
            return pair2;
        }
        catch (IOException x) {
            try {
                throw ServiceException.FAILURE("Can't read response body " + url, x);
            }
            catch (Throwable throwable) {
                block5: {
                    Object var10_11 = null;
                    if (get == null) break block5;
                    get.releaseConnection();
                }
                throw throwable;
            }
        }
    }

    public static FileUploadServlet.Upload getRemoteResourceAsUpload(AuthToken at, ItemId iid, Map<String, String> params) throws ServiceException, IOException {
        HashMap<String, String> pcopy = new HashMap<String, String>(params);
        pcopy.put(QP_ID, iid.toString());
        Provisioning prov = Provisioning.getInstance();
        Account target = prov.get(Provisioning.AccountBy.id, iid.getAccountId(), at);
        String url = UserServlet.getRemoteUrl(target, null, pcopy);
        Pair<Header[], HttpInputStream> response = UserServlet.getRemoteResourceAsStream(at.toZAuthToken(), url, null, 0, null, null);
        String ctype = "text/plain";
        String filename = null;
        for (Header hdr : response.getFirst()) {
            String hname = hdr.getName().toLowerCase();
            if (hname.equals("content-type")) {
                ctype = hdr.getValue();
                continue;
            }
            if (!hname.equals("content-disposition")) continue;
            filename = new ContentDisposition(hdr.getValue()).getParameter("filename");
        }
        if (filename == null || filename.equals("")) {
            filename = new ContentType(ctype).getParameter(QP_NAME);
        }
        if (filename == null || filename.equals("")) {
            filename = "unknown";
        }
        return FileUploadServlet.saveUpload(response.getSecond(), filename, ctype, at.getAccountId());
    }

    public static Pair<Header[], HttpInputStream> getRemoteResourceAsStream(ZAuthToken authToken, ItemId iid, String extraPath) throws ServiceException, IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(QP_ID, iid.toString());
        if (extraPath != null) {
            params.put(QP_NAME, extraPath);
        }
        Account target = Provisioning.getInstance().getAccountById(iid.getAccountId());
        String url = UserServlet.getRemoteUrl(target, null, params);
        return UserServlet.getRemoteResourceAsStream(authToken, url, null, 0, null, null);
    }

    public static Pair<Header[], HttpInputStream> getRemoteResourceAsStream(ZAuthToken authToken, String url, String proxyHost, int proxyPort, String proxyUser, String proxyPass) throws ServiceException, IOException {
        Pair<Header[], HttpMethod> pair = UserServlet.doHttpOp(authToken, proxyHost, proxyPort, proxyUser, proxyPass, new GetMethod(url));
        return new Pair<Header[], HttpInputStream>(pair.getFirst(), new HttpInputStream(pair.getSecond()));
    }

    public static Pair<Header[], HttpInputStream> putMailItem(ZAuthToken authToken, String url, MailItem item, String proxyHost, int proxyPort, String proxyUser, String proxyPass) throws ServiceException, IOException {
        if (item instanceof Document) {
            Document doc = (Document)item;
            StringBuilder u = new StringBuilder(url);
            u.append("?").append(QP_AUTH).append('=').append(AUTH_COOKIE);
            if (doc.getType() == 14) {
                u.append("&fmt=wiki");
            }
            PutMethod method = new PutMethod(u.toString());
            String contentType = doc.getContentType();
            method.addRequestHeader("Content-Type", contentType);
            method.setRequestEntity(new InputStreamRequestEntity(doc.getContentStream(), doc.getSize(), contentType));
            Pair<Header[], HttpMethod> pair = UserServlet.doHttpOp(authToken, proxyHost, proxyPort, proxyUser, proxyPass, method);
            return new Pair<Header[], HttpInputStream>(pair.getFirst(), new HttpInputStream(pair.getSecond()));
        }
        return UserServlet.putRemoteResource(authToken, url, item.getContentStream(), null, proxyHost, proxyPort, proxyUser, proxyPass);
    }

    public static Pair<Header[], HttpInputStream> putRemoteResource(AuthToken authToken, String url, Account target, InputStream req, Header[] headers) throws ServiceException, IOException {
        return UserServlet.putRemoteResource(authToken.toZAuthToken(), url, req, headers, null, 0, null, null);
    }

    public static Pair<Header[], HttpInputStream> putRemoteResource(ZAuthToken authToken, String url, InputStream req, Header[] headers, String proxyHost, int proxyPort, String proxyUser, String proxyPass) throws ServiceException, IOException {
        StringBuilder u = new StringBuilder(url);
        u.append("?").append(QP_AUTH).append('=').append(AUTH_COOKIE);
        PutMethod method = new PutMethod(u.toString());
        String contentType = "application/octet-stream";
        if (headers != null) {
            for (Header hdr : headers) {
                String name = hdr.getName();
                method.addRequestHeader(hdr);
                if (!name.equals("Content-Type")) continue;
                contentType = hdr.getValue();
            }
        }
        method.setRequestEntity(new InputStreamRequestEntity(req, contentType));
        Pair<Header[], HttpMethod> pair = UserServlet.doHttpOp(authToken, proxyHost, proxyPort, proxyUser, proxyPass, method);
        return new Pair<Header[], HttpInputStream>(pair.getFirst(), new HttpInputStream(pair.getSecond()));
    }

    private static Pair<Header[], HttpMethod> doHttpOp(ZAuthToken authToken, String proxyHost, int proxyPort, String proxyUser, String proxyPass, HttpMethod method) throws ServiceException {
        long contentLength;
        String url = "";
        String hostname = "";
        try {
            url = method.getURI().toString();
            hostname = method.getURI().getHost();
        }
        catch (IOException e) {
            ZimbraLog.mailbox.warn((Object)"can't parse target URI", e);
        }
        HttpClient client = ZimbraHttpConnectionManager.getInternalHttpConnMgr().newHttpClient();
        Map<String, String> cookieMap = authToken.cookieMap(false);
        if (cookieMap != null) {
            HttpState state = new HttpState();
            for (Map.Entry<String, String> ck : cookieMap.entrySet()) {
                state.addCookie(new Cookie(hostname, ck.getKey(), ck.getValue(), "/", null, false));
            }
            client.setState(state);
            client.getParams().setCookiePolicy("compatibility");
        }
        if (proxyHost != null && proxyPort > 0) {
            client.getHostConfiguration().setProxy(proxyHost, proxyPort);
            if (proxyUser != null && proxyPass != null) {
                client.getState().setProxyCredentials(new AuthScope(proxyHost, proxyPort), new UsernamePasswordCredentials(proxyUser, proxyPass));
            }
        } else {
            HttpProxyUtil.configureProxy(client);
        }
        if (method instanceof PutMethod && (contentLength = ((PutMethod)method).getRequestEntity().getContentLength()) > 0L) {
            int timeEstimate = Math.max(10000, (int)(contentLength / 100L));
            method.getParams().setSoTimeout(timeEstimate);
        }
        try {
            int statusCode = client.executeMethod(method);
            if (statusCode == 404) {
                throw MailServiceException.NO_SUCH_ITEM(-1);
            }
            if (statusCode != 200 && statusCode != 201 && statusCode != 204) {
                throw ServiceException.RESOURCE_UNREACHABLE(method.getStatusText(), null, new ServiceException.InternalArgument(HTTP_URL, url, ServiceException.Argument.Type.STR), new ServiceException.InternalArgument(HTTP_STATUS_CODE, statusCode, ServiceException.Argument.Type.NUM));
            }
            ArrayList<Header> headers = new ArrayList<Header>(Arrays.asList(method.getResponseHeaders()));
            headers.add(new Header("X-Zimbra-Http-Status", "" + statusCode));
            return new Pair<Header[], HttpMethod>(headers.toArray(new Header[0]), method);
        }
        catch (HttpException e) {
            throw ServiceException.RESOURCE_UNREACHABLE("HttpException while fetching " + url, e, new ServiceException.Argument[0]);
        }
        catch (IOException e) {
            throw ServiceException.RESOURCE_UNREACHABLE("IOException while fetching " + url, e, new ServiceException.Argument[0]);
        }
    }

    static {
        UserServlet.addFormatter(new CsvFormatter());
        UserServlet.addFormatter(new VcfFormatter());
        UserServlet.addFormatter(new IcsFormatter());
        UserServlet.addFormatter(new RssFormatter());
        UserServlet.addFormatter(new AtomFormatter());
        UserServlet.addFormatter(new NativeFormatter());
        UserServlet.addFormatter(new FreeBusyFormatter());
        UserServlet.addFormatter(new IfbFormatter());
        UserServlet.addFormatter(new SyncFormatter());
        UserServlet.addFormatter(new WikiFormatter());
        UserServlet.addFormatter(new XmlFormatter());
        UserServlet.addFormatter(new JsonFormatter());
        UserServlet.addFormatter(new HtmlFormatter());
        UserServlet.addFormatter(new TarFormatter());
        UserServlet.addFormatter(new TgzFormatter());
        UserServlet.addFormatter(new ZipFormatter());
        UserServlet.addFormatter(new ContactFolderFormatter());
    }

    public static class HttpInputStream
    extends FilterInputStream {
        private HttpMethod method;

        public HttpInputStream(HttpMethod m) throws IOException {
            super(m.getResponseBodyAsStream());
            this.method = m;
        }

        public int getContentLength() {
            String cl = this.getHeader("Content-Length");
            if (cl != null) {
                return Integer.parseInt(cl);
            }
            return -1;
        }

        public String getHeader(String headerName) {
            Header cl = this.method.getResponseHeader(headerName);
            if (cl != null) {
                return cl.getValue();
            }
            return null;
        }

        public int getStatusCode() {
            return this.method.getStatusCode();
        }

        public void close() {
            this.method.releaseConnection();
        }
    }

    public static class Context {
        public HttpServletRequest req;
        public HttpServletResponse resp;
        public Servlet servlet;
        public Map<String, String> params;
        public String format;
        public Formatter formatter;
        public boolean cookieAuthHappened;
        public boolean basicAuthHappened;
        public boolean qpAuthHappened;
        public String accountPath;
        public AuthToken authToken;
        public String itemPath;
        public String extraPath;
        public ItemId itemId;
        public MailItem target;
        public int[] reqListIds;
        public List<MailItem> respListItems;
        public int imapId = -1;
        public boolean sync;
        public Account authAccount;
        public Account targetAccount;
        public Mailbox targetMailbox;
        public OperationContext opContext;
        public Locale locale;
        private long mStartTime = -2L;
        private long mEndTime = -2L;
        private static final long DEFAULT_MAX_POST_SIZE = 0xA00000L;

        Context(HttpServletRequest request, HttpServletResponse response, UserServlet srvlt) throws UserServletException, ServiceException {
            String variant;
            String country;
            Provisioning prov = Provisioning.getInstance();
            this.req = request;
            this.resp = response;
            this.servlet = srvlt;
            this.params = HttpUtil.getURIParams(request);
            String language = this.params.get(UserServlet.QP_LANGUAGE);
            this.locale = language != null ? ((country = this.params.get(UserServlet.QP_COUNTRY)) != null ? ((variant = this.params.get(UserServlet.QP_VARIANT)) != null ? new Locale(language, country, variant) : new Locale(language, country)) : new Locale(language)) : this.req.getLocale();
            String pathInfo = request.getPathInfo();
            if (pathInfo == null || pathInfo.equals("/") || pathInfo.equals("") || !pathInfo.startsWith("/")) {
                throw new UserServletException(400, L10nUtil.getMessage(L10nUtil.MsgKey.errInvalidPath, request, new Object[0]));
            }
            int pos = pathInfo.indexOf(47, 1);
            if (pos == -1) {
                pos = pathInfo.length();
            }
            if (pos < 1) {
                throw new UserServletException(400, L10nUtil.getMessage(L10nUtil.MsgKey.errInvalidPath, request, new Object[0]));
            }
            this.accountPath = pathInfo.substring(1, pos).toLowerCase();
            if (pos < pathInfo.length()) {
                this.itemPath = pathInfo.substring(pos + 1);
                if (this.itemPath.equals("")) {
                    this.itemPath = "/";
                }
            } else {
                this.itemPath = "/";
            }
            this.extraPath = this.params.get(UserServlet.QP_NAME);
            this.format = this.params.get(UserServlet.QP_FMT);
            String id = this.params.get(UserServlet.QP_ID);
            try {
                this.itemId = id == null ? null : new ItemId(id, (String)null);
            }
            catch (ServiceException e) {
                throw new UserServletException(400, L10nUtil.getMessage(L10nUtil.MsgKey.errInvalidId, request, new Object[0]));
            }
            String listParam = this.params.get(UserServlet.QP_LIST);
            if (listParam != null && listParam.length() > 0) {
                String[] ids = listParam.split(",");
                this.reqListIds = new int[ids.length];
                for (int i = 0; i < ids.length; ++i) {
                    this.reqListIds[i] = Integer.parseInt(ids[i]);
                }
            }
            String imap = this.params.get(UserServlet.QP_IMAP_ID);
            try {
                this.imapId = imap == null ? -1 : Integer.parseInt(imap);
            }
            catch (NumberFormatException nfe) {
                throw new UserServletException(400, L10nUtil.getMessage(L10nUtil.MsgKey.errInvalidImapId, request, new Object[0]));
            }
            if (this.format != null) {
                this.format = this.format.toLowerCase();
                this.formatter = srvlt.getFormatter(this.format);
                if (this.formatter == null) {
                    throw new UserServletException(501, L10nUtil.getMessage(L10nUtil.MsgKey.errNotImplemented, request, new Object[0]));
                }
            }
            if (this.itemId != null && this.itemId.getAccountId() != null) {
                this.targetAccount = prov.get(Provisioning.AccountBy.id, this.itemId.getAccountId(), this.authToken);
                return;
            }
            if (this.accountPath.equals("~")) {
                return;
            }
            if (this.accountPath.startsWith("~")) {
                this.accountPath = this.accountPath.substring(1);
            }
            this.targetAccount = prov.get(Provisioning.AccountBy.name, this.accountPath, this.authToken);
        }

        public boolean isUsingAdminPrivileges() {
            return this.authToken != null && AuthToken.isAnyAdmin(this.authToken);
        }

        public Servlet getServlet() {
            return this.servlet;
        }

        public long getStartTime() {
            if (this.mStartTime == -2L) {
                String st = this.params.get(UserServlet.QP_START);
                long defaultStartTime = this.formatter.getDefaultStartTime();
                this.mStartTime = st != null ? DateUtil.parseDateSpecifier(st, defaultStartTime) : defaultStartTime;
            }
            return this.mStartTime;
        }

        public long getEndTime() {
            if (this.mEndTime == -2L) {
                String et = this.params.get(UserServlet.QP_END);
                long defaultEndTime = this.formatter.getDefaultEndTime();
                this.mEndTime = et != null ? DateUtil.parseDateSpecifier(et, defaultEndTime) : defaultEndTime;
            }
            return this.mEndTime;
        }

        public int getFreeBusyCalendar() {
            int folder = -1;
            String str = this.params.get(UserServlet.QP_FREEBUSY_CALENDAR);
            if (str != null) {
                try {
                    folder = Integer.parseInt(str);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return folder;
        }

        public boolean ignoreAndContinueOnError() {
            String val = this.params.get(UserServlet.QP_IGNORE_ERROR);
            if (val != null) {
                try {
                    int n = Integer.parseInt(val);
                    return n != 0;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return false;
        }

        public boolean preserveAlarms() {
            String val = this.params.get(UserServlet.QP_PRESERVE_ALARMS);
            if (val != null) {
                try {
                    int n = Integer.parseInt(val);
                    return n != 0;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return false;
        }

        public String getQueryString() {
            return this.params.get(UserServlet.QP_QUERY);
        }

        public boolean cookieAuthAllowed() {
            return this.getAuth().indexOf(UserServlet.AUTH_COOKIE) != -1;
        }

        public boolean isAuthedAcctGuest() {
            return this.authAccount != null && this.authAccount instanceof ACL.GuestAccount;
        }

        public boolean setCookie() {
            return !this.isAuthedAcctGuest() && this.getAuth().indexOf(UserServlet.AUTH_SET_COOKIE) != -1 && this.getAuth().indexOf(UserServlet.AUTH_NO_SET_COOKIE) == -1;
        }

        public boolean basicAuthAllowed() {
            String auth = this.getAuth();
            return auth.indexOf(UserServlet.AUTH_NO_SET_COOKIE) != -1 || auth.indexOf(UserServlet.AUTH_BASIC) != -1 || auth.indexOf(UserServlet.AUTH_SET_COOKIE) != -1;
        }

        public boolean queryParamAuthAllowed() {
            return this.getAuth().indexOf(UserServlet.AUTH_QUERYPARAM) != -1;
        }

        public String getAuth() {
            String a = this.params.get(UserServlet.QP_AUTH);
            return a == null || a.length() == 0 ? UserServlet.AUTH_DEFAULT : a;
        }

        public boolean hasPart() {
            String p = this.getPart();
            return p != null && p.length() > 0;
        }

        public String getPart() {
            return this.params.get(UserServlet.QP_PART);
        }

        public boolean hasBody() {
            String p = this.getBody();
            return p != null;
        }

        public String getBody() {
            return this.params.get(UserServlet.QP_BODY);
        }

        public boolean hasView() {
            String v = this.getView();
            return v != null && v.length() > 0;
        }

        public String getView() {
            return this.params.get(UserServlet.QP_VIEW);
        }

        public int getOffset() {
            int offset;
            String s = this.params.get(UserServlet.QP_OFFSET);
            if (s != null && (offset = Integer.parseInt(s)) > 0) {
                return offset;
            }
            return 0;
        }

        public int getLimit() {
            int limit;
            String s = this.params.get(UserServlet.QP_LIMIT);
            if (s != null && (limit = Integer.parseInt(s)) > 0) {
                return limit;
            }
            return 50;
        }

        public String getTypesString() {
            return this.params.get(UserServlet.QP_TYPES);
        }

        public boolean shouldReturnBody() {
            String bodyVal = this.params.get(UserServlet.QP_BODY);
            return bodyVal == null || !bodyVal.equals("0");
        }

        public void setAnonymousRequest() {
            this.authAccount = ACL.ANONYMOUS_ACCT;
        }

        public boolean isAnonymousRequest() {
            return this.authAccount.equals(ACL.ANONYMOUS_ACCT);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public byte[] getPostBody() throws ServiceException, IOException, UserServletException {
            byte[] byArray;
            long sizeLimit = Provisioning.getInstance().getLocalServer().getLongAttr("zimbraFileUploadMaxSize", 0xA00000L);
            InputStream is = this.getRequestInputStream(sizeLimit);
            try {
                byArray = ByteUtil.getContent(is, this.req.getContentLength(), sizeLimit);
                Object var6_4 = null;
            }
            catch (Throwable throwable) {
                Object var6_5 = null;
                is.close();
                throw throwable;
            }
            is.close();
            return byArray;
        }

        public FileUploadServlet.Upload getUpload() throws ServiceException, IOException {
            return FileUploadServlet.saveUpload((InputStream)this.req.getInputStream(), this.itemPath, this.req.getContentType(), this.authAccount.getId());
        }

        public InputStream getRequestInputStream() throws IOException, ServiceException, UserServletException {
            return this.getRequestInputStream(0L);
        }

        public InputStream getRequestInputStream(long limit) throws IOException, ServiceException, UserServletException {
            String contentType = "application/octet-stream";
            String filename = null;
            InputStream is = null;
            long DEFAULT_MAX_SIZE = 0xA00000L;
            if (limit == 0L) {
                limit = this.req.getParameter("lbfums") != null ? Provisioning.getInstance().getLocalServer().getLongAttr("zimbraFileUploadMaxSize", 0xA00000L) : Provisioning.getInstance().getConfig().getLongAttr("zimbraMtaMaxMessageSize", 0xA00000L);
            }
            if (ServletFileUpload.isMultipartContent((HttpServletRequest)this.req)) {
                ServletFileUpload sfu = new ServletFileUpload();
                try {
                    FileItemIterator iter = sfu.getItemIterator(this.req);
                    while (iter.hasNext()) {
                        FileItemStream fis = iter.next();
                        if (fis.isFormField()) {
                            is = fis.openStream();
                            this.params.put(fis.getFieldName(), new String(ByteUtil.getContent(is, -1), "UTF-8"));
                            is.close();
                            is = null;
                            continue;
                        }
                        contentType = fis.getContentType();
                        filename = fis.getName();
                        is = new UploadInputStream(fis.openStream(), limit);
                        break;
                    }
                }
                catch (Exception e) {
                    throw new UserServletException(415, e.toString());
                }
                if (is == null) {
                    throw new UserServletException(204, "No file content");
                }
            } else {
                ContentType ctype = new ContentType(this.req.getContentType());
                String contentEncoding = this.req.getHeader("Content-Encoding");
                contentType = ctype.getValue();
                filename = ctype.getParameter(UserServlet.QP_NAME);
                if (filename == null || filename.trim().equals("")) {
                    filename = new ContentDisposition(this.req.getHeader("Content-Disposition")).getParameter("filename");
                }
                is = new UploadInputStream(contentEncoding != null && contentEncoding.indexOf("gzip") != -1 ? new GZIPInputStream((InputStream)this.req.getInputStream()) : this.req.getInputStream(), limit);
            }
            if (filename == null || filename.trim().equals("")) {
                filename = "unknown";
            } else {
                this.params.put(UserServlet.UPLOAD_NAME, filename);
            }
            this.params.put(UserServlet.UPLOAD_TYPE, contentType);
            ZimbraLog.mailbox.info("UserServlet received file %s - %d request bytes", filename, this.req.getContentLength());
            return is;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("account(" + this.accountPath + ")\n");
            sb.append("itemPath(" + this.itemPath + ")\n");
            sb.append("foramt(" + this.format + ")\n");
            return sb.toString();
        }

        private static final class UploadInputStream
        extends InputStream {
            private FileItem fi = null;
            private InputStream is;
            private long curSize = 0L;
            private long maxSize;
            private long markSize = 0L;

            UploadInputStream(InputStream is, long maxSize) {
                this.is = is;
                this.maxSize = maxSize;
            }

            UploadInputStream(FileItem fi, long maxSize) throws IOException {
                this(fi.getInputStream(), maxSize);
                this.fi = fi;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void close() throws IOException {
                block3: {
                    try {
                        this.is.close();
                        Object var2_1 = null;
                        if (this.fi == null) break block3;
                    }
                    catch (Throwable throwable) {
                        Object var2_2 = null;
                        if (this.fi != null) {
                            this.fi.delete();
                        }
                        this.fi = null;
                        throw throwable;
                    }
                    this.fi.delete();
                }
                this.fi = null;
            }

            public int available() throws IOException {
                return this.is.available();
            }

            public void mark(int where) {
                this.is.mark(where);
                this.markSize = this.curSize;
            }

            public boolean markSupported() {
                return this.is.markSupported();
            }

            public int read() throws IOException {
                return (int)this.check(this.is.read());
            }

            public int read(byte[] b) throws IOException {
                return (int)this.check(this.is.read(b));
            }

            public int read(byte[] b, int off, int len) throws IOException {
                return (int)this.check(this.is.read(b, off, len));
            }

            public void reset() throws IOException {
                this.is.reset();
                this.curSize = this.markSize;
            }

            public long skip(long n) throws IOException {
                return this.check(this.is.skip(n));
            }

            private long check(long in) throws IOException {
                if (in > 0L) {
                    this.curSize += in;
                    if (this.maxSize > 0L && this.curSize > this.maxSize) {
                        throw new IOException("upload over " + this.maxSize + " byte limit");
                    }
                }
                return in;
            }
        }
    }
}

