/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.SoapProtocol;
import com.zimbra.common.util.Log;
import com.zimbra.common.util.LogFactory;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AuthToken;
import com.zimbra.cs.account.AuthTokenException;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.fb.FreeBusy;
import com.zimbra.cs.fb.FreeBusyQuery;
import com.zimbra.cs.mailbox.ACL;
import com.zimbra.cs.service.AuthProvider;
import com.zimbra.cs.servlet.ZimbraServlet;
import com.zimbra.soap.ZimbraSoapContext;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PublicICalServlet
extends ZimbraServlet {
    private static final long serialVersionUID = -7350146465570984660L;
    private static Log sLog = LogFactory.getLog(PublicICalServlet.class);
    private static final String QP_AUTH_TOKEN = "zauthtoken";
    private static final String QP_ACCOUNT = "acct";
    private static final String QP_START_TIME = "s";
    private static final String QP_END_TIME = "e";

    public final void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        boolean isFreeBusy;
        ZimbraLog.clearContext();
        String pathInfo = req.getPathInfo();
        if (pathInfo == null) {
            resp.sendError(400);
            return;
        }
        boolean isReply = (pathInfo = pathInfo.toLowerCase()) != null && pathInfo.endsWith("reply");
        boolean bl = isFreeBusy = pathInfo != null && pathInfo.endsWith("freebusy.ifb");
        if (isReply) {
            this.doReply(req, resp);
        } else if (isFreeBusy) {
            this.doGetFreeBusy(req, resp);
        }
    }

    public final void doGetFreeBusy(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        String authTokenParam;
        String acctName = req.getParameter(QP_ACCOUNT);
        String startStr = req.getParameter(QP_START_TIME);
        String endStr = req.getParameter(QP_END_TIME);
        resp.setContentType("text/calendar");
        if (PublicICalServlet.checkBlankOrNull(resp, QP_ACCOUNT, acctName)) {
            return;
        }
        long now = new Date().getTime();
        long rangeStart = now - 604800000L;
        long rangeEnd = now + 5356800000L;
        if (startStr != null) {
            rangeStart = Long.parseLong(startStr);
        }
        if (endStr != null) {
            rangeEnd = Long.parseLong(endStr);
        }
        if (rangeEnd < rangeStart) {
            resp.sendError(400, "End time must be after Start time");
            return;
        }
        long days = (rangeEnd - rangeStart) / 86400000L;
        long maxDays = LC.calendar_freebusy_max_days.longValueWithinRange(0L, 36600L);
        if (days > maxDays) {
            resp.sendError(400, "Requested range is too large (max " + maxDays + " days)");
            return;
        }
        String targetAccountId = null;
        try {
            Account targetAccount = Provisioning.getInstance().get(Provisioning.AccountBy.name, acctName);
            if (targetAccount != null) {
                targetAccountId = targetAccount.getId();
            }
        }
        catch (ServiceException e) {
            // empty catch block
        }
        AuthToken at = PublicICalServlet.getAuthTokenFromCookie(req, resp, true);
        if (at == null && (authTokenParam = req.getParameter(QP_AUTH_TOKEN)) != null) {
            try {
                at = AuthProvider.getAuthToken(authTokenParam);
            }
            catch (AuthTokenException e) {
                sLog.warn((Object)("Auth error: " + e.getMessage()), e);
            }
        }
        Account authAccount = null;
        ZimbraSoapContext zsc = null;
        if (at != null) {
            try {
                authAccount = Provisioning.getInstance().get(Provisioning.AccountBy.id, at.getAccountId(), at);
            }
            catch (ServiceException e) {
                sLog.warn((Object)("Auth error: " + e.getMessage()), e);
            }
            try {
                zsc = new ZimbraSoapContext(at, targetAccountId, SoapProtocol.SoapJS, SoapProtocol.SoapJS);
            }
            catch (ServiceException e) {
                sLog.error((Object)"Error initializing request context", e);
                resp.sendError(500, "Error initializing request context");
                return;
            }
        }
        authAccount = ACL.ANONYMOUS_ACCT;
        FreeBusyQuery fbQuery = new FreeBusyQuery(req, zsc, authAccount, rangeStart, rangeEnd, null);
        fbQuery.addEmailAddress(acctName, -1);
        Collection<FreeBusy> result = fbQuery.getResults();
        FreeBusy fb = null;
        fb = result.size() > 0 ? result.iterator().next() : FreeBusy.emptyFreeBusy(acctName, rangeStart, rangeEnd);
        String url = req.getRequestURL() + "?" + req.getQueryString();
        String fbMsg = fb.toVCalendar(FreeBusy.Method.PUBLISH, acctName, null, url);
        resp.getOutputStream().write(fbMsg.getBytes());
    }

    public final void doReply(HttpServletRequest req, HttpServletResponse resp) {
    }

    static boolean checkBlankOrNull(HttpServletResponse resp, String field, String value) throws IOException {
        if (value == null || value.equals("")) {
            resp.sendError(400, field + " required");
            return true;
        }
        return false;
    }

    public void init() throws ServletException {
        String name = this.getServletName();
        sLog.info("Servlet " + name + " starting up");
        super.init();
    }

    public void destroy() {
        String name = this.getServletName();
        sLog.info("Servlet " + name + " shutting down");
        super.destroy();
    }
}

