/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AccountServiceException;
import com.zimbra.cs.account.AuthToken;
import com.zimbra.cs.account.AuthTokenException;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Server;
import com.zimbra.cs.httpclient.URLUtil;
import com.zimbra.cs.service.AuthProvider;
import com.zimbra.cs.servlet.ZimbraServlet;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PreAuthServlet
extends ZimbraServlet {
    public static final String PARAM_PREAUTH = "preauth";
    public static final String PARAM_AUTHTOKEN = "authtoken";
    public static final String PARAM_ACCOUNT = "account";
    public static final String PARAM_ADMIN = "admin";
    public static final String PARAM_ISREDIRECT = "isredirect";
    public static final String PARAM_BY = "by";
    public static final String PARAM_REDIRECT_URL = "redirectURL";
    public static final String PARAM_TIMESTAMP = "timestamp";
    public static final String PARAM_EXPIRES = "expires";
    private static final HashSet<String> sPreAuthParams = new HashSet();
    private static final String DEFAULT_MAIL_URL = "/zimbra";
    private static final String DEFAULT_ADMIN_URL = "/zimbraAdmin";

    public void init() throws ServletException {
        String name = this.getServletName();
        ZimbraLog.account.info("Servlet " + name + " starting up");
        super.init();
    }

    public void destroy() {
        String name = this.getServletName();
        ZimbraLog.account.info("Servlet " + name + " shutting down");
        super.destroy();
    }

    private String getRequiredParam(HttpServletRequest req, HttpServletResponse resp, String paramName) throws ServiceException {
        String param = req.getParameter(paramName);
        if (param == null) {
            throw ServiceException.INVALID_REQUEST("missing required param: " + paramName, null);
        }
        return param;
    }

    private String getOptionalParam(HttpServletRequest req, String paramName, String def) {
        String param = req.getParameter(paramName);
        if (param == null) {
            return def;
        }
        return param;
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        ZimbraLog.clearContext();
        try {
            Provisioning prov = Provisioning.getInstance();
            Server server = prov.getLocalServer();
            String referMode = server.getAttr("zimbraMailReferMode", "wronghost");
            String isRedirect = this.getOptionalParam(req, PARAM_ISREDIRECT, "0");
            String rawAuthToken = this.getOptionalParam(req, PARAM_AUTHTOKEN, null);
            AuthToken authToken = null;
            if (rawAuthToken != null && (authToken = AuthProvider.getAuthToken(rawAuthToken)) == null) {
                throw new AuthTokenException("unable to get auth token from authtoken");
            }
            if (isRedirect.equals("1") && rawAuthToken != null) {
                this.setCookieAndRedirect(req, resp, authToken);
            } else if (rawAuthToken != null) {
                boolean isAdmin = authToken != null && AuthToken.isAnyAdmin(authToken);
                Account acct = prov.get(Provisioning.AccountBy.id, authToken.getAccountId(), authToken);
                if (isAdmin || !this.needReferral(acct, referMode)) {
                    this.setCookieAndRedirect(req, resp, authToken);
                } else {
                    this.redirectToCorrectServer(req, resp, acct, rawAuthToken);
                }
            } else {
                String preAuth = this.getRequiredParam(req, resp, PARAM_PREAUTH);
                String account = this.getRequiredParam(req, resp, PARAM_ACCOUNT);
                String accountBy = this.getOptionalParam(req, PARAM_BY, Provisioning.AccountBy.name.name());
                boolean admin = this.getOptionalParam(req, PARAM_ADMIN, "0").equals("1") && this.isAdminRequest(req);
                long timestamp = Long.parseLong(this.getRequiredParam(req, resp, PARAM_TIMESTAMP));
                long expires = Long.parseLong(this.getRequiredParam(req, resp, PARAM_EXPIRES));
                Account acct = null;
                acct = prov.get(Provisioning.AccountBy.fromString(accountBy), account, authToken);
                if (acct == null) {
                    throw AccountServiceException.AuthFailedServiceException.AUTH_FAILED(account, account, "account not found");
                }
                if (admin) {
                    boolean ok;
                    boolean isDomainAdminAccount = acct.getBooleanAttr("zimbraIsDomainAdminAccount", false);
                    boolean isAdminAccount = acct.getBooleanAttr("zimbraIsAdminAccount", false);
                    boolean isDelegatedAdminAccount = acct.getBooleanAttr("zimbraIsDelegatedAdminAccount", false);
                    boolean bl = ok = isDomainAdminAccount || isAdminAccount || isDelegatedAdminAccount;
                    if (!ok) {
                        throw ServiceException.PERM_DENIED("not an admin account");
                    }
                }
                if (admin || !this.needReferral(acct, referMode)) {
                    HashMap<String, Object> authCtxt = new HashMap<String, Object>();
                    authCtxt.put("ocip", ZimbraServlet.getOrigIp(req));
                    authCtxt.put("anp", account);
                    authCtxt.put("ua", req.getHeader("User-Agent"));
                    prov.preAuthAccount(acct, account, accountBy, timestamp, expires, preAuth, admin, authCtxt);
                    AuthToken at = admin ? (expires == 0L ? AuthProvider.getAuthToken(acct, admin) : AuthProvider.getAuthToken(acct, expires, admin, null)) : (expires == 0L ? AuthProvider.getAuthToken(acct) : AuthProvider.getAuthToken(acct, expires));
                    this.setCookieAndRedirect(req, resp, at);
                } else {
                    this.redirectToCorrectServer(req, resp, acct);
                }
            }
        }
        catch (ServiceException e) {
            resp.sendError(400, e.getMessage());
        }
        catch (AuthTokenException e) {
            resp.sendError(400, e.getMessage());
        }
    }

    private boolean needReferral(Account acct, String referMode) throws ServiceException {
        return "always".equals(referMode) || "wronghost".equals(referMode) && !Provisioning.onLocalServer(acct);
    }

    private void addQueryParams(HttpServletRequest req, StringBuilder sb, boolean first, boolean nonPreAuthParamsOnly) {
        Enumeration names = req.getParameterNames();
        while (names.hasMoreElements()) {
            String[] values;
            String name = (String)names.nextElement();
            if (nonPreAuthParamsOnly && sPreAuthParams.contains(name) || (values = req.getParameterValues(name)) == null) continue;
            for (String value : values) {
                if (first) {
                    first = false;
                } else {
                    sb.append('&');
                }
                try {
                    sb.append(name).append("=").append(URLEncoder.encode(value, "utf-8"));
                }
                catch (UnsupportedEncodingException e) {
                    sb.append(name).append("=").append(URLEncoder.encode(value));
                }
            }
        }
    }

    private void redirectToCorrectServer(HttpServletRequest req, HttpServletResponse resp, Account acct, String token) throws ServiceException, IOException {
        StringBuilder sb = new StringBuilder();
        Provisioning prov = Provisioning.getInstance();
        sb.append(URLUtil.getServiceURL(prov.getServer(acct), req.getRequestURI(), true));
        sb.append('?').append(PARAM_ISREDIRECT).append('=').append('1');
        sb.append('&').append(PARAM_AUTHTOKEN).append('=').append(token);
        this.addQueryParams(req, sb, false, true);
        resp.sendRedirect(sb.toString());
    }

    private void redirectToCorrectServer(HttpServletRequest req, HttpServletResponse resp, Account acct) throws ServiceException, IOException {
        StringBuilder sb = new StringBuilder();
        Provisioning prov = Provisioning.getInstance();
        sb.append(URLUtil.getServiceURL(prov.getServer(acct), req.getRequestURI(), true));
        sb.append('?').append(PARAM_ISREDIRECT).append('=').append('1');
        this.addQueryParams(req, sb, false, false);
        resp.sendRedirect(sb.toString());
    }

    private void setCookieAndRedirect(HttpServletRequest req, HttpServletResponse resp, AuthToken authToken) throws IOException, ServiceException {
        boolean isAdmin = AuthToken.isAnyAdmin(authToken);
        boolean secureCookie = req.getScheme().equals("https");
        authToken.encode(resp, isAdmin, secureCookie);
        String redirectURL = this.getOptionalParam(req, PARAM_REDIRECT_URL, null);
        if (redirectURL != null) {
            resp.sendRedirect(redirectURL);
        } else {
            String redirectUrl;
            StringBuilder sb = new StringBuilder();
            this.addQueryParams(req, sb, true, true);
            Provisioning prov = Provisioning.getInstance();
            Server server = prov.getLocalServer();
            redirectUrl = isAdmin ? server.getAttr("zimbraAdminURL", DEFAULT_ADMIN_URL) : ((redirectUrl = server.getAttr("zimbraMailURL", DEFAULT_MAIL_URL)).charAt(redirectUrl.length() - 1) == '/' ? redirectUrl + "mail" : redirectUrl + "/mail");
            if (sb.length() > 0) {
                resp.sendRedirect(redirectUrl + "?" + sb.toString());
            } else {
                resp.sendRedirect(redirectUrl);
            }
        }
    }

    static {
        sPreAuthParams.add(PARAM_PREAUTH);
        sPreAuthParams.add(PARAM_AUTHTOKEN);
        sPreAuthParams.add(PARAM_ACCOUNT);
        sPreAuthParams.add(PARAM_ADMIN);
        sPreAuthParams.add(PARAM_ISREDIRECT);
        sPreAuthParams.add(PARAM_BY);
        sPreAuthParams.add(PARAM_TIMESTAMP);
        sPreAuthParams.add(PARAM_EXPIRES);
    }
}

