/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.mime.ContentDisposition;
import com.zimbra.common.mime.ContentType;
import com.zimbra.common.mime.MimeDetect;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.util.ByteUtil;
import com.zimbra.common.util.FileUtil;
import com.zimbra.common.util.Log;
import com.zimbra.common.util.LogFactory;
import com.zimbra.common.util.StringUtil;
import com.zimbra.common.util.ZimbraHttpConnectionManager;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AuthToken;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Server;
import com.zimbra.cs.account.ldap.LdapUtil;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.service.AuthProvider;
import com.zimbra.cs.servlet.ZimbraServlet;
import com.zimbra.cs.util.AccountUtil;
import com.zimbra.cs.util.Zimbra;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TimerTask;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.methods.GetMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUploadServlet
extends ZimbraServlet {
    private static final long serialVersionUID = -3156986245375108467L;
    protected static final String PARAM_LIMIT_BY_FILE_UPLOAD_MAX_SIZE = "lbfums";
    public static final String UPLOAD_DELIMITER = ",";
    private static final String UPLOAD_PART_DELIMITER = ":";
    private static String sUploadDir;
    static HashMap<String, Upload> mPending;
    static Log mLog;
    static final long DEFAULT_MAX_SIZE = 0xA00000L;
    static final long UPLOAD_TIMEOUT_MSEC = 900000L;
    private static final long REAPER_INTERVAL_MSEC = 60000L;

    static String getUploadServerId(String uploadId) throws ServiceException {
        String[] parts = null;
        if (uploadId == null || (parts = uploadId.split(UPLOAD_PART_DELIMITER)).length != 2) {
            throw ServiceException.INVALID_REQUEST("invalid upload ID: " + uploadId, null);
        }
        return parts[0];
    }

    static boolean isLocalUpload(String uploadId) throws ServiceException {
        String serverId = FileUploadServlet.getUploadServerId(uploadId);
        return Provisioning.getInstance().getLocalServer().getId().equals(serverId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Upload fetchUpload(String accountId, String uploadId, AuthToken authtoken) throws ServiceException {
        String context = "accountId=" + accountId + ", uploadId=" + uploadId;
        if (accountId == null || uploadId == null) {
            throw ServiceException.FAILURE("fetchUploads(): missing parameter: " + context, null);
        }
        if (!FileUploadServlet.isLocalUpload(uploadId)) {
            return FileUploadServlet.fetchRemoteUpload(accountId, uploadId, authtoken);
        }
        HashMap<String, Upload> hashMap = mPending;
        synchronized (hashMap) {
            Upload up = mPending.get(uploadId);
            if (up == null) {
                mLog.warn("upload not found: " + context);
                throw MailServiceException.NO_SUCH_UPLOAD(uploadId);
            }
            if (!accountId.equals(up.accountId)) {
                mLog.warn("mismatched accountId for upload: " + up + "; expected: " + context);
                throw MailServiceException.NO_SUCH_UPLOAD(uploadId);
            }
            up.time = System.currentTimeMillis();
            return up;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Upload fetchRemoteUpload(String accountId, String uploadId, AuthToken authtoken) throws ServiceException {
        Upload upload;
        GetMethod get;
        block9: {
            Upload upload2;
            block8: {
                Server server = Provisioning.getInstance().get(Provisioning.ServerBy.id, FileUploadServlet.getUploadServerId(uploadId));
                String url = AccountUtil.getBaseUri(server);
                if (url == null) {
                    return null;
                }
                String hostname = server.getAttr("zimbraServiceHostname");
                url = url + "/service/content/proxy?aid=" + uploadId + '&' + "expunge" + "=true";
                HttpClient client = ZimbraHttpConnectionManager.getInternalHttpConnMgr().newHttpClient();
                get = new GetMethod(url);
                authtoken.encode(client, get, false, hostname);
                try {
                    try {
                        int statusCode = client.executeMethod(get);
                        if (statusCode != 200) {
                            upload2 = null;
                            Object var15_13 = null;
                            break block8;
                        }
                        Header ctHeader = get.getResponseHeader("Content-Type");
                        String contentType = ctHeader == null ? "text/plain" : ctHeader.getValue();
                        Header cdispHeader = get.getResponseHeader("Content-Disposition");
                        String filename = cdispHeader == null ? "unknown" : new ContentDisposition(cdispHeader.getValue()).getParameter("filename");
                        upload = FileUploadServlet.saveUpload(get.getResponseBodyAsStream(), filename, contentType, accountId);
                        break block9;
                    }
                    catch (HttpException e) {
                        throw ServiceException.PROXY_ERROR(e, url);
                    }
                    catch (IOException e) {
                        throw ServiceException.RESOURCE_UNREACHABLE("can't fetch remote upload", e, new ServiceException.InternalArgument("url", url, ServiceException.Argument.Type.STR));
                    }
                }
                catch (Throwable throwable) {
                    Object var15_15 = null;
                    get.releaseConnection();
                    throw throwable;
                }
            }
            get.releaseConnection();
            return upload2;
        }
        Object var15_14 = null;
        get.releaseConnection();
        return upload;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Upload saveUpload(InputStream is, String filename, String contentType, String accountId) throws ServiceException, IOException {
        Object object;
        block6: {
            FileItem fi = null;
            boolean success = false;
            try {
                ServletFileUpload upload = FileUploadServlet.getUploader(false);
                fi = upload.getFileItemFactory().createItem("upload", contentType, false, filename);
                long size = ByteUtil.copy(is, true, fi.getOutputStream(), true, upload.getSizeMax() * 3L);
                if (size > upload.getSizeMax()) {
                    throw MailServiceException.UPLOAD_REJECTED(filename, "upload too large");
                }
                Upload up = new Upload(accountId, fi);
                mLog.info("Received file: name=%s, size=%d, id=%s", up.getName(), up.getSize(), up.getId());
                object = mPending;
                synchronized (object) {
                    mPending.put(up.uuid, up);
                }
                success = true;
                object = up;
                Object var13_11 = null;
                if (success || fi == null) break block6;
            }
            catch (Throwable throwable) {
                block7: {
                    Object var13_12 = null;
                    if (success || fi == null) break block7;
                    fi.delete();
                }
                throw throwable;
            }
            fi.delete();
        }
        return object;
    }

    public static void deleteUploads(Collection<Upload> uploads) {
        if (uploads != null && !uploads.isEmpty()) {
            for (Upload up : uploads) {
                FileUploadServlet.deleteUpload(up);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteUpload(Upload upload) {
        if (upload == null) {
            return;
        }
        Upload up = null;
        HashMap<String, Upload> hashMap = mPending;
        synchronized (hashMap) {
            up = mPending.remove(upload.uuid);
        }
        if (up == upload) {
            up.purge();
        }
    }

    private static String getUploadDir() {
        if (sUploadDir == null) {
            sUploadDir = LC.zimbra_tmp_directory.value() + "/upload";
        }
        return sUploadDir;
    }

    private static void cleanupLeftoverTempFiles() {
        File[] files = new File(FileUploadServlet.getUploadDir()).listFiles(new TempFileFilter());
        if (files == null || files.length < 1) {
            return;
        }
        mLog.info("deleting " + files.length + " temporary upload files left over from last time");
        for (int i = 0; i < files.length; ++i) {
            String path = files[i].getAbsolutePath();
            if (files[i].delete()) {
                mLog.info("deleted leftover upload file " + path);
                continue;
            }
            mLog.error("unable to delete leftover upload file " + path);
        }
    }

    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        AuthToken at;
        ZimbraLog.clearContext();
        this.addRemoteIpToLoggingContext(req);
        String fmt = req.getParameter("fmt");
        ZimbraLog.addUserAgentToContext(req.getHeader("User-Agent"));
        boolean isAdminRequest = false;
        try {
            isAdminRequest = this.isAdminRequest(req);
        }
        catch (ServiceException e) {
            FileUploadServlet.drainRequestStream(req);
            throw new ServletException((Throwable)e);
        }
        AuthToken authToken = at = isAdminRequest ? FileUploadServlet.getAdminAuthTokenFromCookie(req, resp, false) : FileUploadServlet.getAuthTokenFromCookie(req, resp, false);
        if (at == null) {
            FileUploadServlet.drainRequestStream(req);
            FileUploadServlet.sendResponse(resp, 401, fmt, null, null, null);
            return;
        }
        try {
            boolean limitByFileUploadMaxSize;
            Mailbox mbox;
            Provisioning prov;
            Account acct;
            if (!isAdminRequest && Provisioning.onLocalServer(acct = AuthProvider.validateAuthToken(prov = Provisioning.getInstance(), at, true)) && (mbox = MailboxManager.getInstance().getMailboxByAccount(acct, false)) != null) {
                ZimbraLog.addMboxToContext(mbox.getId());
            }
            boolean bl = limitByFileUploadMaxSize = req.getParameter(PARAM_LIMIT_BY_FILE_UPLOAD_MAX_SIZE) != null;
            if (ServletFileUpload.isMultipartContent((HttpServletRequest)req)) {
                this.handleMultipartUpload(req, resp, fmt, at.getAccountId(), limitByFileUploadMaxSize);
            } else {
                this.handlePlainUpload(req, resp, fmt, at.getAccountId(), limitByFileUploadMaxSize);
            }
        }
        catch (ServiceException e) {
            mLog.info((Object)"File upload failed", e);
            FileUploadServlet.drainRequestStream(req);
            this.returnError(resp, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMultipartUpload(HttpServletRequest req, HttpServletResponse resp, String fmt, String accountId, boolean limitByFileUploadMaxSize) throws IOException, ServiceException {
        List items = null;
        String reqId = null;
        ServletFileUpload upload = FileUploadServlet.getUploader(limitByFileUploadMaxSize);
        try {
            items = upload.parseRequest(req);
        }
        catch (FileUploadBase.SizeLimitExceededException e) {
            mLog.info("Exceeded maximum upload size of " + upload.getSizeMax() + " bytes: " + (Object)((Object)e));
            FileUploadServlet.drainRequestStream(req);
            FileUploadServlet.sendResponse(resp, 413, fmt, reqId, null, items);
            return;
        }
        catch (FileUploadBase.InvalidContentTypeException e) {
            mLog.info((Object)"File upload failed", e);
            FileUploadServlet.drainRequestStream(req);
            FileUploadServlet.sendResponse(resp, 415, fmt, reqId, null, items);
            return;
        }
        catch (FileUploadException e) {
            mLog.info((Object)"File upload failed", e);
            FileUploadServlet.drainRequestStream(req);
            FileUploadServlet.sendResponse(resp, 500, fmt, reqId, null, items);
            return;
        }
        String lastName = null;
        String charset = "utf-8";
        HashMap<FileItem, String> filenames = new HashMap<FileItem, String>();
        if (items != null) {
            Iterator it = items.iterator();
            while (it.hasNext()) {
                FileItem fi = (FileItem)it.next();
                if (fi == null) continue;
                if (fi.isFormField()) {
                    if (fi.getFieldName().equals("requestId")) {
                        reqId = fi.getString();
                    }
                    if (fi.getFieldName().equals("_charset_") && !fi.getString().equals("")) {
                        charset = fi.getString();
                    }
                    if (fi.getFieldName().startsWith("filename")) {
                        lastName = fi.getString(charset);
                    }
                    it.remove();
                    continue;
                }
                if (fi.getName() == null || fi.getName().trim().equals("")) {
                    it.remove();
                    continue;
                }
                filenames.put(fi, lastName);
                lastName = null;
            }
        }
        if (items == null || items.isEmpty()) {
            FileUploadServlet.sendResponse(resp, 204, fmt, reqId, null, items);
            return;
        }
        ArrayList<Upload> uploads = new ArrayList<Upload>(items.size());
        for (FileItem fi : items) {
            String name = (String)filenames.get(fi);
            if (name == null || name.trim().equals("")) {
                name = fi.getName();
            }
            Upload up = new Upload(accountId, fi, name);
            ZimbraLog.mailbox.info("FileUploadServlet received %s", up);
            HashMap<String, Upload> hashMap = mPending;
            synchronized (hashMap) {
                mPending.put(up.uuid, up);
            }
            uploads.add(up);
        }
        FileUploadServlet.sendResponse(resp, 200, fmt, reqId, uploads, items);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePlainUpload(HttpServletRequest req, HttpServletResponse resp, String fmt, String accountId, boolean limitByFileUploadMaxSize) throws IOException, ServiceException {
        ContentType ctype = new ContentType(req.getContentType());
        String contentType = ctype.getValue();
        String filename = ctype.getParameter("name");
        if (filename == null) {
            filename = new ContentDisposition(req.getHeader("Content-Disposition")).getParameter("filename");
        }
        if (filename == null || filename.trim().equals("")) {
            mLog.info("Rejecting upload with no name.");
            FileUploadServlet.drainRequestStream(req);
            FileUploadServlet.sendResponse(resp, 204, fmt, null, null, null);
            return;
        }
        ServletFileUpload upload = FileUploadServlet.getUploader(limitByFileUploadMaxSize);
        FileItem fi = upload.getFileItemFactory().createItem("upload", contentType, false, filename);
        try {
            long size = ByteUtil.copy((InputStream)req.getInputStream(), false, fi.getOutputStream(), true, upload.getSizeMax() * 3L);
            if (size > upload.getSizeMax()) {
                fi.delete();
                mLog.info("Exceeded maximum upload size of " + upload.getSizeMax() + " bytes: " + accountId);
                FileUploadServlet.drainRequestStream(req);
                FileUploadServlet.sendResponse(resp, 413, fmt, null, null, null);
                return;
            }
        }
        catch (IOException ioe) {
            fi.delete();
            FileUploadServlet.drainRequestStream(req);
            FileUploadServlet.sendResponse(resp, 500, fmt, null, null, null);
            return;
        }
        ArrayList<FileItem> items = new ArrayList<FileItem>(1);
        items.add(fi);
        Upload up = new Upload(accountId, fi, filename);
        ZimbraLog.mailbox.info("FileUploadServlet received " + up);
        HashMap<String, Upload> hashMap = mPending;
        synchronized (hashMap) {
            mPending.put(up.uuid, up);
        }
        FileUploadServlet.sendResponse(resp, 200, fmt, null, Arrays.asList(up), items);
    }

    public static void sendResponse(HttpServletResponse resp, int status, String fmt, String reqId, List<Upload> uploads, List<FileItem> items) throws IOException {
        boolean raw = false;
        boolean extended = false;
        if (fmt != null && !fmt.trim().equals("")) {
            for (String foption : fmt.toLowerCase().split(UPLOAD_DELIMITER)) {
                raw |= "raw".equals(foption);
                extended |= "extended".equals(foption);
            }
        }
        StringBuffer results = new StringBuffer();
        results.append(status).append(",'").append(reqId != null ? StringUtil.jsEncode(reqId) : "null").append('\'');
        if (status == 200) {
            boolean first = true;
            if (extended) {
                results.append(",[");
                for (Upload up : uploads) {
                    Element.JSONElement elt = new Element.JSONElement("ignored");
                    elt.addAttribute("aid", up.uuid);
                    elt.addAttribute("ct", up.getContentType());
                    elt.addAttribute("filename", up.name);
                    elt.addAttribute("s", up.getSize());
                    results.append(first ? "" : UPLOAD_DELIMITER).append(elt.toString());
                    first = false;
                }
                results.append(']');
            } else {
                results.append(",'");
                for (Upload up : uploads) {
                    results.append(first ? "" : UPLOAD_DELIMITER).append(up.uuid);
                    first = false;
                }
                results.append('\'');
            }
        }
        resp.setContentType("text/html; charset=utf-8");
        PrintWriter out = resp.getWriter();
        if (raw) {
            out.println(results);
        } else {
            out.println("<html><head><script language='javascript'>\nfunction doit() { window.parent._uploadManager.loaded(" + results + "); }\n</script>" + "</head><body onload='doit()'></body></html>\n");
        }
        out.close();
        if (status != 200 && items != null && items.size() > 0) {
            for (FileItem fi : items) {
                fi.delete();
            }
        }
    }

    private static void drainRequestStream(HttpServletRequest req) {
        try {
            ServletInputStream in = req.getInputStream();
            byte[] buf = new byte[1024];
            int numRead = 0;
            int totalRead = 0;
            mLog.debug("Draining request input stream");
            while ((numRead = in.read(buf)) >= 0) {
                totalRead += numRead;
            }
            mLog.debug("Drained %d bytes", totalRead);
        }
        catch (IOException e) {
            mLog.info("Ignoring error that occurred while reading the end of the client request: " + e);
        }
    }

    private static ServletFileUpload getUploader(boolean limitByFileUploadMaxSize) {
        long maxSize = 0xA00000L;
        DiskFileItemFactory dfif = new DiskFileItemFactory();
        try {
            maxSize = limitByFileUploadMaxSize ? Provisioning.getInstance().getLocalServer().getLongAttr("zimbraFileUploadMaxSize", 0xA00000L) : Provisioning.getInstance().getConfig().getLongAttr("zimbraMtaMaxMessageSize", 0xA00000L);
        }
        catch (ServiceException e) {
            mLog.error((Object)("Unable to read " + (limitByFileUploadMaxSize ? "zimbraFileUploadMaxSize" : "zimbraMtaMaxMessageSize") + " attribute"), e);
        }
        dfif.setSizeThreshold(32768);
        dfif.setRepository(new File(FileUploadServlet.getUploadDir()));
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)dfif);
        upload.setSizeMax(maxSize);
        return upload;
    }

    @Override
    public void init() throws ServletException {
        String name = this.getServletName();
        mLog.info("Servlet " + name + " starting up");
        super.init();
        File tempDir = new File(FileUploadServlet.getUploadDir());
        if (!tempDir.exists() && !tempDir.mkdirs()) {
            String msg = "Unable to create temporary upload directory " + tempDir;
            mLog.error(msg);
            throw new ServletException(msg);
        }
        FileUploadServlet.cleanupLeftoverTempFiles();
        Zimbra.sTimer.schedule((TimerTask)new MapReaperTask(), 60000L, 60000L);
    }

    public void destroy() {
        String name = this.getServletName();
        mLog.info("Servlet " + name + " shutting down");
        super.destroy();
    }

    static {
        mPending = new HashMap(100);
        mLog = LogFactory.getLog(FileUploadServlet.class);
    }

    private final class MapReaperTask
    extends TimerTask {
        MapReaperTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                int sizeAfter;
                int sizeBefore;
                ArrayList<Upload> reaped = new ArrayList<Upload>();
                HashMap<String, Upload> hashMap = mPending;
                synchronized (hashMap) {
                    sizeBefore = mPending.size();
                    long cutoffTime = System.currentTimeMillis() - 900000L;
                    Iterator<Upload> it = mPending.values().iterator();
                    while (it.hasNext()) {
                        Upload up = it.next();
                        if (up.accessedAfter(cutoffTime)) continue;
                        mLog.debug("Purging cached upload: " + up);
                        it.remove();
                        reaped.add(up);
                        assert (mPending.get(up.uuid) == null);
                    }
                    sizeAfter = mPending.size();
                }
                if (mLog.isInfoEnabled()) {
                    int removed = sizeBefore - sizeAfter;
                    if (removed > 0) {
                        mLog.info("Removed " + removed + " expired file uploads; " + sizeAfter + " pending file uploads");
                    } else if (sizeAfter > 0) {
                        mLog.info(sizeAfter + " pending file uploads");
                    }
                }
                for (Upload up : reaped) {
                    up.purge();
                }
            }
            catch (Throwable e) {
                if (e instanceof OutOfMemoryError) {
                    Zimbra.halt("Caught out of memory error", e);
                }
                ZimbraLog.system.warn((Object)"Caught exception in FileUploadServlet timer", e);
            }
        }
    }

    private static class TempFileFilter
    implements FileFilter {
        private long mNow = System.currentTimeMillis();

        TempFileFilter() {
        }

        public boolean accept(File pathname) {
            if (pathname == null) {
                return false;
            }
            String name = pathname.getName();
            return name.startsWith("upload_") && name.endsWith(".tmp") && this.mNow - pathname.lastModified() > 900000L;
        }
    }

    public static final class Upload {
        final String accountId;
        String contentType;
        final String uuid;
        final String name;
        final FileItem file;
        long time;

        Upload(String acctId, FileItem attachment) throws ServiceException {
            this(acctId, attachment, attachment.getName());
        }

        Upload(String acctId, FileItem attachment, String filename) throws ServiceException {
            String localServer = Provisioning.getInstance().getLocalServer().getId();
            this.accountId = acctId;
            this.time = System.currentTimeMillis();
            this.uuid = localServer + FileUploadServlet.UPLOAD_PART_DELIMITER + LdapUtil.generateUUID();
            this.name = FileUtil.trimFilename(filename);
            this.file = attachment;
            if (this.file == null) {
                this.contentType = "text/plain";
            } else {
                this.contentType = MimeDetect.getMimeDetect().detect(this.name);
                if (this.contentType == null && this.file.getContentType() != null && this.file.getContentType().equals("text/xml")) {
                    this.contentType = this.file.getContentType();
                }
                if (this.contentType == null) {
                    try {
                        this.contentType = MimeDetect.getMimeDetect().detect(this.file.getInputStream());
                    }
                    catch (Exception e) {
                        this.contentType = null;
                    }
                }
                if (this.contentType == null || this.contentType.equals("application/octet-stream")) {
                    this.contentType = this.file.getContentType();
                }
                if (this.contentType == null) {
                    this.contentType = this.file.getContentType();
                }
                if (this.contentType == null) {
                    this.contentType = "application/octet-stream";
                }
            }
        }

        public String getName() {
            return this.name;
        }

        public String getId() {
            return this.uuid;
        }

        public String getContentType() {
            return this.contentType;
        }

        public long getSize() {
            return this.file == null ? 0L : this.file.getSize();
        }

        public InputStream getInputStream() throws IOException {
            return this.file == null ? new ByteArrayInputStream(new byte[0]) : this.file.getInputStream();
        }

        boolean accessedAfter(long checkpoint) {
            return this.time > checkpoint;
        }

        void purge() {
            if (this.file != null) {
                this.file.delete();
            }
        }

        public String toString() {
            return "Upload: { accountId=" + this.accountId + ", time=" + new Date(this.time) + ", uploadId=" + this.uuid + ", " + (this.file == null ? "no file" : this.name) + "}";
        }
    }
}

