/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service;

import com.zimbra.common.mime.ContentType;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.util.DateUtil;
import com.zimbra.common.util.FileUtil;
import com.zimbra.common.util.ZimbraHttpConnectionManager;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.ldap.LdapUtil;
import com.zimbra.cs.httpclient.HttpProxyUtil;
import com.zimbra.cs.mailbox.Folder;
import com.zimbra.cs.mailbox.calendar.Invite;
import com.zimbra.cs.mailbox.calendar.ZCalendar;
import com.zimbra.cs.mime.Mime;
import com.zimbra.cs.mime.ParsedMessage;
import com.zimbra.cs.util.JMSession;
import com.zimbra.cs.util.Zimbra;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.HttpURL;
import org.apache.commons.httpclient.HttpsURL;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.params.HttpMethodParams;
import org.cyberneko.html.parsers.SAXParser;
import org.dom4j.DocumentException;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeedManager {
    public static final int MAX_REDIRECTS = 3;
    public static final String HTTP_USER_AGENT = "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1; .NET CLR 1.1.4322) Zimbra/2.0";
    public static final String HTTP_ACCEPT = "image/gif, image/x-xbitmap, image/jpeg, image/pjpeg, application/x-shockwave-flash, application/vnd.ms-powerpoint, application/vnd.ms-excel, application/msword, */*";
    private static final String HTML_HEADER = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">\n<HTML><HEAD><META HTTP-EQUIV=\"Content-Type\" CONTENT=\"text/html; charset=utf-8\"></HEAD><BODY>";
    private static final String HTML_FOOTER = "</BODY></HTML>";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SubscriptionData<?> retrieveRemoteDatasource(Account acct, String url, Folder.SyncData fsd) throws ServiceException {
        SubscriptionData<Invite> subscriptionData;
        HttpMethodBase get;
        block33: {
            Object locationHeader;
            block32: {
                SubscriptionData subscriptionData2;
                block30: {
                    HttpClient client = ZimbraHttpConnectionManager.getExternalHttpConnMgr().newHttpClient();
                    HttpProxyUtil.configureProxy(client);
                    String originalURL = url;
                    HttpMethodParams params = new HttpMethodParams();
                    params.setParameter("http.protocol.content-charset", "utf-8");
                    params.setSoTimeout(60000);
                    get = null;
                    BufferedInputStream content = null;
                    try {
                        try {
                            int redirects;
                            String expectedCharset;
                            block34: {
                                block31: {
                                    expectedCharset = "utf-8";
                                    redirects = 0;
                                    do {
                                        String user;
                                        if (url == null || url.equals("")) {
                                            subscriptionData2 = new SubscriptionData();
                                            Object var16_21 = null;
                                            if (get == null) return subscriptionData2;
                                            break block30;
                                        }
                                        String lcurl = url.toLowerCase();
                                        if (lcurl.startsWith("webcal:")) {
                                            url = "http:" + url.substring(7);
                                        } else if (lcurl.startsWith("feed:")) {
                                            url = "http:" + url.substring(5);
                                        } else if (!lcurl.startsWith("http:") && !lcurl.startsWith("https:")) {
                                            throw ServiceException.INVALID_REQUEST("url must begin with http: or https:", null);
                                        }
                                        if (url.indexOf(64) != -1) {
                                            HttpURL httpurl;
                                            HttpURL httpURL = httpurl = lcurl.startsWith("https:") ? new HttpsURL(url) : new HttpURL(url);
                                            if (httpurl.getUser() != null) {
                                                user = httpurl.getUser();
                                                if (user.indexOf(37) != -1) {
                                                    try {
                                                        user = URLDecoder.decode(httpurl.getUser());
                                                    }
                                                    catch (OutOfMemoryError e) {
                                                        Zimbra.halt("out of memory", e);
                                                    }
                                                    catch (Throwable t) {
                                                        // empty catch block
                                                    }
                                                }
                                                UsernamePasswordCredentials creds = new UsernamePasswordCredentials(user, httpurl.getPassword());
                                                client.getParams().setAuthenticationPreemptive(true);
                                                client.getState().setCredentials(AuthScope.ANY, creds);
                                            }
                                        }
                                        try {
                                            get = new GetMethod(url);
                                        }
                                        catch (OutOfMemoryError e) {
                                            Zimbra.halt("out of memory", e);
                                            user = null;
                                            Object var16_22 = null;
                                            if (get == null) return user;
                                            get.releaseConnection();
                                            return user;
                                        }
                                        catch (Throwable t) {
                                            throw ServiceException.INVALID_REQUEST("invalid url for feed: " + url, t);
                                        }
                                        get.setParams(params);
                                        get.setFollowRedirects(true);
                                        get.setDoAuthentication(true);
                                        get.addRequestHeader("User-Agent", HTTP_USER_AGENT);
                                        get.addRequestHeader("Accept", HTTP_ACCEPT);
                                        client.executeMethod(get);
                                        locationHeader = get.getResponseHeader("location");
                                        if (locationHeader == null) break block31;
                                        url = ((NameValuePair)locationHeader).getValue();
                                        get.releaseConnection();
                                    } while (++redirects <= 3);
                                    break block34;
                                }
                                if (get.getStatusCode() != 200) {
                                    throw ServiceException.RESOURCE_UNREACHABLE(get.getStatusLine().toString(), null, new ServiceException.Argument[0]);
                                }
                                content = new BufferedInputStream(get.getResponseBodyAsStream());
                                expectedCharset = get.getResponseCharSet();
                            }
                            if (redirects > 3) {
                                throw ServiceException.TOO_MANY_PROXIES(originalURL);
                            }
                            StringBuilder charset = new StringBuilder(expectedCharset);
                            switch (FeedManager.getLeadingChar(content, charset)) {
                                case -1: {
                                    throw ServiceException.PARSE_ERROR("empty body in response when fetching remote subscription", null);
                                }
                                case 60: {
                                    locationHeader = FeedManager.parseRssFeed(Element.parseXML(content), fsd);
                                    break block32;
                                }
                                case 66: 
                                case 98: {
                                    List<ZCalendar.ZVCalendar> icals = ZCalendar.ZCalendarBuilder.buildMulti(content, charset.toString());
                                    List<Invite> invites = Invite.createFromCalendar(acct, null, icals, true, true, null);
                                    for (Invite inv : invites) {
                                        if (inv.getUid() != null) continue;
                                        inv.setUid(LdapUtil.generateUUID());
                                    }
                                    subscriptionData = new SubscriptionData<Invite>(invites);
                                    break block33;
                                }
                                default: {
                                    throw ServiceException.PARSE_ERROR("unrecognized remote content", null);
                                }
                            }
                        }
                        catch (DocumentException e) {
                            throw ServiceException.PARSE_ERROR("could not parse feed", e);
                        }
                        catch (HttpException e) {
                            throw ServiceException.RESOURCE_UNREACHABLE("HttpException: " + e, e, new ServiceException.Argument[0]);
                        }
                        catch (IOException e) {
                            throw ServiceException.RESOURCE_UNREACHABLE("IOException: " + e, e, new ServiceException.Argument[0]);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var16_25 = null;
                        if (get == null) throw throwable;
                        get.releaseConnection();
                        throw throwable;
                    }
                }
                get.releaseConnection();
                return subscriptionData2;
            }
            Object var16_23 = null;
            if (get == null) return locationHeader;
            get.releaseConnection();
            return locationHeader;
        }
        Object var16_24 = null;
        if (get == null) return subscriptionData;
        get.releaseConnection();
        return subscriptionData;
    }

    private static int getLeadingChar(BufferedInputStream is, StringBuilder charset) throws IOException {
        is.mark(128);
        int ch = is.read();
        switch (ch) {
            case 239: {
                if (is.read() != 187 || is.read() != 191) break;
                is.mark(128);
                ch = is.read();
                charset.setLength(0);
                charset.append("utf-8");
                break;
            }
            case 254: {
                if (is.read() != 255 || is.read() != 0) break;
                ch = is.read();
                charset.setLength(0);
                charset.append("utf-16");
                break;
            }
            case 255: {
                if (is.read() != 254) break;
                ch = is.read();
                charset.setLength(0);
                charset.append("utf-16");
            }
        }
        for (int index = 0; index < 120 && (ch == 0 || Character.isWhitespace(ch)); ++index) {
            ch = is.read();
        }
        is.reset();
        return ch;
    }

    private static SubscriptionData<ParsedMessage> parseRssFeed(Element root, Folder.SyncData fsd) throws ServiceException {
        try {
            String rname = root.getName();
            if (rname.equals("feed")) {
                return FeedManager.parseAtomFeed(root, fsd);
            }
            Element channel = root.getElement("channel");
            String hrefChannel = channel.getAttribute("link");
            String subjChannel = channel.getAttribute("title");
            InternetAddress addrChannel = new InternetAddress("", subjChannel, "utf-8");
            Date dateChannel = DateUtil.parseRFC2822Date(channel.getAttribute("lastBuildDate", null), new Date());
            ArrayList<Enclosure> enclosures = new ArrayList<Enclosure>(3);
            SubscriptionData<ParsedMessage> sdata = new SubscriptionData<ParsedMessage>(dateChannel.getTime());
            if (rname.equals("rss")) {
                root = channel;
            } else if (!rname.equals("RDF")) {
                throw ServiceException.PARSE_ERROR("unknown top-level rss element name: " + root.getQualifiedName(), null);
            }
            for (Element item : root.listElements("item")) {
                String text;
                boolean html;
                Date date = DateUtil.parseRFC2822Date(item.getAttribute("pubDate", null), null);
                if (date == null) {
                    date = DateUtil.parseISO8601Date(item.getAttribute("date", null), dateChannel);
                }
                InternetAddress addr = addrChannel;
                try {
                    addr = new InternetAddress(item.getAttribute("author"));
                }
                catch (Exception e) {
                    addr = FeedManager.parseDublinCreator(item.getAttribute("creator", null), addr);
                }
                String title = FeedManager.parseTitle(item.getAttribute("title", subjChannel));
                String href = item.getAttribute("link", hrefChannel);
                String guid = item.getAttribute("guid", href);
                if (fsd != null && fsd.alreadySeen(guid == hrefChannel ? null : guid, date == dateChannel ? null : date)) continue;
                enclosures.clear();
                Element enc = item.getOptionalElement("enclosure");
                if (enc != null) {
                    enclosures.add(new Enclosure(enc.getAttribute("url", null), null, enc.getAttribute("type", null)));
                }
                boolean bl = html = (text = item.getAttribute("encoded", null)) != null;
                if (text == null) {
                    text = item.getAttribute("description", null);
                }
                if (text == null) {
                    text = item.getAttribute("abstract", null);
                }
                if (text == null && title != subjChannel) {
                    text = "";
                }
                if (text == null) continue;
                ParsedMessage pm = FeedManager.generateMessage(title, text, href, html |= text.indexOf("</") != -1 || text.indexOf("/>") != -1 || text.indexOf("<p>") != -1, addr, date, enclosures);
                sdata.recordItem(pm, guid, date.getTime());
            }
            return sdata;
        }
        catch (UnsupportedEncodingException e) {
            throw ServiceException.FAILURE("error encoding rss channel name", e);
        }
    }

    private static SubscriptionData<ParsedMessage> parseAtomFeed(Element feed, Folder.SyncData fsd) throws ServiceException {
        try {
            InternetAddress addrFeed = FeedManager.parseAtomAuthor(feed.getOptionalElement("author"), null);
            if (addrFeed == null) {
                addrFeed = new InternetAddress("", feed.getAttribute("title"), "utf-8");
            }
            Date dateFeed = DateUtil.parseISO8601Date(feed.getAttribute("updated", null), new Date());
            ArrayList<Enclosure> enclosures = new ArrayList<Enclosure>();
            SubscriptionData<ParsedMessage> sdata = new SubscriptionData<ParsedMessage>(dateFeed.getTime());
            for (Element item : feed.listElements("entry")) {
                Date date = DateUtil.parseISO8601Date(item.getAttribute("updated", null), null);
                if (date == null) {
                    date = DateUtil.parseISO8601Date(item.getAttribute("modified", null), dateFeed);
                }
                InternetAddress addr = FeedManager.parseAtomAuthor(item.getOptionalElement("author"), addrFeed);
                Element tblock = item.getElement("title");
                String type = tblock.getAttribute("type", "text").trim().toLowerCase();
                String title = tblock.getText();
                if (type.equals("html") || type.equals("xhtml") || type.equals("text/html") || type.equals("application/xhtml+xml")) {
                    title = FeedManager.parseTitle(title);
                }
                enclosures.clear();
                String href = "";
                for (Element link : item.listElements("link")) {
                    String relation = link.getAttribute("rel", "alternate");
                    if (relation.equals("alternate")) {
                        href = link.getAttribute("href");
                        continue;
                    }
                    if (!relation.equals("enclosure")) continue;
                    enclosures.add(new Enclosure(link.getAttribute("href", null), link.getAttribute("title", null), link.getAttribute("type", null)));
                }
                String guid = item.getAttribute("id", href);
                if (fsd != null && fsd.alreadySeen(guid == null || guid.equals("") ? null : guid, date == dateFeed ? null : date)) continue;
                Element content = item.getOptionalElement("content");
                if (content == null) {
                    content = item.getOptionalElement("summary");
                }
                if (content == null) continue;
                type = content.getAttribute("type", "text").trim().toLowerCase();
                boolean html = false;
                if (type.equals("html") || type.equals("xhtml") || type.equals("text/html") || type.equals("application/xhtml+xml")) {
                    html = true;
                } else if (!type.equals("text") && !type.equals("text/plain")) {
                    throw ServiceException.PARSE_ERROR("unsupported atom entry content type: " + type, null);
                }
                ParsedMessage pm = FeedManager.generateMessage(title, content.getText(), href, html, addr, date, enclosures);
                sdata.recordItem(pm, guid, date.getTime());
            }
            return sdata;
        }
        catch (UnsupportedEncodingException e) {
            throw ServiceException.FAILURE("error encoding atom feed name", e);
        }
    }

    private static ParsedMessage generateMessage(String title, String text, String href, boolean html, InternetAddress addr, Date date, List<Enclosure> attach) throws ServiceException {
        String content;
        String ctype = html ? "text/html; charset=\"utf-8\"" : "text/plain; charset=\"utf-8\"";
        String string = content = html ? HTML_HEADER + text + "<p>" + href + HTML_FOOTER : text + "\r\n\r\n" + href;
        if (attach != null) {
            Iterator<Enclosure> it = attach.iterator();
            while (it.hasNext()) {
                if (it.next().getLocation() != null) continue;
                it.remove();
            }
        }
        boolean hasAttachments = attach != null && !attach.isEmpty();
        try {
            Mime.FixedMimeMessage mm = new Mime.FixedMimeMessage(JMSession.getSession());
            Mime.FixedMimeMessage body = hasAttachments ? new MimeBodyPart() : mm;
            body.setText(content, "utf-8");
            body.setHeader("Content-Type", ctype);
            if (hasAttachments) {
                MimeMultipart mmp = new MimeMultipart("mixed");
                mmp.addBodyPart((BodyPart)body);
                for (Enclosure enc : attach) {
                    MimeBodyPart part = new MimeBodyPart();
                    part.setText("");
                    part.addHeader("Content-Location", enc.getLocation());
                    part.addHeader("Content-Type", enc.getContentType());
                    if (enc.getDescription() != null) {
                        part.addHeader("Content-Description", enc.getDescription());
                    }
                    part.addHeader("Content-Disposition", "attachment");
                    mmp.addBodyPart((BodyPart)part);
                }
                mm.setContent((Multipart)mmp);
            }
            mm.setSentDate(date);
            mm.addFrom((Address[])new InternetAddress[]{addr});
            mm.setSubject(title, "utf-8");
            mm.saveChanges();
            return new ParsedMessage(mm, date.getTime(), false);
        }
        catch (MessagingException e) {
            throw ServiceException.PARSE_ERROR("error wrapping feed item in MimeMessage", e);
        }
    }

    private static InternetAddress parseDublinCreator(String creator, InternetAddress addrChannel) {
        if (creator == null || creator.equals("")) {
            return addrChannel;
        }
        String lc = creator.trim().toLowerCase();
        String address = "";
        String personal = creator;
        int mailto = lc.indexOf("mailto:");
        if (mailto == 0 && lc.length() <= 7) {
            return addrChannel;
        }
        if (mailto == 0) {
            personal = null;
            address = creator = creator.substring(7);
        } else if (mailto != -1) {
            char delimit = creator.charAt(mailto - 1);
            int complement = 0;
            if (delimit == '[') {
                complement = 93;
            } else if (delimit == '(') {
                complement = 41;
            }
            int closing = creator.indexOf(complement, mailto + 7);
            if (closing != -1 && closing != mailto + 7) {
                address = creator.substring(mailto + 7, closing);
                personal = (creator.substring(0, mailto - 1) + creator.substring(closing + 1)).trim();
            }
        }
        try {
            return new InternetAddress(address, personal, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            try {
                return new InternetAddress("", creator, "utf-8");
            }
            catch (UnsupportedEncodingException e2) {
                return addrChannel;
            }
        }
    }

    private static InternetAddress parseAtomAuthor(Element author, InternetAddress addrChannel) {
        if (author == null) {
            return addrChannel;
        }
        String address = author.getAttribute("email", "");
        String personal = author.getAttribute("name", "");
        if (personal.equals("") && address.equals("")) {
            return addrChannel;
        }
        try {
            return new InternetAddress(address, personal, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            try {
                return new InternetAddress("", address + personal, "utf-8");
            }
            catch (UnsupportedEncodingException e2) {
                return addrChannel;
            }
        }
    }

    private static final String parseTitle(String title) {
        if (title == null) {
            return "";
        }
        if (title.indexOf(60) == -1 && title.indexOf(38) == -1) {
            return title;
        }
        SAXParser parser = new SAXParser();
        UnescapedContent handler = new UnescapedContent();
        parser.setContentHandler(handler);
        try {
            parser.parse(new InputSource(new StringReader(title)));
            return ((Object)handler).toString();
        }
        catch (Exception e) {
            return title;
        }
    }

    private static class UnescapedContent
    extends DefaultHandler {
        private StringBuffer str = new StringBuffer();
        private boolean continued;

        UnescapedContent() {
        }

        public void startDocument() {
            this.str.setLength(0);
            this.continued = false;
        }

        public void characters(char[] ch, int offset, int length) {
            if (!this.continued && this.str.length() > 0) {
                this.str.append(' ');
            }
            this.str.append(ch, offset, length);
            this.continued = true;
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            this.continued = localName.toUpperCase().equals("A");
        }

        public void endElement(String uri, String localName, String qName) {
            this.continued = localName.toUpperCase().equals("A");
        }

        public String toString() {
            return this.str.toString();
        }
    }

    private static final class Enclosure {
        private String mUrl;
        private String mTitle;
        private String mCtype;

        Enclosure(String url, String title, String ctype) {
            this.mUrl = url;
            this.mTitle = title;
            this.mCtype = ctype;
        }

        String getLocation() {
            return this.mUrl;
        }

        String getDescription() {
            return this.mTitle;
        }

        String getContentType() {
            ContentType ctype = new ContentType(this.mCtype == null ? "text/plain" : this.mCtype);
            try {
                ctype.setParameter("name", FileUtil.trimFilename(URLDecoder.decode(this.mUrl, "utf-8")));
            }
            catch (UnsupportedEncodingException e) {
                ctype.setParameter("name", FileUtil.trimFilename(this.mUrl));
            }
            return ctype.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class SubscriptionData<T> {
        public final List<T> items;
        public String lastGuid;
        public long lastDate = -1L;
        public long feedDate = System.currentTimeMillis();

        SubscriptionData() {
            this.items = new ArrayList<T>();
        }

        SubscriptionData(List<T> list) {
            this.items = list;
        }

        SubscriptionData(long fdate) {
            this.items = new ArrayList<T>();
            this.feedDate = fdate;
        }

        void recordItem(T item, String guid, long date) {
            this.items.add(item);
            if (date > this.lastDate) {
                this.lastGuid = guid;
                this.lastDate = date;
            }
        }
    }
}

