/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service;

import com.zimbra.common.mime.ContentDisposition;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ByteUtil;
import com.zimbra.common.util.HttpUtil;
import com.zimbra.common.util.L10nUtil;
import com.zimbra.common.util.Log;
import com.zimbra.common.util.LogFactory;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AuthToken;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Server;
import com.zimbra.cs.html.HtmlDefang;
import com.zimbra.cs.mailbox.CalendarItem;
import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.mailbox.Message;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.mailbox.calendar.CalendarMailSender;
import com.zimbra.cs.mailbox.calendar.Invite;
import com.zimbra.cs.mime.Mime;
import com.zimbra.cs.service.FileUploadServlet;
import com.zimbra.cs.service.util.ItemId;
import com.zimbra.cs.servlet.ZimbraServlet;
import com.zimbra.cs.util.AccountUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimePart;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ContentServlet
extends ZimbraServlet {
    private static final long serialVersionUID = 6466028729668217319L;
    public static final String SERVLET_PATH = "/service/content";
    public static final String PREFIX_GET = "/get";
    protected static final String PREFIX_PROXY = "/proxy";
    public static final String PARAM_MSGID = "id";
    protected static final String PARAM_UPLOAD_ID = "aid";
    protected static final String PARAM_PART = "part";
    protected static final String PARAM_FORMAT = "fmt";
    protected static final String PARAM_SYNC = "sync";
    protected static final String PARAM_EXPUNGE = "expunge";
    protected static final String PARAM_LOCALE_ID = "loc";
    protected static final String FORMAT_RAW = "raw";
    protected static final String FORMAT_DEFANGED_HTML = "htmldf";
    protected static final String FORMAT_DEFANGED_HTML_NOT_IMAGES = "htmldfi";
    protected static final String CONVERSION_PATH = "/extension/convertd";
    protected static final String ATTR_MIMEPART = "mimepart";
    protected static final String ATTR_MSGDIGEST = "msgdigest";
    protected static final String ATTR_CONTENTURL = "contenturl";
    protected static final String MSGPAGE_BLOCK = "errorpage.attachment.blocked";
    private String mBlockPage = null;
    private static Log mLog = LogFactory.getLog(ContentServlet.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void getCommand(HttpServletRequest req, HttpServletResponse resp, AuthToken token) throws ServletException, IOException {
        ItemId iid = null;
        try {
            iid = new ItemId(req.getParameter(PARAM_MSGID), (String)null);
        }
        catch (ServiceException e) {
            resp.sendError(400, L10nUtil.getMessage(L10nUtil.MsgKey.errInvalidId, req, new Object[0]));
            return;
        }
        String part = req.getParameter(PARAM_PART);
        String fmt = req.getParameter(PARAM_FORMAT);
        try {
            try {
                block32: {
                    block33: {
                        MailItem item;
                        Mailbox mbox;
                        block30: {
                            block31: {
                                if (!iid.isLocal()) {
                                    this.proxyServletRequest(req, resp, iid.getAccountId());
                                    Object var19_8 = null;
                                    ZimbraLog.clearContext();
                                    return;
                                }
                                String authId = token.getAccountId();
                                String accountId = iid.getAccountId() != null ? iid.getAccountId() : authId;
                                AccountUtil.addAccountToLogContext(Provisioning.getInstance(), accountId, "name", PARAM_MSGID, token);
                                if (!accountId.equalsIgnoreCase(authId)) {
                                    ZimbraLog.addToContext(PARAM_UPLOAD_ID, authId);
                                }
                                if ((mbox = MailboxManager.getInstance().getMailboxByAccountId(accountId)) == null) {
                                    resp.sendError(400, L10nUtil.getMessage(L10nUtil.MsgKey.errMailboxNotFound, req, new Object[0]));
                                    Object var19_9 = null;
                                    ZimbraLog.clearContext();
                                    return;
                                }
                                ZimbraLog.addMboxToContext(mbox.getId());
                                item = mbox.getItemById(new OperationContext(token), iid.getId(), (byte)-1);
                                if (item == null) {
                                    resp.sendError(400, L10nUtil.getMessage(L10nUtil.MsgKey.errMessageNotFound, req, new Object[0]));
                                    Object var19_10 = null;
                                    ZimbraLog.clearContext();
                                    return;
                                }
                                if (part != null) break block30;
                                boolean sync = "1".equals(req.getParameter(PARAM_SYNC));
                                StringBuffer hdr = new StringBuffer();
                                if (sync) {
                                    resp.addHeader("X-Zimbra-Tags", item.getTagString());
                                    resp.addHeader("X-Zimbra-Flags", item.getFlagString());
                                    resp.addHeader("X-Zimbra-Received", Long.toString(item.getDate()));
                                    resp.addHeader("X-Zimbra-Modified", Long.toString(item.getChangeDate()));
                                    hdr.append("X-Zimbra-Tags: ").append(item.getTagString()).append("\n");
                                    hdr.append("X-Zimbra-Flags: ").append(item.getFlagString()).append("\n");
                                    hdr.append("X-Zimbra-Received: ").append(item.getDate()).append("\n");
                                    hdr.append("X-Zimbra-Modified: ").append(item.getChangeDate()).append("\n");
                                }
                                if (item instanceof Message) {
                                    Message msg = (Message)item;
                                    if (sync) {
                                        resp.addHeader("X-Zimbra-Conv", Integer.toString(msg.getConversationId()));
                                        hdr.append("X-Zimbra-Conv: ").append(msg.getConversationId()).append("\n");
                                        resp.getOutputStream().write(hdr.toString().getBytes());
                                    }
                                    resp.setContentType("text/plain");
                                    InputStream is = msg.getContentStream();
                                    ByteUtil.copy(is, true, (OutputStream)resp.getOutputStream(), false);
                                    break block31;
                                }
                                if (!(item instanceof CalendarItem)) break block31;
                                CalendarItem calItem = (CalendarItem)item;
                                if (sync) {
                                    resp.getOutputStream().write(hdr.toString().getBytes());
                                }
                                resp.setContentType("text/plain");
                                if (iid.hasSubpart()) {
                                    Invite[] invs;
                                    int invId = iid.getSubpartId();
                                    MimeMessage mm = calItem.getSubpartMessage(invId);
                                    if (mm == null && (invs = calItem.getInvites(invId)) != null && invs.length > 0) {
                                        Invite invite = invs[0];
                                        mm = CalendarMailSender.createCalendarMessage(invite);
                                    }
                                    if (mm != null) {
                                        mm.writeTo((OutputStream)resp.getOutputStream());
                                    }
                                    break block31;
                                }
                                InputStream is = calItem.getRawMessage();
                                if (is == null) break block31;
                                ByteUtil.copy(is, true, (OutputStream)resp.getOutputStream(), false);
                            }
                            Object var19_11 = null;
                            ZimbraLog.clearContext();
                            return;
                        }
                        MimePart mp = null;
                        if (item instanceof Message) {
                            mp = ContentServlet.getMimePart((Message)item, part);
                        } else {
                            CalendarItem calItem = (CalendarItem)item;
                            if (iid.hasSubpart()) {
                                MimeMessage mbp = calItem.getSubpartMessage(iid.getSubpartId());
                                if (mbp != null) {
                                    mp = Mime.getMimePart((MimePart)mbp, part);
                                }
                            } else {
                                mp = ContentServlet.getMimePart(calItem, part);
                            }
                        }
                        if (mp == null) break block32;
                        String contentType = mp.getContentType();
                        if (contentType == null) {
                            contentType = "application/octet-stream";
                        }
                        if (contentType.toLowerCase().startsWith("text/html") && (FORMAT_DEFANGED_HTML.equals(fmt) || FORMAT_DEFANGED_HTML_NOT_IMAGES.equals(fmt))) {
                            ContentServlet.sendbackDefangedHtml(mp, contentType, resp, fmt);
                            break block33;
                        }
                        if (!this.isTrue("zimbraAttachmentsViewInHtmlOnly", mbox.getAccountId())) {
                            ContentServlet.sendbackOriginalDoc(mp, contentType, req, resp);
                            break block33;
                        }
                        req.setAttribute(ATTR_MIMEPART, (Object)mp);
                        req.setAttribute(ATTR_MSGDIGEST, (Object)item.getDigest());
                        req.setAttribute(ATTR_CONTENTURL, (Object)req.getRequestURL().toString());
                        RequestDispatcher dispatcher = this.getServletContext().getRequestDispatcher(CONVERSION_PATH);
                        dispatcher.forward((ServletRequest)req, (ServletResponse)resp);
                    }
                    Object var19_12 = null;
                    ZimbraLog.clearContext();
                    return;
                }
                try {
                    resp.sendError(400, L10nUtil.getMessage(L10nUtil.MsgKey.errPartNotFound, req, new Object[0]));
                }
                catch (MessagingException e) {
                    resp.sendError(500, e.getMessage());
                }
                Object var19_13 = null;
            }
            catch (MailServiceException.NoSuchItemException e) {
                resp.sendError(404, L10nUtil.getMessage(L10nUtil.MsgKey.errNoSuchItem, req, new Object[0]));
                Object var19_14 = null;
                ZimbraLog.clearContext();
                return;
            }
            catch (ServiceException e) {
                this.returnError(resp, e);
                Object var19_15 = null;
                ZimbraLog.clearContext();
                return;
            }
            ZimbraLog.clearContext();
            return;
        }
        catch (Throwable throwable) {
            Object var19_16 = null;
            ZimbraLog.clearContext();
            throw throwable;
        }
    }

    private void retrieveUpload(HttpServletRequest req, HttpServletResponse resp, AuthToken authToken) throws IOException {
        String uploadId = req.getParameter(PARAM_UPLOAD_ID);
        if (uploadId == null) {
            resp.sendError(400, L10nUtil.getMessage(L10nUtil.MsgKey.errMissingUploadId, req, new Object[0]));
            return;
        }
        try {
            boolean expunge;
            if (!FileUploadServlet.isLocalUpload(uploadId)) {
                String serverId = FileUploadServlet.getUploadServerId(uploadId);
                Server server = Provisioning.getInstance().get(Provisioning.ServerBy.id, serverId);
                this.proxyServletRequest(req, resp, server, null);
                return;
            }
            FileUploadServlet.Upload up = FileUploadServlet.fetchUpload(authToken.getAccountId(), uploadId, authToken);
            if (up == null) {
                resp.sendError(400, L10nUtil.getMessage(L10nUtil.MsgKey.errNoSuchUpload, req, new Object[0]));
                return;
            }
            String filename = up.getName();
            ContentDisposition cd = new ContentDisposition("inline").setParameter("filename", filename == null ? "unknown" : filename);
            resp.addHeader("Content-Disposition", cd.toString());
            ContentServlet.sendbackOriginalDoc(up.getInputStream(), up.getContentType(), resp);
            boolean bl = expunge = "true".equalsIgnoreCase(req.getParameter(PARAM_EXPUNGE)) || "1".equals(req.getParameter(PARAM_EXPUNGE));
            if (expunge) {
                FileUploadServlet.deleteUpload(up);
            }
        }
        catch (ServiceException e) {
            this.returnError(resp, e);
        }
    }

    private boolean isTrue(String attr, String accountId) throws ServletException {
        Provisioning prov = Provisioning.getInstance();
        try {
            Account account = prov.get(Provisioning.AccountBy.id, accountId);
            return prov.getConfig().getBooleanAttr(attr, false) || account.getBooleanAttr(attr, false);
        }
        catch (ServiceException e) {
            throw new ServletException((Throwable)e);
        }
    }

    public static MimePart getMimePart(CalendarItem calItem, String part) throws IOException, MessagingException, ServiceException {
        return Mime.getMimePart((MimePart)calItem.getMimeMessage(), part);
    }

    public static MimePart getMimePart(Message msg, String part) throws IOException, MessagingException, ServiceException {
        return Mime.getMimePart((MimePart)msg.getMimeMessage(), part);
    }

    public static void sendbackOriginalDoc(MimePart mp, String contentType, HttpServletRequest req, HttpServletResponse resp) throws IOException, MessagingException {
        String filename = Mime.getFilename(mp);
        if (filename == null) {
            filename = "unknown";
        }
        String cd = "inline; filename=" + HttpUtil.encodeFilename(req, filename);
        resp.addHeader("Content-Disposition", cd);
        String desc = mp.getDescription();
        if (desc != null) {
            resp.addHeader("Content-Description", desc);
        }
        ContentServlet.sendbackOriginalDoc(mp.getInputStream(), contentType, resp);
    }

    public static void sendbackOriginalDoc(InputStream is, String contentType, HttpServletResponse resp) throws IOException {
        resp.setContentType(contentType);
        ByteUtil.copy(is, true, (OutputStream)resp.getOutputStream(), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void sendbackDefangedHtml(MimePart mp, String contentType, HttpServletResponse resp, String fmt) throws IOException, MessagingException {
        resp.setContentType(contentType);
        InputStream is = null;
        try {
            is = mp.getInputStream();
            String html = HtmlDefang.defang(is, FORMAT_DEFANGED_HTML.equals(fmt));
            ByteArrayInputStream bais = new ByteArrayInputStream(html.getBytes("utf-8"));
            ByteUtil.copy(bais, false, (OutputStream)resp.getOutputStream(), false);
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            ByteUtil.closeStream(is);
            throw throwable;
        }
        ByteUtil.closeStream(is);
    }

    private void sendbackBlockMessage(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        RequestDispatcher dispatcher = this.getServletContext().getRequestDispatcher(this.mBlockPage);
        if (dispatcher != null) {
            dispatcher.forward((ServletRequest)req, (ServletResponse)resp);
            return;
        }
        resp.sendError(403, L10nUtil.getMessage(L10nUtil.MsgKey.errAttachmentDownloadDisabled, req, new Object[0]));
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        ZimbraLog.clearContext();
        this.addRemoteIpToLoggingContext(req);
        mLog.debug("request url: %s, path info: ", req.getRequestURL(), req.getPathInfo());
        AuthToken authToken = ContentServlet.getAuthTokenFromCookie(req, resp);
        if (authToken == null) {
            return;
        }
        if (this.isTrue("zimbraAttachmentsBlocked", authToken.getAccountId())) {
            this.sendbackBlockMessage(req, resp);
            return;
        }
        String pathInfo = req.getPathInfo();
        if (pathInfo != null && pathInfo.equals(PREFIX_GET)) {
            this.getCommand(req, resp, authToken);
        } else if (pathInfo != null && pathInfo.equals(PREFIX_PROXY)) {
            this.retrieveUpload(req, resp, authToken);
        } else {
            resp.sendError(400, L10nUtil.getMessage(L10nUtil.MsgKey.errInvalidRequest, req, new Object[0]));
        }
    }

    public void init() throws ServletException {
        String name = this.getServletName();
        mLog.info("Servlet " + name + " starting up");
        super.init();
        this.mBlockPage = this.getInitParameter(MSGPAGE_BLOCK);
    }

    public void destroy() {
        String name = this.getServletName();
        mLog.info("Servlet " + name + " shutting down");
        super.destroy();
    }
}

