/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service;

import com.zimbra.common.service.ServiceException;

public class AuthProviderException
extends ServiceException {
    private boolean mCanIgnore;
    public static final String NO_AUTH_DATA = "authprovider.NO_AUTH_DATA";
    public static final String NOT_SUPPORTED = "authprovider.NOT_SUPPORTED";
    public static final String FAILURE = "authprovider.FAILURE";

    private AuthProviderException(String message, String code, boolean isReceiversFault) {
        super(message, code, isReceiversFault, new ServiceException.Argument[0]);
        this.setCanIgnore(true);
    }

    private AuthProviderException(String message, String code, boolean isReceiversFault, Throwable cause) {
        super(message, code, isReceiversFault, cause, new ServiceException.Argument[0]);
        this.setCanIgnore(true);
    }

    private void setCanIgnore(boolean canIgnore) {
        this.mCanIgnore = canIgnore;
    }

    public boolean canIgnore() {
        return this.mCanIgnore;
    }

    public static AuthProviderException NO_AUTH_DATA() {
        return new AuthProviderException("no auth token", NO_AUTH_DATA, false, null);
    }

    public static AuthProviderException NOT_SUPPORTED() {
        return new AuthProviderException("not suported", NOT_SUPPORTED, false, null);
    }

    public static AuthProviderException FAILURE(String message) {
        return new AuthProviderException("failure:" + message, FAILURE, false, null);
    }
}

