/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.util.Log;
import com.zimbra.common.util.LogFactory;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AuthToken;
import com.zimbra.cs.account.AuthTokenException;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.service.AuthProviderException;
import com.zimbra.cs.service.ZimbraAuthProvider;
import com.zimbra.cs.servlet.ZimbraServlet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AuthProvider {
    public static final String ZIMBRA_AUTH_PROVIDER = "zimbra";
    private static Log sLog = LogFactory.getLog(AuthProvider.class);
    private static Map<String, AuthProvider> sRegisteredProviders = new HashMap<String, AuthProvider>();
    private static List<AuthProvider> sEnabledProviders = null;
    private String mName;

    public static synchronized void register(AuthProvider ap) {
        String name = ap.getName();
        AuthProvider.logger().info("Adding auth provider: " + name + " " + ap.getClass().getName());
        if (sRegisteredProviders.get(name) == null) {
            sRegisteredProviders.put(name, ap);
        } else {
            AuthProvider.logger().error("auth provider " + name + " already exists, not adding " + ap.getClass().getName());
        }
    }

    public static void refresh() {
        String[] providers;
        ArrayList<AuthProvider> providerList = new ArrayList<AuthProvider>();
        for (String p : providers = LC.zimbra_auth_provider.value().split(",")) {
            AuthProvider ap = sRegisteredProviders.get(p);
            if (ap == null) continue;
            providerList.add(ap);
        }
        if (providerList.size() == 0) {
            providerList.add(sRegisteredProviders.get(ZIMBRA_AUTH_PROVIDER));
        }
        AuthProvider.setProviders(providerList);
    }

    private static synchronized void setProviders(List<AuthProvider> providers) {
        sEnabledProviders = providers;
    }

    private static synchronized List<AuthProvider> getProviders() {
        return sEnabledProviders;
    }

    protected AuthProvider(String name) {
        this.mName = name;
    }

    private String getName() {
        return this.mName;
    }

    protected static Log logger() {
        return sLog;
    }

    protected abstract AuthToken authToken(HttpServletRequest var1, boolean var2) throws AuthProviderException, AuthTokenException;

    protected abstract AuthToken authToken(Element var1, Map var2) throws AuthProviderException, AuthTokenException;

    protected AuthToken authToken(String encoded) throws AuthProviderException, AuthTokenException {
        throw AuthProviderException.NOT_SUPPORTED();
    }

    protected AuthToken authToken(Account acct) throws AuthProviderException {
        return this.authToken(acct, false);
    }

    protected AuthToken authToken(Account acct, boolean isAdmin) throws AuthProviderException {
        if (acct == null) {
            throw AuthProviderException.NOT_SUPPORTED();
        }
        long lifetime = isAdmin ? acct.getTimeInterval("zimbraAdminAuthTokenLifetime", 43200000L) : acct.getTimeInterval("zimbraAuthTokenLifetime", 43200000L);
        return this.authToken(acct, lifetime);
    }

    protected AuthToken authToken(Account acct, long expires) throws AuthProviderException {
        throw AuthProviderException.NOT_SUPPORTED();
    }

    protected AuthToken authToken(Account acct, long expires, boolean isAdmin, Account adminAcct) throws AuthProviderException {
        throw AuthProviderException.NOT_SUPPORTED();
    }

    protected boolean allowHttpBasicAuth(HttpServletRequest req, ZimbraServlet servlet) {
        return true;
    }

    protected boolean allowURLAccessKeyAuth(HttpServletRequest req, ZimbraServlet servlet) {
        return false;
    }

    public static AuthToken getAuthToken(HttpServletRequest req, boolean isAdminReq) throws AuthTokenException {
        AuthToken at = null;
        List<AuthProvider> providers = AuthProvider.getProviders();
        for (AuthProvider ap : providers) {
            try {
                at = ap.authToken(req, isAdminReq);
                if (at == null) {
                    throw new AuthTokenException("auth provider " + ap.getName() + " returned null");
                }
                return at;
            }
            catch (AuthProviderException e) {
                if (e.canIgnore()) {
                    AuthProvider.logger().debug(ap.getName() + ":" + e.getMessage());
                    continue;
                }
                throw new AuthTokenException("auth provider error", e);
            }
            catch (AuthTokenException e) {
                AuthProvider.logger().debug((Object)("getAuthToken error: provider=" + ap.getName() + ", err=" + e.getMessage()), e);
                throw e;
            }
        }
        return null;
    }

    public static AuthToken getAuthToken(Element soapCtxt, Map engineCtxt) throws AuthTokenException {
        AuthToken at = null;
        List<AuthProvider> providers = AuthProvider.getProviders();
        for (AuthProvider ap : providers) {
            try {
                at = ap.authToken(soapCtxt, engineCtxt);
                if (at == null) {
                    throw new AuthTokenException("auth provider " + ap.getName() + " returned null");
                }
                return at;
            }
            catch (AuthProviderException e) {
                if (e.canIgnore()) {
                    AuthProvider.logger().debug(ap.getName() + ":" + e.getMessage());
                    continue;
                }
                throw new AuthTokenException("auth provider error", e);
            }
            catch (AuthTokenException e) {
                AuthProvider.logger().debug((Object)("getAuthToken error: provider=" + ap.getName() + ", err=" + e.getMessage()), e);
                throw e;
            }
        }
        return null;
    }

    public static AuthToken getAuthToken(String encoded) throws AuthTokenException {
        AuthToken at = null;
        List<AuthProvider> providers = AuthProvider.getProviders();
        for (AuthProvider ap : providers) {
            try {
                at = ap.authToken(encoded);
                if (at == null) {
                    throw new AuthTokenException("auth provider " + ap.getName() + " returned null");
                }
                return at;
            }
            catch (AuthProviderException e) {
                if (e.canIgnore()) {
                    AuthProvider.logger().warn(ap.getName() + ":" + e.getMessage());
                    continue;
                }
                throw new AuthTokenException("auth provider error", e);
            }
            catch (AuthTokenException e) {
                AuthProvider.logger().debug((Object)("getAuthToken error: provider=" + ap.getName() + ", err=" + e.getMessage()), e);
                throw e;
            }
        }
        AuthProvider.logger().error("unable to get AuthToken from encoded " + encoded);
        return null;
    }

    public static AuthToken getAuthToken(Account acct) throws AuthProviderException {
        List<AuthProvider> providers = AuthProvider.getProviders();
        for (AuthProvider ap : providers) {
            try {
                AuthToken at = ap.authToken(acct);
                if (at == null) {
                    throw AuthProviderException.FAILURE("auth provider " + ap.getName() + " returned null");
                }
                return at;
            }
            catch (AuthProviderException e) {
                if (e.canIgnore()) {
                    AuthProvider.logger().debug(ap.getName() + ":" + e.getMessage());
                    continue;
                }
                throw e;
            }
        }
        throw AuthProviderException.FAILURE("cannot get authtoken from account " + acct.getName());
    }

    public static AuthToken getAuthToken(Account acct, boolean isAdmin) throws AuthProviderException {
        List<AuthProvider> providers = AuthProvider.getProviders();
        for (AuthProvider ap : providers) {
            try {
                AuthToken at = ap.authToken(acct, isAdmin);
                if (at == null) {
                    throw AuthProviderException.FAILURE("auth provider " + ap.getName() + " returned null");
                }
                return at;
            }
            catch (AuthProviderException e) {
                if (e.canIgnore()) {
                    AuthProvider.logger().debug(ap.getName() + ":" + e.getMessage());
                    continue;
                }
                throw e;
            }
        }
        String acctName = acct != null ? acct.getName() : "null";
        throw AuthProviderException.FAILURE("cannot get authtoken from account " + acctName);
    }

    public static AuthToken getAuthToken(Account acct, long expires) throws AuthProviderException {
        List<AuthProvider> providers = AuthProvider.getProviders();
        for (AuthProvider ap : providers) {
            try {
                AuthToken at = ap.authToken(acct, expires);
                if (at == null) {
                    throw AuthProviderException.FAILURE("auth provider " + ap.getName() + " returned null");
                }
                return at;
            }
            catch (AuthProviderException e) {
                if (e.canIgnore()) {
                    AuthProvider.logger().debug(ap.getName() + ":" + e.getMessage());
                    continue;
                }
                throw e;
            }
        }
        throw AuthProviderException.FAILURE("cannot get authtoken from account " + acct.getName());
    }

    public static AuthToken getAuthToken(Account acct, long expires, boolean isAdmin, Account adminAcct) throws AuthProviderException {
        List<AuthProvider> providers = AuthProvider.getProviders();
        for (AuthProvider ap : providers) {
            try {
                AuthToken at = ap.authToken(acct, expires, isAdmin, adminAcct);
                if (at == null) {
                    throw AuthProviderException.FAILURE("auth provider " + ap.getName() + " returned null");
                }
                return at;
            }
            catch (AuthProviderException e) {
                if (e.canIgnore()) {
                    AuthProvider.logger().debug(ap.getName() + ":" + e.getMessage());
                    continue;
                }
                throw e;
            }
        }
        throw AuthProviderException.FAILURE("cannot get authtoken from account " + acct.getName());
    }

    public static boolean allowBasicAuth(HttpServletRequest req, ZimbraServlet servlet) {
        List<AuthProvider> providers = AuthProvider.getProviders();
        for (AuthProvider ap : providers) {
            if (!ap.allowHttpBasicAuth(req, servlet)) continue;
            return true;
        }
        return false;
    }

    public static boolean allowAccessKeyAuth(HttpServletRequest req, ZimbraServlet servlet) {
        List<AuthProvider> providers = AuthProvider.getProviders();
        for (AuthProvider ap : providers) {
            if (!ap.allowURLAccessKeyAuth(req, servlet)) continue;
            return true;
        }
        return false;
    }

    public static Account validateAuthToken(Provisioning prov, AuthToken at, boolean addToLoggingContext) throws ServiceException {
        if (prov == null) {
            prov = Provisioning.getInstance();
        }
        if (at.isExpired()) {
            throw ServiceException.AUTH_EXPIRED();
        }
        Account acct = prov.get(Provisioning.AccountBy.id, at.getAccountId(), at);
        if (addToLoggingContext && acct != null) {
            ZimbraLog.addAccountNameToContext(acct.getName());
        }
        if (acct == null || !acct.getAccountStatus(prov).equals("active") || acct.getAuthTokenValidityValue() != at.getValidityValue()) {
            throw ServiceException.AUTH_EXPIRED();
        }
        return acct;
    }

    public static void main(String[] args) throws Exception {
        AuthToken at = AuthProvider.getAuthToken(null, null);
    }

    static {
        AuthProvider.register(new ZimbraAuthProvider());
        AuthProvider.refresh();
    }
}

