/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.server;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.NetUtil;
import java.net.ServerSocket;
import java.nio.channels.ServerSocketChannel;

public class ServerConfig {
    private String mName;
    private int mMaxIdleSeconds = 0;
    private String mBindAddress;
    private int mBindPort = -1;
    private int mNumThreads = -1;
    private boolean mSSLEnabled;
    private String[] mSSLExcludeCiphers;

    public ServerConfig() {
        String name = LC.zimbra_server_hostname.value();
        if (name != null) {
            this.setName(name);
        }
    }

    public void validate() throws ServiceException {
        if (this.mName == null) {
            this.failure("missing configuration name");
        }
        if (this.mMaxIdleSeconds < 0) {
            this.failure("invalid MaxIdleSeconds value: " + this.mMaxIdleSeconds);
        }
        if (this.mBindPort < 0) {
            this.failure("invalid BindPort value: " + this.mBindPort);
        }
        if (this.mNumThreads < 0) {
            this.failure("invalid NumThreads value: " + this.mNumThreads);
        }
    }

    protected void failure(String msg) throws ServiceException {
        throw ServiceException.FAILURE(msg, null);
    }

    public void setName(String name) {
        this.mName = name;
    }

    public String getName() {
        return this.mName;
    }

    public void setMaxIdleSeconds(int secs) {
        this.mMaxIdleSeconds = secs;
    }

    public int getMaxIdleSeconds() {
        return this.mMaxIdleSeconds;
    }

    public void setBindAddress(String addr) {
        this.mBindAddress = addr;
    }

    public String getBindAddress() {
        return this.mBindAddress;
    }

    public void setBindPort(int port) {
        this.mBindPort = port;
    }

    public int getBindPort() {
        return this.mBindPort;
    }

    public void setNumThreads(int numThreads) {
        this.mNumThreads = numThreads;
    }

    public int getNumThreads() {
        return this.mNumThreads;
    }

    public void setSSLEnabled(boolean enabled) {
        this.mSSLEnabled = enabled;
    }

    public boolean isSSLEnabled() {
        return this.mSSLEnabled;
    }

    public void setSSLExcludeCiphers(String[] excludeCiphers) {
        this.mSSLExcludeCiphers = excludeCiphers;
    }

    public String[] getSSLExcludeCiphers() {
        return this.mSSLExcludeCiphers;
    }

    public ServerSocket getServerSocket() throws ServiceException {
        return this.isSSLEnabled() ? NetUtil.getSslTcpServerSocket(this.getBindAddress(), this.getBindPort(), this.getSSLExcludeCiphers()) : NetUtil.getTcpServerSocket(this.getBindAddress(), this.getBindPort());
    }

    public ServerSocketChannel getServerSocketChannel() throws ServiceException {
        return NetUtil.getNioServerSocket(this.getBindAddress(), this.getBindPort()).getChannel();
    }
}

