/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.security.sasl;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AuthToken;
import com.zimbra.cs.account.AuthTokenException;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.ZimbraAuthToken;
import com.zimbra.cs.account.auth.AuthContext;
import com.zimbra.cs.security.sasl.Authenticator;
import com.zimbra.cs.security.sasl.AuthenticatorUser;
import com.zimbra.cs.service.AuthProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.security.sasl.SaslServer;

public class ZimbraAuthenticator
extends Authenticator {
    public static final String MECHANISM = "X-ZIMBRA";

    public ZimbraAuthenticator(AuthenticatorUser user) {
        super(MECHANISM, user);
    }

    protected boolean isSupported() {
        return true;
    }

    public boolean initialize() {
        return true;
    }

    public void dispose() {
    }

    public boolean isEncryptionEnabled() {
        return false;
    }

    public InputStream unwrap(InputStream is) {
        return null;
    }

    public OutputStream wrap(OutputStream os) {
        return null;
    }

    public SaslServer getSaslServer() {
        return null;
    }

    public void handle(byte[] data) throws IOException {
        if (this.isComplete()) {
            throw new IllegalStateException("Authentication already completed");
        }
        String message = new String(data, "utf-8");
        int nul1 = message.indexOf(0);
        int nul2 = message.indexOf(0, nul1 + 1);
        if (nul1 == -1 || nul2 == -1) {
            this.sendBadRequest();
            return;
        }
        String authorizeId = message.substring(0, nul1);
        String authenticateId = message.substring(nul1 + 1, nul2);
        String authtoken = message.substring(nul2 + 1);
        this.authenticate(authorizeId, authenticateId, authtoken);
    }

    public Account authenticate(String username, String authenticateId, String authtoken, AuthContext.Protocol protocol, String origRemoteIp, String userAgent) throws ServiceException {
        AuthToken at;
        if (authenticateId == null || authenticateId.equals("")) {
            return null;
        }
        Provisioning prov = Provisioning.getInstance();
        try {
            at = ZimbraAuthToken.getAuthToken(authtoken);
        }
        catch (AuthTokenException e) {
            return null;
        }
        try {
            AuthProvider.validateAuthToken(prov, at, false);
        }
        catch (ServiceException e) {
            return null;
        }
        Account authAccount = prov.get(Provisioning.AccountBy.name, authenticateId, at);
        if (authAccount == null) {
            return null;
        }
        if (!at.getAccountId().equalsIgnoreCase(authAccount.getId())) {
            return null;
        }
        Account targetAcct = this.authorize(authAccount, username, AuthToken.isAnyAdmin(at));
        if (targetAcct != null) {
            prov.accountAuthed(authAccount);
        }
        return targetAcct;
    }
}

