/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.security.sasl;

import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;

public abstract class SaslSecurityLayer {
    public static final String QOP_AUTH = "auth";
    public static final String QOP_AUTH_INT = "auth-int";
    public static final String QOP_AUTH_CONF = "auth-conf";
    public static final int MAX_SEND_SIZE = 4096;
    public static final int MAX_RECV_SIZE = 65536;

    public static SaslSecurityLayer getInstance(final SaslClient client) {
        return new SaslSecurityLayer(){

            public String getMechanismName() {
                return client.getMechanismName();
            }

            public Object getNegotiatedProperty(String name) {
                return client.getNegotiatedProperty(name);
            }

            public byte[] wrap(byte[] b, int off, int len) throws SaslException {
                return client.wrap(b, off, len);
            }

            public byte[] unwrap(byte[] b, int off, int len) throws SaslException {
                return client.unwrap(b, off, len);
            }

            public void dispose() throws SaslException {
                client.dispose();
            }
        };
    }

    public static SaslSecurityLayer getInstance(final SaslServer server) {
        return new SaslSecurityLayer(){

            public String getMechanismName() {
                return server.getMechanismName();
            }

            public Object getNegotiatedProperty(String name) {
                return server.getNegotiatedProperty(name);
            }

            public byte[] wrap(byte[] b, int off, int len) throws SaslException {
                return server.wrap(b, off, len);
            }

            public byte[] unwrap(byte[] b, int off, int len) throws SaslException {
                return server.unwrap(b, off, len);
            }

            public void dispose() throws SaslException {
                server.dispose();
            }
        };
    }

    public abstract String getMechanismName();

    public abstract Object getNegotiatedProperty(String var1);

    public abstract byte[] wrap(byte[] var1, int var2, int var3) throws SaslException;

    public abstract byte[] unwrap(byte[] var1, int var2, int var3) throws SaslException;

    public abstract void dispose() throws SaslException;

    public boolean isEnabled() {
        String qop = (String)this.getNegotiatedProperty("javax.security.sasl.qop");
        return qop != null && (QOP_AUTH_INT.equals(qop) || QOP_AUTH_CONF.equals(qop));
    }

    public int getMaxSendSize() {
        try {
            String s = (String)this.getNegotiatedProperty("javax.security.sasl.rawsendsize");
            return Integer.parseInt(s);
        }
        catch (Exception e) {
            return 4096;
        }
    }

    public int getMaxRecvSize() {
        try {
            String s = (String)this.getNegotiatedProperty("javax.security.sasl.maxbuffer");
            return Integer.parseInt(s);
        }
        catch (Exception e) {
            return 65536;
        }
    }
}

