/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.security.sasl;

import com.zimbra.cs.security.sasl.SaslOutputBuffer;
import com.zimbra.cs.security.sasl.SaslSecurityLayer;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslServer;

public class SaslOutputStream
extends OutputStream {
    private final DataOutputStream mOutputStream;
    private final SaslSecurityLayer mSecurityLayer;
    private final SaslOutputBuffer mBuffer;
    private static final boolean DEBUG = false;

    public SaslOutputStream(OutputStream os, SaslServer server) {
        this(os, SaslSecurityLayer.getInstance(server));
    }

    public SaslOutputStream(OutputStream os, SaslClient client) {
        this(os, SaslSecurityLayer.getInstance(client));
    }

    public SaslOutputStream(OutputStream os, SaslSecurityLayer securityLayer) {
        this.mOutputStream = new DataOutputStream(os);
        this.mSecurityLayer = securityLayer;
        this.mBuffer = new SaslOutputBuffer(securityLayer.getMaxSendSize());
    }

    public void write(byte[] b, int off, int len) throws IOException {
        SaslOutputStream.debug("write: enter len = %d", len);
        if ((off | len | off + len | b.length - (off + len)) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        int count = 0;
        while (count < len) {
            int n = this.writeBytes(b, off, len - count);
            off += n;
            SaslOutputStream.debug("write: loop n = %d, count = %d", n, count += n);
        }
        SaslOutputStream.debug("write: exit", new Object[0]);
    }

    public void write(int b) throws IOException {
        SaslOutputStream.debug("write: enter b = %d", b);
        this.ensureBuffer();
        this.mBuffer.put((byte)b);
    }

    private int writeBytes(byte[] b, int off, int len) throws IOException {
        this.ensureBuffer();
        ByteBuffer bb = ByteBuffer.wrap(b, off, len);
        this.mBuffer.put(bb);
        return bb.position();
    }

    private void ensureBuffer() throws IOException {
        if (this.mBuffer.isFull()) {
            this.flushBuffer();
        }
    }

    private void flushBuffer() throws IOException {
        byte[] b = this.mBuffer.wrap(this.mSecurityLayer);
        this.mOutputStream.writeInt(b.length);
        this.mOutputStream.write(b);
        this.mBuffer.clear();
    }

    public void flush() throws IOException {
        if (this.mBuffer.size() > 0) {
            this.flushBuffer();
        }
        this.mOutputStream.flush();
    }

    public void close() throws IOException {
        this.flush();
        this.mOutputStream.close();
    }

    private static void debug(String format, Object ... args) {
    }
}

