/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.security.sasl;

import com.zimbra.cs.mina.MinaUtil;
import com.zimbra.cs.security.sasl.SaslSecurityLayer;
import javax.security.sasl.SaslException;
import org.apache.mina.common.ByteBuffer;

public class SaslOutputBuffer {
    private final int mMaxSize;
    private java.nio.ByteBuffer mBuffer;
    private static final int MINSIZE = 512;

    public SaslOutputBuffer(int maxSize) {
        this(Math.min(512, maxSize), maxSize);
    }

    public SaslOutputBuffer(int minSize, int maxSize) {
        if (minSize > maxSize) {
            throw new IllegalArgumentException("minSize > maxSize");
        }
        this.mBuffer = java.nio.ByteBuffer.allocate(minSize);
        this.mMaxSize = maxSize;
    }

    public void put(ByteBuffer bb) {
        this.put(bb.buf());
    }

    public void put(java.nio.ByteBuffer bb) {
        if (this.isFull()) {
            return;
        }
        if (bb.remaining() > this.mBuffer.remaining()) {
            int minSize = Math.min(bb.remaining(), this.mMaxSize);
            this.mBuffer = MinaUtil.expand(this.mBuffer, minSize, this.mMaxSize);
        }
        int len = Math.min(this.mBuffer.remaining(), bb.remaining());
        int pos = this.mBuffer.position();
        bb.get(this.mBuffer.array(), pos, len);
        this.mBuffer.position(pos + len);
    }

    public void put(byte b) {
        if (this.isFull()) {
            return;
        }
        if (!this.mBuffer.hasRemaining()) {
            this.mBuffer = MinaUtil.expand(this.mBuffer, 1, this.mMaxSize);
        }
        this.mBuffer.put(b);
    }

    public int size() {
        return this.mBuffer.position();
    }

    public boolean isFull() {
        return this.mBuffer.position() >= this.mMaxSize;
    }

    public byte[] wrap(SaslSecurityLayer security) throws SaslException {
        return security.wrap(this.mBuffer.array(), 0, this.mBuffer.position());
    }

    public void clear() {
        this.mBuffer.clear();
    }
}

