/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.security.sasl;

import com.zimbra.cs.security.sasl.SaslSecurityLayer;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslServer;

public class SaslInputStream
extends InputStream {
    private final DataInputStream mInputStream;
    private final SaslSecurityLayer mSecurityLayer;
    private ByteBuffer mBuffer;
    private static final boolean DEBUG = false;

    public SaslInputStream(InputStream is, SaslServer server) {
        this(is, SaslSecurityLayer.getInstance(server));
    }

    public SaslInputStream(InputStream is, SaslClient client) {
        this(is, SaslSecurityLayer.getInstance(client));
    }

    public SaslInputStream(InputStream is, SaslSecurityLayer securityLayer) {
        this.mInputStream = new DataInputStream(is);
        this.mSecurityLayer = securityLayer;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        SaslInputStream.debug("read: enter len = %d", len);
        if ((off | len | off + len | b.length - (off + len)) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        if (!this.ensureBuffer()) {
            return -1;
        }
        if (len > this.mBuffer.remaining()) {
            len = this.mBuffer.remaining();
        }
        this.mBuffer.get(b, off, len);
        SaslInputStream.debug("read: exit len = %d", len);
        return len;
    }

    public int read() throws IOException {
        return this.ensureBuffer() ? (int)this.mBuffer.get() : -1;
    }

    private boolean ensureBuffer() throws IOException {
        if (this.mBuffer != null && this.mBuffer.hasRemaining()) {
            return true;
        }
        do {
            if (this.fillBuffer()) continue;
            return false;
        } while (!this.mBuffer.hasRemaining());
        return true;
    }

    private boolean fillBuffer() throws IOException {
        int len;
        try {
            len = this.mInputStream.readInt();
        }
        catch (EOFException e) {
            return false;
        }
        SaslInputStream.debug("fillBuffer: len = %d", len);
        if (len < 0) {
            throw new IOException("Invalid buffer length in stream");
        }
        byte[] b = new byte[len];
        this.mInputStream.readFully(b);
        this.mBuffer = ByteBuffer.wrap(this.mSecurityLayer.unwrap(b, 0, len));
        SaslInputStream.debug("fillBuffer: read finished", new Object[0]);
        return true;
    }

    public void close() throws IOException {
        this.mInputStream.close();
        this.mBuffer = null;
    }

    private static void debug(String format, Object ... args) {
    }
}

