/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.security.sasl;

import com.zimbra.cs.security.sasl.SaslSecurityLayer;
import javax.security.sasl.SaslException;
import org.apache.mina.common.ByteBuffer;

public class SaslInputBuffer {
    private final int mMaxSize;
    private final java.nio.ByteBuffer mLenBuffer;
    private java.nio.ByteBuffer mDataBuffer;

    public SaslInputBuffer(int maxSize) {
        this.mMaxSize = maxSize;
        this.mLenBuffer = java.nio.ByteBuffer.allocate(4);
    }

    public void put(ByteBuffer bb) throws SaslException {
        this.put(bb.buf());
    }

    public void put(java.nio.ByteBuffer bb) throws SaslException {
        if (this.isComplete()) {
            return;
        }
        if (this.mLenBuffer.hasRemaining() && !this.readLength(bb)) {
            return;
        }
        int len = Math.min(this.mDataBuffer.remaining(), bb.remaining());
        int pos = this.mDataBuffer.position();
        bb.get(this.mDataBuffer.array(), pos, len);
        this.mDataBuffer.position(pos + len);
    }

    public boolean isComplete() {
        return this.mDataBuffer != null && !this.mDataBuffer.hasRemaining();
    }

    public int getLength() {
        return this.mDataBuffer != null ? this.mDataBuffer.limit() : -1;
    }

    public int getRemaining() {
        return this.mDataBuffer != null ? this.mDataBuffer.remaining() : -1;
    }

    public byte[] unwrap(SaslSecurityLayer securityLayer) throws SaslException {
        if (!this.isComplete()) {
            throw new IllegalStateException("input not complete");
        }
        return securityLayer.unwrap(this.mDataBuffer.array(), 0, this.mDataBuffer.position());
    }

    public void clear() {
        this.mLenBuffer.clear();
        if (this.mDataBuffer != null) {
            this.mDataBuffer.clear();
        }
    }

    private boolean readLength(java.nio.ByteBuffer bb) throws SaslException {
        while (this.mLenBuffer.hasRemaining()) {
            if (!bb.hasRemaining()) {
                return false;
            }
            this.mLenBuffer.put(bb.get());
        }
        int len = this.mLenBuffer.getInt(0);
        if (len < 0 || len > this.mMaxSize) {
            throw new SaslException("Invalid receive buffer size '" + len + "' (max size = " + this.mMaxSize + ")");
        }
        if (this.mDataBuffer == null || this.mDataBuffer.capacity() < len) {
            this.mDataBuffer = java.nio.ByteBuffer.allocate(len);
        }
        this.mDataBuffer.limit(len);
        return true;
    }
}

