/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.security.sasl;

import com.zimbra.cs.security.sasl.SaslInputBuffer;
import com.zimbra.cs.security.sasl.SaslOutputBuffer;
import com.zimbra.cs.security.sasl.SaslSecurityLayer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslServer;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoFilterAdapter;
import org.apache.mina.common.IoFilterChain;
import org.apache.mina.common.IoSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SaslFilter
extends IoFilterAdapter {
    private final SaslSecurityLayer mSecurityLayer;
    private final SaslInputBuffer mInputBuffer;
    private final SaslOutputBuffer mOutputBuffer;
    private static final boolean DEBUG = false;
    public static final String DISABLE_ENCRYPTION_ONCE = SaslFilter.class.getName() + ".DisableEncryptionOnce";

    public SaslFilter(SaslServer server) {
        this(SaslSecurityLayer.getInstance(server));
    }

    public SaslFilter(SaslClient client) {
        this(SaslSecurityLayer.getInstance(client));
    }

    public SaslFilter(SaslSecurityLayer securityLayer) {
        this.mSecurityLayer = securityLayer;
        this.mInputBuffer = new SaslInputBuffer(securityLayer.getMaxRecvSize());
        this.mOutputBuffer = new SaslOutputBuffer(securityLayer.getMaxSendSize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageReceived(IoFilter.NextFilter nextFilter, IoSession session, Object message) throws IOException {
        ByteBuffer buf = (ByteBuffer)message;
        SaslFilter.debug("messageReceived: size = %d", buf.remaining());
        SaslInputBuffer saslInputBuffer = this.mInputBuffer;
        synchronized (saslInputBuffer) {
            while (buf.hasRemaining()) {
                SaslFilter.debug("messageReceived: remaining = %d", buf.remaining());
                this.mInputBuffer.put(buf);
                SaslFilter.debug("messageReceived: remaining = %d", buf.remaining());
                SaslFilter.debug("messageReceived: length = %d", this.mInputBuffer.getLength());
                if (!this.mInputBuffer.isComplete()) continue;
                SaslFilter.debug("messageReceived: input complete", new Object[0]);
                byte[] b = this.mInputBuffer.unwrap(this.mSecurityLayer);
                nextFilter.messageReceived(session, (Object)ByteBuffer.wrap((byte[])b));
                this.mInputBuffer.clear();
            }
        }
        buf.release();
    }

    public void filterWrite(IoFilter.NextFilter nextFilter, IoSession session, IoFilter.WriteRequest writeRequest) throws IOException {
        ByteBuffer buf = (ByteBuffer)writeRequest.getMessage();
        if (session.containsAttribute(DISABLE_ENCRYPTION_ONCE)) {
            SaslFilter.debug("filterWrite: before encryption size = %d", buf.remaining());
            session.removeAttribute(DISABLE_ENCRYPTION_ONCE);
            nextFilter.filterWrite(session, writeRequest);
            return;
        }
        SaslFilter.debug("filterWrite: message size = %d", buf.remaining());
        if (buf.remaining() == 0) {
            SaslFilter.debug("filterWrite: skipping encryption of empty buffer", new Object[0]);
            nextFilter.filterWrite(session, writeRequest);
            return;
        }
        List<ByteBuffer> buffers = this.encrypt(buf);
        buf.release();
        int size = buffers.size();
        for (int i = 0; i < size - 1; ++i) {
            nextFilter.filterWrite(session, new IoFilter.WriteRequest((Object)buffers.get(i)));
        }
        nextFilter.filterWrite(session, new IoFilter.WriteRequest((Object)buffers.get(size - 1), writeRequest.getFuture()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ByteBuffer> encrypt(ByteBuffer bb) throws IOException {
        SaslFilter.debug("encrypt enter: input buffer size = %d", bb.remaining());
        ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>(2);
        SaslOutputBuffer saslOutputBuffer = this.mOutputBuffer;
        synchronized (saslOutputBuffer) {
            do {
                this.mOutputBuffer.put(bb);
                byte[] b = this.mOutputBuffer.wrap(this.mSecurityLayer);
                SaslFilter.debug("encrypt wrap: encrypted buffer size = %d", b.length);
                buffers.add(ByteBuffer.allocate((int)4).putInt(b.length).flip());
                buffers.add(ByteBuffer.wrap((byte[])b));
                this.mOutputBuffer.clear();
            } while (bb.hasRemaining());
        }
        SaslFilter.debug("encrypt exit: buffer count = %d", buffers.size());
        return buffers;
    }

    public void onPostRemove(IoFilterChain parent, String name, IoFilter.NextFilter nextFilter) throws IOException {
        SaslFilter.debug("onPostRemove: enter", new Object[0]);
        this.mSecurityLayer.dispose();
    }

    private static void debug(String format, Object ... args) {
    }
}

