/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.security.sasl;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.auth.AuthContext;
import com.zimbra.cs.security.sasl.Authenticator;
import com.zimbra.cs.security.sasl.AuthenticatorUser;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import javax.security.sasl.SaslServer;

public class PlainAuthenticator
extends Authenticator {
    public static final String MECHANISM = "PLAIN";

    public PlainAuthenticator(AuthenticatorUser user) {
        super(MECHANISM, user);
    }

    protected boolean isSupported() {
        return this.mAuthUser.isSSLEnabled() || this.mAuthUser.allowCleartextLogin();
    }

    public boolean initialize() {
        return true;
    }

    public void dispose() {
    }

    public boolean isEncryptionEnabled() {
        return false;
    }

    public InputStream unwrap(InputStream is) {
        return null;
    }

    public OutputStream wrap(OutputStream os) {
        return null;
    }

    public SaslServer getSaslServer() {
        return null;
    }

    public void handle(byte[] data) throws IOException {
        if (this.isComplete()) {
            throw new IllegalStateException("Authentication already completed");
        }
        String message = new String(data, "utf-8");
        int nul1 = message.indexOf(0);
        int nul2 = message.indexOf(0, nul1 + 1);
        if (nul1 == -1 || nul2 == -1) {
            this.sendBadRequest();
            return;
        }
        String authorizeId = message.substring(0, nul1);
        String authenticateId = message.substring(nul1 + 1, nul2);
        String password = message.substring(nul2 + 1);
        this.authenticate(authorizeId, authenticateId, password);
    }

    public Account authenticate(String username, String authenticateId, String password, AuthContext.Protocol protocol, String origRemoteIp, String userAgent) throws ServiceException {
        Provisioning prov = Provisioning.getInstance();
        Account authAccount = prov.get(Provisioning.AccountBy.name, authenticateId);
        if (authAccount == null) {
            ZimbraLog.account.info("authentication failed for " + authenticateId + " (no such account)");
            return null;
        }
        HashMap<String, Object> authCtxt = new HashMap<String, Object>();
        authCtxt.put("ocip", origRemoteIp);
        authCtxt.put("anp", authenticateId);
        authCtxt.put("ua", userAgent);
        prov.authAccount(authAccount, password, protocol, authCtxt);
        return this.authorize(authAccount, username, true);
    }
}

