/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.security.sasl;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.auth.AuthContext;
import com.zimbra.cs.security.kerberos.Krb5Keytab;
import com.zimbra.cs.security.sasl.Authenticator;
import com.zimbra.cs.security.sasl.AuthenticatorUser;
import com.zimbra.cs.security.sasl.SaslInputStream;
import com.zimbra.cs.security.sasl.SaslOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.kerberos.KerberosKey;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.apache.commons.codec.binary.Base64;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GssAuthenticator
extends Authenticator {
    private SaslServer mSaslServer;
    private boolean mEncryptionEnabled;
    private static final String QOP_AUTH = "auth";
    private static final String QOP_AUTH_INT = "auth-int";
    private static final String QOP_AUTH_CONF = "auth-conf";
    private static final int MAX_RECEIVE_SIZE = 4096;
    private static final int MAX_SEND_SIZE = 4096;
    public static final String KRB5_DEBUG_ENABLED_PROP = "ZimbraKrb5DebugEnabled";
    private static final boolean DEBUG = LC.krb5_debug_enabled.booleanValue() || Boolean.getBoolean("ZimbraKrb5DebugEnabled");
    public static final String MECHANISM = "GSSAPI";
    private static final Boolean GSS_ENABLED = Boolean.getBoolean("ZimbraGssEnabled");
    private static final Map<String, String> ENCRYPTION_PROPS = new HashMap<String, String>();

    public GssAuthenticator(AuthenticatorUser user) {
        super(MECHANISM, user);
    }

    @Override
    protected boolean isSupported() {
        if (!GSS_ENABLED.booleanValue() && !this.mAuthUser.isGssapiAvailable()) {
            return false;
        }
        try {
            return this.mAuthUser.isSSLEnabled() || !Provisioning.getInstance().getLocalServer().getBooleanAttr("zimbraSaslGssapiRequiresTls", false);
        }
        catch (ServiceException e) {
            ZimbraLog.security.warn((Object)"could not determine whether TLS encryption is required for GSSAPI auth; defaulting to FALSE", e);
            return false;
        }
    }

    @Override
    public boolean initialize() throws IOException {
        String host;
        Krb5Keytab keytab = this.getKeytab(LC.krb5_keytab.value());
        if (keytab == null) {
            this.sendFailed("mechanism not supported");
            return false;
        }
        GssAuthenticator.debug("keytab file = %s", keytab.getFile());
        if (LC.krb5_service_principal_from_interface_address.booleanValue()) {
            String localSocketHostname = this.mConnection.getLocalAddress().getCanonicalHostName().toLowerCase();
            if (localSocketHostname.length() == 0 || Character.isDigit(localSocketHostname.charAt(0))) {
                localSocketHostname = LC.zimbra_server_hostname.value();
            }
            host = localSocketHostname;
        } else {
            host = LC.zimbra_server_hostname.value();
        }
        KerberosPrincipal kp = new KerberosPrincipal(this.getProtocol() + '/' + host);
        GssAuthenticator.debug("kerberos principal = %s", kp);
        Subject subject = this.getSubject(keytab, kp);
        if (subject == null) {
            this.sendFailed();
            return false;
        }
        GssAuthenticator.debug("subject = %s", subject);
        final Map<String, String> props = this.getSaslProperties();
        if (DEBUG && props != null) {
            String qop = props.get("javax.security.sasl.qop");
            GssAuthenticator.debug("Sent QOP = " + (qop != null ? qop : QOP_AUTH), new Object[0]);
        }
        try {
            this.mSaslServer = (SaslServer)Subject.doAs(subject, new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws SaslException {
                    return Sasl.createSaslServer(GssAuthenticator.this.getMechanism(), GssAuthenticator.this.getProtocol(), host, props, new GssCallbackHandler());
                }
            });
        }
        catch (PrivilegedActionException e) {
            this.sendFailed();
            this.getLog().warn((Object)"Could not create SaslServer", e.getCause());
            return false;
        }
        return true;
    }

    private Krb5Keytab getKeytab(String path) {
        try {
            return Krb5Keytab.getInstance(path);
        }
        catch (IOException e) {
            this.getLog().warn("Keytab file '" + path + "' not found");
            return null;
        }
    }

    private Subject getSubject(Krb5Keytab keytab, KerberosPrincipal kp) throws IOException {
        List<KerberosKey> keys = keytab.getKeys(kp);
        if (keys == null) {
            this.getLog().warn("Key not found in keystore for service principal '" + kp + "'");
            return null;
        }
        Subject subject = new Subject();
        subject.getPrincipals().add(kp);
        subject.getPrivateCredentials().addAll(keys);
        return subject;
    }

    @Override
    public void handle(byte[] data) throws IOException {
        byte[] bytes;
        if (this.isComplete()) {
            throw new IllegalStateException("Authentication already completed");
        }
        try {
            bytes = this.mSaslServer.evaluateResponse(data);
        }
        catch (SaslException e) {
            ZimbraLog.imap.warn((Object)"SaslServer.evaluateResponse() failed", e);
            if (!this.isComplete()) {
                this.sendBadRequest();
            }
            return;
        }
        if (!this.isComplete()) {
            assert (!this.mSaslServer.isComplete());
            String s = new String(Base64.encodeBase64((byte[])bytes), "US-ASCII");
            this.sendContinuation(s);
            return;
        }
        assert (this.mSaslServer.isComplete());
        if (DEBUG) {
            this.dumpNegotiatedProperties();
        }
        if (!this.isAuthenticated()) {
            GssAuthenticator.debug("Authentication failed", new Object[0]);
            this.dispose();
            return;
        }
        String qop = (String)this.mSaslServer.getNegotiatedProperty("javax.security.sasl.qop");
        if (QOP_AUTH_INT.equals(qop) || QOP_AUTH_CONF.equals(qop)) {
            GssAuthenticator.debug("SASL encryption enabled (%s)", qop);
            this.mEncryptionEnabled = true;
        } else {
            this.dispose();
        }
    }

    @Override
    public Account authenticate(String username, String principal, String unused, AuthContext.Protocol protocol, String origRemoteIp, String userAgent) throws ServiceException {
        Provisioning prov = Provisioning.getInstance();
        Account authAccount = prov.get(Provisioning.AccountBy.krb5Principal, principal);
        if (authAccount == null) {
            ZimbraLog.account.warn("authentication failed (no account associated with Kerberos principal " + principal + ')');
            return null;
        }
        Account targetAcct = this.authorize(authAccount, username, true);
        if (targetAcct != null) {
            prov.accountAuthed(authAccount);
        }
        return targetAcct;
    }

    private Map<String, String> getSaslProperties() {
        return this.mAuthUser.isSSLEnabled() ? null : ENCRYPTION_PROPS;
    }

    @Override
    public boolean isEncryptionEnabled() {
        return this.mEncryptionEnabled;
    }

    @Override
    public InputStream unwrap(InputStream is) {
        return new SaslInputStream(is, this.mSaslServer);
    }

    @Override
    public OutputStream wrap(OutputStream os) {
        return new SaslOutputStream(os, this.mSaslServer);
    }

    @Override
    public SaslServer getSaslServer() {
        return this.mSaslServer;
    }

    @Override
    public void dispose() {
        GssAuthenticator.debug("dispose called", new Object[0]);
        try {
            this.mSaslServer.dispose();
        }
        catch (SaslException e) {
            ZimbraLog.imap.warn((Object)"SaslServer.dispose() failed", e);
        }
    }

    private void dumpNegotiatedProperties() {
        this.pp("QOP", "javax.security.sasl.qop");
        this.pp("MAX_BUFFER", "javax.security.sasl.maxbuffer");
        this.pp("MAX_RECEIVE_SIZE", "javax.security.sasl.rawsendsize");
        this.pp("STRENGTH", "javax.security.sasl.strength");
    }

    private void pp(String printName, String propName) {
        Object obj = this.mSaslServer.getNegotiatedProperty(propName);
        if (obj != null) {
            GssAuthenticator.debug("Negotiated property %s = %s", printName, obj);
        }
    }

    static void debug(String format, Object ... args) {
        if (DEBUG) {
            System.out.printf("[DEBUG GssAuthenticator] " + format + "\n", args);
        }
    }

    static {
        ENCRYPTION_PROPS.put("javax.security.sasl.qop", "auth,auth-int,auth-conf");
        ENCRYPTION_PROPS.put("javax.security.sasl.maxbuffer", String.valueOf(4096));
        ENCRYPTION_PROPS.put("javax.security.sasl.rawsendsize", String.valueOf(4096));
        if (DEBUG) {
            System.setProperty("sun.security.krb5.debug", "true");
            System.setProperty("sun.security.jgss.debug", "true");
        }
    }

    private class GssCallbackHandler
    implements CallbackHandler {
        GssCallbackHandler() {
        }

        public void handle(Callback[] cbs) throws IOException, UnsupportedCallbackException {
            if (cbs == null || cbs.length != 1) {
                throw new IOException("Bad callback");
            }
            if (!(cbs[0] instanceof AuthorizeCallback)) {
                throw new UnsupportedCallbackException(cbs[0]);
            }
            AuthorizeCallback cb = (AuthorizeCallback)cbs[0];
            GssAuthenticator.debug("gss authorization_id = %s", cb.getAuthorizationID());
            GssAuthenticator.debug("gss authentication_id = %s", cb.getAuthenticationID());
            cb.setAuthorized(GssAuthenticator.this.authenticate(cb.getAuthorizationID(), cb.getAuthenticationID(), null));
        }
    }
}

